/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.lexicon;

import com.tridium.platform.command.BIPlatformCommand;
import com.tridium.sys.module.BModuleFile;
import com.tridium.util.CommandLineArguments;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

@NiagaraType
public class BLexiconMigrator
extends BObject
implements BIPlatformCommand {
    public static final Type TYPE = Sys.loadType(BLexiconMigrator.class);
    private File defaultFolder = Sys.getNiagaraUserHome();
    private String newVersion = "";

    public Type getType() {
        return TYPE;
    }

    public void usage() {
        BLexiconMigrator.println("");
        BLexiconMigrator.println("usage:");
        BLexiconMigrator.println("  plat lexmigrate <flags>");
        BLexiconMigrator.println("required flags:");
        BLexiconMigrator.println("  -src:<filePath>      path of a local lexicon file");
        BLexiconMigrator.println("                       some helpful hints for paths:");
        BLexiconMigrator.println("                       '!' is the Niagara system home");
        BLexiconMigrator.println("                       '~' is the Niagara user home");
        BLexiconMigrator.println("                       '/' is the absolute home on the local system");
        BLexiconMigrator.println("optional flags:");
        BLexiconMigrator.println("  -dest:<folderPath>   path of destination folder");
        BLexiconMigrator.println("                       if omitted, default destination is the Niagara user home folder");
        BLexiconMigrator.println("  -lexversion:<version> version to set on the migrated module");
        BLexiconMigrator.println("                       if omitted, the version will be the same as the original module");
        BLexiconMigrator.println("");
    }

    public int invoke(CommandLineArguments args) throws Exception {
        BIFile destinationFile;
        String pathString = args.getOption("src");
        if (pathString == null) {
            this.usage();
            return 2;
        }
        BIFile file = BFileSystem.INSTANCE.findFile(new FilePath(pathString));
        if (file == null) {
            throw new BajaRuntimeException("File not found");
        }
        if (!(file instanceof BModuleFile)) {
            throw new BajaRuntimeException("File is not a module");
        }
        File destinationFolder = this.defaultFolder;
        String destinationPath = args.getOption("dest", "");
        if (destinationPath.length() != 0 && !(destinationFolder = BFileSystem.INSTANCE.pathToLocalFile((destinationFile = BFileSystem.INSTANCE.findFile(new FilePath(destinationPath))).getFilePath())).isDirectory()) {
            throw new BajaRuntimeException("Destination folder is not a directory");
        }
        String version = args.getOption("lexversion", "");
        if (version.length() != 0) {
            this.newVersion = version;
        }
        if (!this.isExistingModuleValid(file)) {
            throw new BajaRuntimeException("Module is not recognized as valid.");
        }
        File source = BFileSystem.INSTANCE.pathToLocalFile(file.getFilePath());
        File destination = new File(destinationFolder, source.getName());
        try (ZipFile sourceFile = new ZipFile(source.getAbsolutePath());
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destination));){
            sourceFile.stream().forEach(sourceEntry -> this.writeToDestinationZip(zos, sourceFile, (ZipEntry)sourceEntry));
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Migration failed to generate new module file");
        }
        return 0;
    }

    public String getCommandName() {
        return "lexmigrate";
    }

    public boolean includeInCommandListing() {
        return false;
    }

    public String getCommandDescription() {
        return "plat lexmigrate -src:<filePath> -dest:<folderPath>";
    }

    public String getLicenseVendor() {
        return null;
    }

    public String getLicenseFeature() {
        return null;
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private boolean isExistingModuleValid(BIFile moduleBIFile) {
        boolean valid = true;
        FilePath fp = moduleBIFile.getFilePath();
        File moduleFile = BFileSystem.INSTANCE.pathToLocalFile(fp);
        try (ZipFile moduleJar = new ZipFile(moduleFile);){
            ZipEntry zipEntry = moduleJar.getEntry("META-INF/module.xml");
            if (zipEntry == null) {
                zipEntry = moduleJar.getEntry("meta-inf/module.xml");
            }
            if (zipEntry == null) {
                throw new BajaRuntimeException("Module does not include manifest.");
            }
            XElem manifest = XParser.make((InputStream)moduleJar.getInputStream(zipEntry)).parse();
            Enumeration<? extends ZipEntry> entries = moduleJar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipFile = entries.nextElement();
                if (!zipFile.getName().endsWith(".class")) continue;
                throw new BajaRuntimeException("Lexicon module cannot contain Java class files.");
            }
        }
        catch (ModuleNotFoundException e) {
            throw new BajaRuntimeException("Module was not found.");
        }
        catch (ModuleException e) {
            throw new BajaRuntimeException("Module is invalid.");
        }
        catch (BajaRuntimeException e) {
            throw new BajaRuntimeException(e.getMessage());
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Module contents could not be parsed.");
        }
        return valid;
    }

    private void writeToDestinationZip(ZipOutputStream zos, ZipFile sourceModule, ZipEntry sourceEntry) {
        try {
            if (sourceEntry.getName().equalsIgnoreCase("meta-inf/module.xml")) {
                XElem moduleXml = this.generateModuleXml(sourceModule, sourceEntry);
                zos.putNextEntry(new ZipEntry("META-INF/module.xml"));
                XWriter xwriter = new XWriter((OutputStream)zos);
                xwriter.write("<?xml version='1.0'?>\n");
                moduleXml.write(xwriter);
                xwriter.flush();
                zos.closeEntry();
            } else {
                if (sourceEntry.getName().equalsIgnoreCase("meta-inf/manifest.mf")) {
                    zos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                } else {
                    zos.putNextEntry(new ZipEntry(sourceEntry));
                }
                InputStream in = sourceModule.getInputStream(sourceEntry);
                byte[] buffer = new byte[512];
                while (0 < in.available()) {
                    int read = in.read(buffer);
                    zos.write(buffer, 0, read);
                }
                in.close();
                zos.closeEntry();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XElem generateModuleXml(ZipFile moduleJar, ZipEntry zipEntry) {
        XElem rootElem = new XElem("module");
        try (InputStream inputStream = moduleJar.getInputStream(zipEntry);){
            XElem lexicons;
            XElem def;
            XElem dependElem;
            XElem manifest = XParser.make((InputStream)inputStream).parse();
            rootElem.addAttr("name", manifest.attrValue(manifest.attrIndex("name")));
            rootElem.addAttr("bajaVersion", "0");
            rootElem.addAttr("vendor", manifest.attrValue(manifest.attrIndex("vendor")));
            if (this.newVersion != null && this.newVersion.length() > 0) {
                rootElem.addAttr("vendorVersion", this.newVersion);
            } else {
                rootElem.addAttr("vendorVersion", manifest.attrValue(manifest.attrIndex("vendorVersion")));
            }
            rootElem.addAttr("description", manifest.attrValue(manifest.attrIndex("description")));
            rootElem.addAttr("preferredSymbol", manifest.attrValue(manifest.attrIndex("preferredSymbol")));
            rootElem.addAttr("nre", "true");
            rootElem.addAttr("installable", "true");
            rootElem.addAttr("autoload", "true");
            rootElem.addAttr("buildMillis", String.valueOf(System.currentTimeMillis()));
            rootElem.addAttr("buildHost", Sys.getHostName());
            rootElem.addAttr("moduleName", manifest.attrValue(manifest.attrIndex("name")));
            rootElem.addAttr("runtimeProfile", "rt");
            XElem dependencies = manifest.elem("dependencies");
            XElem bajaDependency = new XElem("dependency");
            bajaDependency.addAttr("name", "baja");
            bajaDependency.addAttr("vendor", "Tridium");
            bajaDependency.addAttr("vendorVersion", "4.0");
            if (dependencies != null) {
                XElem[] dependencyElems;
                dependElem = dependencies.copy();
                boolean bajaDependencyFound = false;
                for (XElem dependency : dependencyElems = dependencies.elems()) {
                    if (dependency.attrIndex("name") < 0 || !dependency.attrValue(dependency.attrIndex("name")).equalsIgnoreCase("baja")) continue;
                    bajaDependencyFound = true;
                    break;
                }
                if (!bajaDependencyFound) {
                    dependElem.addContent((XContent)bajaDependency);
                }
                rootElem.addContent((XContent)dependElem);
            } else {
                dependElem = new XElem("dependencies");
                dependElem.addContent((XContent)bajaDependency);
                rootElem.addContent((XContent)dependElem);
            }
            XElem dirs = manifest.elem("dirs");
            if (dirs != null) {
                rootElem.addContent((XContent)dirs.copy());
            }
            if ((def = manifest.elem("def")) != null) {
                rootElem.addContent((XContent)def.copy());
            }
            if ((lexicons = manifest.elem("lexicons")) != null) {
                rootElem.addContent((XContent)lexicons.copy());
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Failed to generate new module.xml manifest");
        }
        return rootElem;
    }
}

