/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.ldap;

import com.tridium.migrator.Migrate;
import com.tridium.nre.security.AESDecryptFunction;
import com.tridium.nre.security.SecretBytes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.baja.migration.BFileMigrator;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BKeytabMigrator
extends BFileMigrator {
    public static final Type TYPE = Sys.loadType(BKeytabMigrator.class);
    private static final String ENCRYPTION_PREFIX = "[aes]";

    public Type getType() {
        return TYPE;
    }

    public String[] getMigrateDirs() {
        return new String[]{"ldap"};
    }

    public Optional<String> migrate() throws Exception {
        File[] srcFiles = this.source.listFiles();
        if (srcFiles == null) {
            return Optional.empty();
        }
        AESDecryptFunction decryptFunction = Migrate.getPasswordDecryptFunction();
        if (decryptFunction == null) {
            this.log.warning("Cannot decrypt keytabs, decrypt function unavailable.");
            FileUtil.copy((File)this.source, (File)this.target);
            return Optional.empty();
        }
        for (File f : srcFiles) {
            if (f.isDirectory()) continue;
            String contents = FileUtil.readString((File)f);
            if (contents.startsWith(ENCRYPTION_PREFIX)) {
                contents = contents.replace(ENCRYPTION_PREFIX, "");
                String[] ivCipher = contents.split(":");
                byte[] ivBytes = ByteArrayUtil.hexStringToBytes((String)ivCipher[0]);
                byte[] cipherBytes = ByteArrayUtil.hexStringToBytes((String)ivCipher[1]);
                SecretBytes raw = null;
                try {
                    raw = decryptFunction.decrypt(cipherBytes, ivBytes, "AES/CBC/PKCS5Padding");
                }
                catch (Exception e) {
                    this.log.warning("Keytab file " + f.getPath() + " could not be decrypted: " + e);
                    FileUtil.copy((File)f, (File)new File(this.target, f.getName()));
                    continue;
                }
                try (FileOutputStream out = new FileOutputStream(new File(this.target, f.getName()));){
                    ((OutputStream)out).write(raw.get());
                    raw.close();
                    this.log.info("Keytab file " + f.getPath() + " successfully decrypted.");
                    continue;
                }
            }
            FileUtil.copy((File)f, (File)new File(this.target, f.getName()));
        }
        return Optional.empty();
    }
}

