/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.jetty;

import com.tridium.jetty.BJettyWebServer;
import com.tridium.migrator.baja.BRestrictedServiceConverter;
import java.util.ArrayList;
import java.util.List;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.web.BWebService;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

@NiagaraType
public class BWebServiceConverter
extends BObject
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BWebServiceConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();
    private boolean logFileEnabled;
    private int httpPort = 80;
    private int httpsPort = 443;
    private boolean requireStrongCipherSuites = true;

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeSpecName, Version sourceVersion) throws Exception {
        XElem[] kids;
        for (XElem kid : kids = x.elems()) {
            String name;
            switch (name = kid.get("n", "-")) {
                case "logFileEnabled": {
                    this.logFileEnabled = kid.getb("v", false);
                    break;
                }
                case "httpsMinProtocol": {
                    kid.setAttr("v", "tlsv1");
                    break;
                }
                case "httpPort": {
                    if (kid.get("t", "null").endsWith(":ServerPort")) {
                        this.httpPort = -1;
                        break;
                    }
                    this.httpPort = kid.geti("v", 80);
                    x.removeContent((XContent)kid);
                    break;
                }
                case "httpsPort": {
                    if (kid.get("t", "null").endsWith(":ServerPort")) {
                        this.httpsPort = -1;
                        break;
                    }
                    this.httpsPort = kid.geti("v", 443);
                    x.removeContent((XContent)kid);
                    break;
                }
                case "tunnelingEnabled": 
                case "authenticationScheme": {
                    x.removeContent((XContent)kid);
                    break;
                }
                case "requireStrongCipherSuites": {
                    this.requireStrongCipherSuites = kid.getb("v", true);
                    x.removeContent((XContent)kid);
                }
            }
            switch (name) {
                case "httpsPort": 
                case "httpsEnabled": 
                case "httpsOnly": 
                case "httpsMinProtocol": 
                case "httpsCert": {
                    this.fixFlags(kid);
                }
            }
        }
        return x;
    }

    void fixFlags(XElem kid) {
        String f = kid.get("f", "");
        if (f.length() == 0) {
            return;
        }
        f = f.replace("r", "");
        f = f.replace("h", "");
        kid.setAttr("f", f);
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) {
        if (!(toConvert instanceof BWebService)) {
            return;
        }
        BRestrictedServiceConverter.checkRestrictedService(root, toConvert);
        BWebService webService = (BWebService)toConvert;
        if (this.httpPort != -1) {
            webService.getHttpPort().setPublicServerPort(this.httpPort);
        }
        if (this.httpsPort != -1) {
            webService.getHttpsPort().setPublicServerPort(this.httpsPort);
        }
        if (this.requireStrongCipherSuites) {
            webService.setCipherSuiteGroup(BTlsCipherSuiteGroup.recommended);
        } else {
            webService.setCipherSuiteGroup(BTlsCipherSuiteGroup.supported);
        }
        if (webService.getWebServer() == null) {
            log.info("WebServiceConverter: adding JettyWebServer to component " + webService + " [" + webService.getType() + "]");
            BJettyWebServer jws = new BJettyWebServer();
            if (this.logFileEnabled) {
                log.info("Setting JettyWebServer NCSALog to enabled");
            }
            jws.getNCSALog().setEnabled(this.logFileEnabled);
            webService.add("JettyWebServer", (BValue)jws);
        }
    }

    static {
        convertTypes.add("web:WebService");
    }
}

