/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.fox;

import com.tridium.fox.sys.BFoxService;
import com.tridium.migrator.MigrationUtils;
import com.tridium.util.ComponentTreeCursor;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XWriter;

@NiagaraType
public class BFoxServiceConverter
extends BComponent
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BFoxServiceConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();
    private BServiceContainer services = null;
    private BComponent niagaraNetwork = null;
    private XElem niagaraFoxServiceElem = null;
    private int foxPort = 1911;
    private int foxsPort = 4911;
    private boolean requireStrongCipherSuites = false;

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeSpecName, Version sourceVersion) {
        block32: {
            String[] moduleAndType;
            block31: {
                moduleAndType = typeSpecName.split(":");
                if (!moduleAndType[0].equals("niagaraDriver")) break block31;
                if (moduleAndType[1].equals("NiagaraFoxService")) {
                    this.niagaraFoxServiceElem = x;
                    this.niagaraFoxServiceElem.setAttr("m", "fox=fox");
                    this.niagaraFoxServiceElem.setAttr("t", "fox:FoxService");
                    block16: for (XElem el : this.niagaraFoxServiceElem.elems()) {
                        String elemName;
                        switch (elemName = el.get("n", "")) {
                            case "foxsMinProtocol": {
                                el.setAttr("v", "tlsv1");
                                continue block16;
                            }
                            case "port": {
                                if (el.get("t", "null").endsWith(":ServerPort")) {
                                    this.foxPort = -1;
                                    continue block16;
                                }
                                this.foxPort = el.geti("v", 1911);
                                this.niagaraFoxServiceElem.removeContent((XContent)el);
                                continue block16;
                            }
                            case "foxsPort": {
                                if (el.get("t", "null").endsWith(":ServerPort")) {
                                    this.foxsPort = -1;
                                    continue block16;
                                }
                                this.foxsPort = el.geti("v", 4911);
                                this.niagaraFoxServiceElem.removeContent((XContent)el);
                                continue block16;
                            }
                            case "tunnelingEnabled": 
                            case "onlyTunnelKnownStations": 
                            case "authenticationPolicy": {
                                this.niagaraFoxServiceElem.removeContent((XContent)el);
                                continue block16;
                            }
                            case "requireStrongCipherSuites": {
                                this.requireStrongCipherSuites = el.getb("v", false);
                                this.niagaraFoxServiceElem.removeContent((XContent)el);
                            }
                        }
                    }
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config("Found NiagaraFoxService:" + x + "\n" + MigrationUtils.dumpToString(x));
                    }
                    return BIBogElementConverter.typeRemoved((String)typeSpecName);
                }
                if (!moduleAndType[1].equals("LocalSysDefStation") && !moduleAndType[1].equals("ProviderStation")) break block32;
                for (XElem sysDefStationProp : x.elems("p")) {
                    if (!sysDefStationProp.get("n").equals("services")) continue;
                    sysDefStationProp.setAttr("v", sysDefStationProp.get("v").replace("niagaraDriver$3aNiagaraFoxService;", "fox$3aFoxService;"));
                    break;
                }
                for (XElem el : x.elems()) {
                    if (!el.get("n").equals("foxTunneling") && !el.get("n").equals("httpTunneling") && !el.get("n").equals("onlyTunnelKnownStations") && !el.get("n").equals("proxyAuthenticationWhenTunneling")) continue;
                    x.removeContent((XContent)el);
                }
                break block32;
            }
            if (moduleAndType[0].equals("fox") && moduleAndType[1].equals("FoxService")) {
                for (XElem el : x.elems()) {
                    if (el.get("n").equals("tunnelingEnabled") || el.get("n").equals("onlyTunnelKnownStations")) {
                        x.removeContent((XContent)el);
                        continue;
                    }
                    if (el.get("n").equals("foxsMinProtocol")) {
                        el.setAttr("v", "tlsv1");
                        continue;
                    }
                    if (el.get("n").equals("port")) {
                        if (el.get("t", "null").endsWith(":ServerPort")) {
                            this.foxPort = -1;
                            continue;
                        }
                        this.foxPort = el.geti("v", 1911);
                        x.removeContent((XContent)el);
                        continue;
                    }
                    if (el.get("n").equals("foxsPort")) {
                        if (el.get("t", "null").endsWith(":ServerPort")) {
                            this.foxsPort = -1;
                            continue;
                        }
                        this.foxsPort = el.geti("v", 4911);
                        x.removeContent((XContent)el);
                        continue;
                    }
                    if (!el.get("n").equals("requireStrongCipherSuites")) continue;
                    this.requireStrongCipherSuites = el.getb("v", false);
                    x.removeContent((XContent)el);
                }
            }
        }
        return x;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) throws Exception {
        BFoxService newFoxService;
        SlotCursor c;
        ComponentTreeCursor ctc = new ComponentTreeCursor(root, null);
        while (ctc.nextComponent()) {
            BComponent c2 = ctc.get().asComponent();
            if (this.services == null && c2.getType().is(BServiceContainer.TYPE)) {
                this.services = (BServiceContainer)c2.as(BServiceContainer.class);
                if (!this.readyToMigrate()) continue;
                break;
            }
            if (!c2.getType().getTypeSpec().toString().equals("niagaraDriver:NiagaraNetwork")) continue;
            this.niagaraNetwork = c2;
            if (!this.readyToMigrate()) continue;
            break;
        }
        if ((c = this.services.getProperties()).next(BFoxService.class)) {
            newFoxService = (BFoxService)c.get();
        } else {
            newFoxService = new BFoxService();
            log.info("Installing new FoxService in Services Container");
            newFoxService = (BFoxService)this.services.get(this.services.add(newFoxService.getType().getTypeName(), (BValue)newFoxService));
        }
        if (this.niagaraFoxServiceElem != null) {
            if (toConvert instanceof BFoxService) {
                log.info("Installing migrated FoxService in Services Container");
            }
            this.setFoxServiceFromElem(newFoxService, this.niagaraFoxServiceElem, resolver);
        }
        if (this.foxPort != -1) {
            newFoxService.getFoxPort().setPublicServerPort(this.foxPort);
        }
        if (this.foxsPort != -1) {
            newFoxService.getFoxsPort().setPublicServerPort(this.foxsPort);
        }
        if (this.requireStrongCipherSuites) {
            newFoxService.setCipherSuiteGroup(BTlsCipherSuiteGroup.recommended);
        } else {
            newFoxService.setCipherSuiteGroup(BTlsCipherSuiteGroup.supported);
        }
    }

    public String newTypeSpec(String typeSpecName) {
        if (typeSpecName.equals("niagaraDriver:NiagaraFoxService")) {
            return "fox:FoxService";
        }
        return typeSpecName;
    }

    private boolean readyToMigrate() {
        return this.services != null && this.niagaraNetwork != null;
    }

    private void setFoxServiceFromElem(BFoxService fox, XElem x, ValueDocDecoder.ITypeResolver resolver) throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             XWriter xw = new XWriter((OutputStream)os);){
            x.write(xw);
            xw.flush();
            String s = os.toString();
            BValue value = ValueDocDecoder.unmarshal((String)s, (ValueDocDecoder.ITypeResolver)resolver);
            fox.copyFrom(value.asComplex());
        }
    }

    static {
        convertTypes.add("fox:FoxService");
        convertTypes.add("niagaraDriver:NiagaraFoxService");
        convertTypes.add("niagaraDriver:LocalSysDefStation");
        convertTypes.add("niagaraDriver:ProviderStation");
    }
}

