/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.baja;

import com.tridium.nre.security.AESDecryptFunction;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SimpleKeyRing;
import com.tridium.nre.security.io.AESStreamEncryption;
import com.tridium.nre.security.km.KeyMaterial;
import com.tridium.nre.security.km.KeyMaterialFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.baja.nre.util.FileUtil;

public class MigrationEncoding {
    public static AESDecryptFunction makeMigrationDecryptFunction(File niagaraSecurityDir) throws Exception {
        try {
            AccessController.doPrivileged(() -> {
                String keyRingName = ".kr";
                String keyMaterialName = ".km";
                byte[] encryptionKey = new byte[32];
                new SecureRandom().nextBytes(encryptionKey);
                KeyMaterialFactory factory = KeyMaterialFactory.getInstance((File)niagaraSecurityDir, (String)keyMaterialName);
                KeyMaterial keyMaterial = factory.getKeyMaterial();
                File keyRingFile = new File(niagaraSecurityDir, keyRingName);
                int importDataLen = -1;
                if (keyRingFile.exists()) {
                    InputStream importData;
                    block54: {
                        if (AESStreamEncryption.isEncrypted((File)keyRingFile)) {
                            File exportFile = MigrationEncoding.renameToExport(keyRingFile);
                            importData = new FileInputStream(MigrationEncoding.renameToExport(keyRingFile));
                            importDataLen = (int)exportFile.length();
                        } else {
                            try (FileInputStream inRaw = new FileInputStream(keyRingFile);
                                 ObjectInputStream oin = new ObjectInputStream(inRaw);){
                                int version = oin.readInt();
                                if (SimpleKeyRing.SUPPORTED_VERSIONS.contains(version)) {
                                    importData = null;
                                    break block54;
                                }
                                if (SimpleKeyRing.SUPPORTED_EXPORT_VERSIONS.contains(version)) {
                                    inRaw.close();
                                    ByteArrayOutputStream exportBytesUnencrytped = new ByteArrayOutputStream();
                                    try (FileInputStream exportInRaw = new FileInputStream(MigrationEncoding.renameToExport(keyRingFile));
                                         BufferedInputStream exportIn = new BufferedInputStream(exportInRaw);){
                                        FileUtil.pipe((InputStream)exportIn, (OutputStream)exportBytesUnencrytped);
                                    }
                                    byte[] ivBytes = new byte[16];
                                    new SecureRandom().nextBytes(ivBytes);
                                    byte[] encryptedData = Aes256PasswordManager.encrypt((byte[])exportBytesUnencrytped.toByteArray(), (byte[])ivBytes, (byte[])encryptionKey);
                                    byte[] encryptedContents = Arrays.copyOf(ivBytes, ivBytes.length + encryptedData.length);
                                    System.arraycopy(encryptedData, 0, encryptedContents, ivBytes.length, encryptedData.length);
                                    importData = new ByteArrayInputStream(encryptedContents);
                                    importDataLen = encryptedContents.length;
                                    break block54;
                                }
                                throw new IllegalArgumentException("Unsupported keyring file version " + keyRingFile.getAbsolutePath());
                            }
                        }
                    }
                    SimpleKeyRing keyRing = new SimpleKeyRing(niagaraSecurityDir, keyRingName, keyMaterial);
                    if (importData != null) {
                        keyRing.importKeyData(importData, importDataLen, ISecretBytesSupplier.wrap((SecretBytes)new SecretBytes(encryptionKey, true)));
                    }
                    return (cipher, iv, aesTransformation) -> Aes256PasswordManager.getManager((KeyRing)keyRing).decryptSecret(cipher, iv, aesTransformation);
                }
                throw new IllegalArgumentException(niagaraSecurityDir.getAbsolutePath() + " does not contain a .kr file");
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return null;
    }

    public static AESDecryptFunction makeMigrationDecryptFunction(ISecretBytesSupplier aesKey) {
        return (cipher, iv, aesTransformation) -> Aes256PasswordManager.decryptSecret((byte[])((SecretBytes)aesKey.get()).get(), (byte[])cipher, (byte[])iv, (String)aesTransformation);
    }

    private static File renameToExport(File originalFile) throws IOException {
        File result = new File(originalFile.getParentFile(), originalFile.getName() + ".export");
        if (result.exists() && !result.delete()) {
            throw new IOException("Can't delete existing file " + result.getAbsolutePath());
        }
        if (!originalFile.renameTo(result)) {
            throw new IOException("Can't rename " + originalFile.getAbsolutePath());
        }
        return result;
    }
}

