/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.baja;

import com.tridium.migrator.MigReportUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.migration.BModuleRemovalConverter;
import javax.baja.migration.ConverterRegistry;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BTypeSpecConverter
extends BComponent
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BTypeSpecConverter.class);
    private static final List<String> convertTypes;
    private static final Lexicon lex;

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeSpecName, Version sourceVersion) {
        String typespecValue = x.get("v", null);
        if (typespecValue != null) {
            try {
                Sys.getType((String)typespecValue);
            }
            catch (ModuleException me) {
                this.convertTypeSpec(typespecValue, "Module", x);
            }
            catch (TypeException te) {
                this.convertTypeSpec(typespecValue, "Type", x);
            }
        }
        return x;
    }

    private XElem convertTypeSpec(String typespecValue, String exceptionType, XElem x) {
        List converters = ConverterRegistry.lookupConverters((String)typespecValue);
        String msg = MessageFormat.format(lex.getText("typeSpecConverter.notFound"), exceptionType, typespecValue, MigReportUtil.getReportName(x));
        if (converters.isEmpty()) {
            log.warning(msg);
            x.removeAttr("v");
        } else {
            String newTypespecValue = typespecValue;
            for (BIBogElementConverter converter : converters) {
                if (converter instanceof BModuleRemovalConverter) {
                    log.warning(msg);
                    x.removeAttr("v");
                    return x;
                }
                newTypespecValue = converter.newTypeSpec(newTypespecValue);
            }
            log.info("Migrating typespec '" + typespecValue + "' to new value '" + newTypespecValue + "'");
            x.setAttr("v", newTypespecValue);
        }
        return x;
    }

    static {
        ArrayList mutableConvertTypes = new ArrayList();
        Collections.addAll(mutableConvertTypes, "baja:TypeSpec");
        convertTypes = Collections.unmodifiableList(mutableConvertTypes);
        lex = Lexicon.make((String)"migrator");
    }
}

