/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator;

import com.tridium.install.installable.DistributionManifest;
import com.tridium.migrator.BMigrationBogFile;
import com.tridium.migrator.MigReportUtil;
import com.tridium.migrator.MigrationUtils;
import com.tridium.migrator.MigratorTypeResolver;
import com.tridium.migrator.baja.BServiceContainerConverter;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.io.BogPasswordObjectEncoder;
import com.tridium.rdb.hsqldb.BHsqlDatabase;
import com.tridium.security.AxPasswordUtil;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.file.BIFile;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.migration.BFileMigrator;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.migration.ConverterRegistry;
import javax.baja.migration.IOrdConverter;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.security.BAes256PasswordEncoder;
import javax.baja.security.BAliasedAes256PasswordEncoder;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

@NiagaraType
public class BBogMigrator
extends BFileMigrator {
    public static final Type TYPE = Sys.loadType(BBogMigrator.class);
    public static final Logger log = Logger.getLogger("migration");
    private final Lexicon lex = Lexicon.make((String)"migrator");
    private File stubbed;
    private boolean zipped;
    private final HashMap<String, String> modules = new HashMap();
    private final TreeSet<String> removedModules = new TreeSet();
    private final TreeSet<String> removedTypes = new TreeSet();
    private static final TreeSet<String> converterMessages = new TreeSet();
    private BIFile migrationTemplate;
    private Version sourceBajaVersion;
    private IOrdConverter ordConverter;
    private BComponent base;
    private Supplier<BPassword> passPhraseSupplier;

    public Type getType() {
        return TYPE;
    }

    public String[] getMigrateTypes() {
        return new String[]{"bog"};
    }

    public void initialize(File src, File tgt, Supplier<BPassword> passPhraseSupplier, DistributionManifest distManifest) {
        super.initialize(src, tgt, passPhraseSupplier, distManifest);
        this.sourceBajaVersion = MigrationUtils.getVersion(distManifest, "baja");
        this.passPhraseSupplier = passPhraseSupplier;
        this.stubbed = new File(this.target.getParentFile(), "stub_" + src.getName());
        this.stubbed.deleteOnExit();
    }

    public Optional<String> migrate() throws Exception {
        log.fine("Migrating " + this.source.getAbsolutePath() + "...");
        try {
            if (this.source.length() == 0L) {
                Optional optional = super.migrate();
                return optional;
            }
            this.validateBog();
            this.mapModules();
            this.stubBog();
            Optional<String> result = this.migrateBog();
            log.fine("Migration complete for " + this.source.getAbsolutePath());
            Optional<String> optional = result;
            return optional;
        }
        catch (OutOfMemoryError e) {
            MigrationUtils.outOfMemoryError(log);
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (Throwable e) {
            Optional<String> optional = MigrationUtils.errorResult(log, "Error migrating " + this.source + " to " + this.target, e);
            return optional;
        }
        finally {
            if (!this.args.hasOption("keepTemp") && !this.stubbed.delete() && log.isLoggable(Level.FINE)) {
                log.fine("Could not delete stub file " + this.stubbed);
            }
        }
    }

    public void addCompletionMessage(List<String> messages) {
        messages.addAll(this.removedModules.stream().map(s -> MessageFormat.format(this.lex.getText("bogMigrator.removedModule"), this.source.toPath().getFileName(), s)).collect(Collectors.toList()));
        messages.addAll(this.removedTypes.stream().map(s -> MessageFormat.format(this.lex.getText("bogMigrator.removedType"), this.source.toPath().getFileName(), s)).collect(Collectors.toList()));
        messages.addAll(converterMessages);
        converterMessages.clear();
    }

    BIFile getMigrationTemplate() {
        return this.migrationTemplate;
    }

    void setMigrationTemplate(BIFile migrationTemplate) {
        this.migrationTemplate = migrationTemplate;
    }

    public String getMappedModuleName(String abbrev) {
        return this.modules.get(abbrev);
    }

    public void updateModuleMap(String abbrev, String moduleName) {
        this.modules.put(abbrev, moduleName);
    }

    public static void addConverterMessage(String message) {
        converterMessages.add(message);
    }

    private void validateBog() throws Exception {
        log.fine("Validating bogfile");
        if (this.distManifest == null) {
            XElem[] kids;
            ValueDocDecoder decoder = new ValueDocDecoder(this.source);
            decoder.setLog(log);
            XElem root = ((ValueDocDecoder.BogElement)decoder.parse()).getXmlElement();
            for (XElem kid : kids = root.elems()) {
                if (!"b:Station".equals(kid.get("t", ""))) continue;
                throw new IllegalArgumentException(this.lex.getText("bogMigrator.cannotMigrateStationWithoutDist"));
            }
        }
    }

    private void mapModules() throws Exception {
        log.fine("BEGIN mapModules() in BogMigrator");
        ValueDocDecoder decoder = new ValueDocDecoder(this.source);
        decoder.setLog(log);
        XElem bog = ((ValueDocDecoder.BogElement)decoder.parse()).getXmlElement();
        LinkedList<XElem> todo = new LinkedList<XElem>();
        todo.add(bog);
        while (!todo.isEmpty()) {
            XElem elem = (XElem)todo.removeFirst();
            this.mapModule(elem.get("m", null));
            XElem[] children = elem.elems();
            Collections.addAll(todo, children);
        }
        log.fine("END mapModules() in BogMigrator");
    }

    private void mapModule(String moduleStr) throws Exception {
        int equals;
        if (moduleStr == null) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("mapModule(" + moduleStr + ')');
        }
        if ((equals = moduleStr.indexOf(61)) < 0) {
            return;
        }
        String key = moduleStr.substring(0, equals).trim();
        String name = moduleStr.substring(equals + 1).trim();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("putting {" + key + ',' + name + "} to module map...");
        }
        this.modules.put(key, name);
    }

    private void stubBog() throws Exception {
        XElem[] children;
        XElem elem;
        log.fine("BEGIN stubBog() in BogMigrator");
        MigrationUtils.safeCreateDirectory(this.stubbed.getParentFile());
        ValueDocDecoder decoder = new ValueDocDecoder(this.source);
        decoder.setLog(log);
        this.zipped = decoder.isZipped();
        XElem bogRoot = ((ValueDocDecoder.BogElement)decoder.parse()).getXmlElement();
        LinkedList<XElem> todo = new LinkedList<XElem>();
        todo.add(bogRoot);
        while (!todo.isEmpty()) {
            elem = (XElem)todo.removeFirst();
            children = elem.elems();
            for (int i = 0; i < children.length; ++i) {
                boolean removed;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("stubbing " + children[i]);
                }
                if (removed = this.stubChildOfElem(elem, i, children[i], bogRoot)) continue;
                todo.add(children[i]);
            }
        }
        todo = new LinkedList();
        todo.add(bogRoot);
        while (!todo.isEmpty()) {
            elem = (XElem)todo.removeFirst();
            for (XElem child : children = elem.elems()) {
                if ("null".equals(child.get("t", ""))) {
                    String n = child.get("n", "unknown");
                    if (!"removed".equals(n) && log.isLoggable(Level.FINER)) {
                        log.finer("Removing bog element '" + n + "' : " + child);
                    }
                    elem.removeContent((XContent)child);
                    continue;
                }
                todo.add(child);
            }
        }
        bogRoot.write(this.stubbed);
        log.fine("END stubBog() in BogMigrator");
    }

    private boolean stubChildOfElem(XElem parent, int childIndex, XElem child, XElem bogRoot) throws Exception {
        String childTypeAbbrev = child.get("t", null);
        String childTypeName = this.toTypeName(childTypeAbbrev);
        if (childTypeName == null) {
            return false;
        }
        List converters = ConverterRegistry.lookupConverters((String)childTypeName);
        if (!converters.isEmpty()) {
            XElem newContent = child;
            XElem deepCopy = bogRoot != null ? bogRoot.deepcopy() : null;
            for (BIBogElementConverter converter : converters) {
                newContent = deepCopy != null ? converter.convertXElem(newContent, childTypeName, MigrationUtils.getVersion(this.distManifest, childTypeName), deepCopy) : converter.convertXElem(newContent, childTypeName, MigrationUtils.getVersion(this.distManifest, childTypeName));
                if (newContent == null) {
                    this.removedTypes.add(childTypeName);
                    parent.replaceContent(childIndex, (XContent)BBogMigrator.nullElem(childTypeName));
                    return true;
                }
                if (Objects.equals(newContent.name(), "typeRemoved")) {
                    String removed = newContent.get("t", null);
                    if (removed != null) {
                        this.removedTypes.add(removed);
                    }
                    parent.replaceContent(childIndex, (XContent)BBogMigrator.nullElem(childTypeName));
                    return true;
                }
                if (Objects.equals(newContent.name(), "moduleRemoved")) {
                    String removed = newContent.get("m", null);
                    if (removed != null) {
                        String removedModule = this.modules.get(removed);
                        this.removedModules.add(removedModule != null ? removedModule : removed);
                    }
                    parent.replaceContent(childIndex, (XContent)BBogMigrator.nullElem(childTypeName));
                    return true;
                }
                if (Objects.equals(child, newContent) || !log.isLoggable(Level.FINER)) continue;
                log.finer("Migrated XElem child " + child + " of parent " + parent + " to " + newContent + '[' + converter.getType() + ']');
            }
            parent.replaceContent(childIndex, (XContent)newContent);
        }
        return false;
    }

    private String toTypeName(String abbrevName) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("toTypeName(" + abbrevName + ')');
        }
        if (abbrevName == null) {
            return null;
        }
        CharSequence[] moduleType = abbrevName.split(":");
        moduleType[0] = this.modules.get(moduleType[0]);
        return String.join((CharSequence)":", moduleType);
    }

    private static XElem nullElem(String removedTypeName) {
        XElem x = new XElem("p");
        x.setAttr("n", "removed");
        x.setAttr("t", "null");
        x.setAttr("v", removedTypeName);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> migrateBog() throws Exception {
        Optional<String> result;
        log.fine("BEGIN migrateBog() in BogMigrator");
        MigratorTypeResolver resolver = new MigratorTypeResolver(this);
        BMigrationBogFile bogFile = new BMigrationBogFile(this.stubbed, (ValueDocDecoder.ITypeResolver)resolver);
        BComponentSpace space = (BComponentSpace)bogFile.open();
        try {
            BComponent root = space.getRootComponent();
            this.doMigration(root, (ValueDocDecoder.ITypeResolver)resolver);
            result = this.encodeBog(root, this.zipped);
        }
        finally {
            if (bogFile.isOpen()) {
                bogFile.close();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Success! Migrated bog: " + this.source.getAbsolutePath() + " to " + this.target.getAbsolutePath());
        }
        log.fine("END migrateBog() in BogMigrator");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> encodeBog(BComponent c, boolean setZipped) throws Exception {
        EncryptionKeySource keySource = AxPasswordUtil.usesPasswordEncodings((BComplex)c, (String[])new String[]{BAes256PasswordEncoder.ENCODING_TYPE, BAliasedAes256PasswordEncoder.ENCODING_TYPE}) ? EncryptionKeySource.external : EncryptionKeySource.none;
        MigratorDocEncoder encoder = null;
        try {
            encoder = new MigratorDocEncoder(this.target, keySource);
            if (encoder.getPlugin() == null) {
                Optional<String> optional = MigrationUtils.errorResult(log, this.lex.getText("migrate.passphrase.aborted"));
                return optional;
            }
            encoder.setZipped(setZipped);
            encoder.encodeDocument((BValue)c);
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            if (encoder != null && encoder.getPlugin() != null) {
                encoder.close();
            }
        }
    }

    private void doMigration(BComponent root, ValueDocDecoder.ITypeResolver resolver) throws Exception {
        BValue drivers;
        log.fine("BEGIN doMigration() in BogMigrator");
        BIBogElementConverter serviceContainerConverter = null;
        BComplex serviceContainer = null;
        LinkedList<BComponent> todo = new LinkedList<BComponent>();
        todo.add(root);
        while (!todo.isEmpty()) {
            List converters;
            BComplex c = (BComplex)todo.removeFirst();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Checking for converter for " + c.getName() + " [" + c.getType() + ']');
            }
            if (!(converters = ConverterRegistry.lookupConverters((String)c.getType().getTypeSpec().toString())).isEmpty()) {
                for (BIBogElementConverter converter : converters) {
                    boolean convert = true;
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Doing convertComplex() on " + c.getName() + " with " + converter);
                    }
                    if (converter instanceof BServiceContainerConverter) {
                        if (root.getType().is(BStation.TYPE) && ((BStation)root).getServices() == c) {
                            serviceContainerConverter = converter;
                            serviceContainer = c;
                            convert = false;
                            if (this.migrationTemplate == null) {
                                this.migrationTemplate = BServiceContainerConverter.promptUserForStationType();
                            }
                        }
                        ((BServiceContainerConverter)converter).setMigrationTemplate(this.migrationTemplate);
                        log.info(MessageFormat.format(this.lex.getText("serviceContainerConverter.templateSelected"), this.migrationTemplate.getFileName()));
                    }
                    if (convert) {
                        converter.convertComplex(root, resolver, c, MigrationUtils.getVersion(this.distManifest, c.getType().getModule().getModuleName()));
                    }
                    if (this.migrationTemplate != null || !(converter instanceof BServiceContainerConverter)) continue;
                    this.migrationTemplate = ((BServiceContainerConverter)converter).getMigrationTemplate();
                }
            }
            if (!(c instanceof BComponent)) continue;
            BComplex[] children = (BComplex[])c.asComponent().getChildren(BComplex.class);
            Collections.addAll(todo, children);
        }
        todo.clear();
        if (serviceContainerConverter != null) {
            serviceContainerConverter.convertComplex(root, resolver, serviceContainer, MigrationUtils.getVersion(this.distManifest, serviceContainer.getType().getModule().getModuleName()));
        }
        if ((drivers = root.get("Drivers")) != null && drivers.asComponent().hasNavChildren()) {
            BComponent[] driverChildComponents;
            for (BComponent i : driverChildComponents = root.get("Drivers").asComponent().getChildComponents()) {
                BComponent[] rdbmsChildComponents;
                if (!(i instanceof BRdbmsNetwork)) continue;
                for (BComponent j : rdbmsChildComponents = i.getChildComponents()) {
                    if (!(j instanceof BHsqlDatabase)) continue;
                    BHsqlDatabase hsqlDatabase = (BHsqlDatabase)j;
                    String currentPassword = AccessController.doPrivileged(() -> ((BPassword)hsqlDatabase.getPassword()).getValue());
                    if (!currentPassword.equals("")) continue;
                    Property password = hsqlDatabase.getProperty("password");
                    hsqlDatabase.setFlags((Slot)password, hsqlDatabase.getFlags((Slot)password) | 0x10000000);
                }
            }
        }
        log.fine("END doMigration() in BogMigrator");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ValueDocEncoder.BogEncoderPlugin makeEncoderPlugin(File file, EncryptionKeySource keySource) throws IOException {
        try {
            BogPasswordObjectEncoder bogPasswordObjectEncoder;
            if (keySource == EncryptionKeySource.none) {
                bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeNone();
            } else if (keySource == EncryptionKeySource.external) {
                BPassword pwd = this.passPhraseSupplier.get();
                if (pwd == null) return null;
                bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeExternal((SecretChars)pwd.getSecretChars());
            } else {
                if (keySource != EncryptionKeySource.keyring) throw new IllegalArgumentException("Unsupported output key source: " + keySource.name());
                bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeKeyring();
            }
            ValueDocEncoder.BogEncoderPlugin result = new ValueDocEncoder.BogEncoderPlugin(file);
            result.setBogPasswordObjectEncoder(bogPasswordObjectEncoder);
            return result;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean mayContainOrds() {
        return "config.bog".equals(this.source.getName());
    }

    public Optional<String> updateOrds(IOrdConverter ordCnv, boolean setZipped) {
        try {
            this.ordConverter = ordCnv;
            this.base = ordCnv.getBase();
            this.processComplex((BComplex)this.base);
            this.encodeBog(this.base, setZipped);
            return Optional.empty();
        }
        catch (Exception e) {
            String msg = MessageFormat.format(this.lex.getText("bogMigrator.updateOrdsErr"), this.target, e);
            log.log(Level.INFO, msg, e);
            return MigrationUtils.errorResult(log, msg, e);
        }
    }

    private void processComplex(BComplex parent) {
        Property[] pa;
        for (Property p : pa = parent.getPropertiesArray()) {
            try {
                BValue v = parent.get(p);
                if (v instanceof BOrd) {
                    this.processOrd((BOrd)v, parent, p);
                    continue;
                }
                if (v instanceof BLink) {
                    this.processLink((BLink)v, parent.asComponent(), p);
                    continue;
                }
                if (v.isComplex()) {
                    this.processComplex((BComplex)v);
                    continue;
                }
                if (!(v instanceof BOrdList)) continue;
                this.processOrdList((BOrdList)v, parent, p);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    private void processLink(BLink lnk, BComponent parent, Property property) {
        BOrd srcOrd = BOrd.make((String)(lnk.getSourceOrd().toString(null) + '/' + lnk.getSourceSlotName()));
        BOrd newSrcOrd = this.ordConverter.convertOrd(srcOrd, (BComplex)this.base, property, this.sourceBajaVersion, log);
        if (newSrcOrd == null || newSrcOrd.isNull()) {
            BBogMigrator.badLink(lnk, (BComplex)parent, property);
            return;
        }
        Slot v = parent.getSlot(lnk.getTargetSlotName());
        if (v == null) {
            BOrd tgtOrd = BOrd.make((String)("slot:" + lnk.getTargetSlotName()));
            BOrd newTgtOrd = this.ordConverter.convertOrd(tgtOrd, (BComplex)parent, property, this.sourceBajaVersion, log);
            if (newTgtOrd == null || newTgtOrd.isNull()) {
                BBogMigrator.badLink(lnk, (BComplex)parent, property);
                return;
            }
            if (tgtOrd != newTgtOrd) {
                String tgtS = newTgtOrd.toString(null);
                String tgtSlot = tgtS.substring(tgtS.lastIndexOf(58) + 1);
                MigrationUtils.logInfo("bogMigrator.modifiedLink", lnk, tgtSlot);
                lnk.setTargetSlotName(tgtSlot);
            }
        }
        if (srcOrd != newSrcOrd) {
            String srcS = newSrcOrd.toString(null);
            lnk.setSourceOrd(BOrd.make((String)srcS.substring(0, srcS.lastIndexOf(47))));
            lnk.setSourceSlotName(srcS.substring(srcS.lastIndexOf(47) + 1));
        }
    }

    private static void badLink(BLink lnk, BComplex parent, Property prop) {
        if (parent.isComponent() && !prop.isFrozen()) {
            parent.asComponent().remove(prop);
            MigrationUtils.logWarning("bogMigrator.removedLink", lnk);
        }
    }

    private void processOrd(BOrd ord, BComplex parent, Property p) {
        if (ord.isNull()) {
            return;
        }
        BOrd newOrd = this.ordConverter.convertOrd(ord, parent, p, this.sourceBajaVersion, log);
        if (newOrd == ord) {
            return;
        }
        String name = MigReportUtil.getReportName(parent, p);
        if (newOrd.isNull()) {
            MigrationUtils.logWarning("bogMigrator.cannotResolveOrd", ord, name);
            return;
        }
        MigrationUtils.logInfo("bogMigrator.modifiedOrd", name, ord, newOrd);
        parent.set(p, (BValue)newOrd, null);
    }

    private void processOrdList(BOrdList ordList, BComplex parent, Property p) {
        if (ordList.isNull()) {
            return;
        }
        Object[] ords = ordList.toArray();
        Object[] newOrds = new BOrd[ords.length];
        for (int i = 0; i < ords.length; ++i) {
            newOrds[i] = this.ordConverter.convertOrd((BOrd)ords[i], parent, p, this.sourceBajaVersion, log);
        }
        if (!Arrays.equals(ords, newOrds)) {
            String name = MigReportUtil.getReportName(parent, p);
            BOrdList newOrdList = BOrdList.make((BOrd[])newOrds);
            MigrationUtils.logInfo("bogMigrator.modifiedOrdList", name, ordList, newOrdList);
            parent.set(p, (BValue)newOrdList, null);
        }
    }

    class MigratorDocEncoder
    extends ValueDocEncoder {
        public MigratorDocEncoder(File file, EncryptionKeySource keySource) throws IOException {
            super((ValueDocEncoder.IEncoderPlugin)BBogMigrator.this.makeEncoderPlugin(file, keySource));
        }

        protected boolean encodePropertyValue(BComplex parent, Property prop, int depth, BPermissions permissions, Context context) throws IOException {
            if (prop.getType().is(BPassword.TYPE)) {
                this.encodePassword(parent, prop, context);
                return true;
            }
            return super.encodePropertyValue(parent, prop, depth, permissions, context);
        }

        private void encodePassword(BComplex parent, Property prop, Context context) throws IOException {
            BPassword value = (BPassword)parent.get(prop);
            this.encodingValue((BValue)value, context);
            if (this.isTypeBlackListed(value.getType()) && value.isSimple()) {
                value = (BPassword)value.getType().getInstance();
            }
            this.myWvalue(value, parent, prop);
            this.plugin.end().newLine();
        }

        private ValueDocEncoder myWvalue(BPassword simple, BComplex parent, Property prop) throws IOException {
            try {
                String s = this.encodeSimple((BSimple)simple);
                this.plugin.attrSafe("v", s);
            }
            catch (Exception e) {
                String s = "?";
                try {
                    s = simple.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String msg = MessageFormat.format(BBogMigrator.this.lex.getText("bogMigrator.migDocEnc.encodingFail"), s, simple.getType(), MigReportUtil.getReportName(parent, prop), e);
                log.severe(msg);
                this.plugin.attr("err", simple.getType() + ".encodeToString()");
            }
            return this;
        }
    }
}

