/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread.graph;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.TestNGException;
import org.testng.internal.DynamicGraph;
import org.testng.internal.thread.TestNGThreadFactory;
import org.testng.internal.thread.graph.IThreadWorkerFactory;
import org.testng.internal.thread.graph.IWorker;

public class GraphThreadPoolExecutor<T>
extends ThreadPoolExecutor {
    private final DynamicGraph<T> m_graph;
    private final Queue<Runnable> m_activeRunnables = new ConcurrentLinkedDeque<Runnable>();
    private final IThreadWorkerFactory<T> m_factory;

    public GraphThreadPoolExecutor(String name, DynamicGraph<T> graph, IThreadWorkerFactory<T> factory, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new TestNGThreadFactory(name));
        this.m_graph = graph;
        this.m_factory = factory;
        if (this.m_graph.getFreeNodes().isEmpty()) {
            throw new TestNGException("The graph of methods contains a cycle:" + graph.getEdges());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            List<T> freeNodes = this.m_graph.getFreeNodes();
            this.runNodes(freeNodes);
        }
    }

    private void runNodes(List<T> freeNodes) {
        List<IWorker<T>> runnables = this.m_factory.createWorkers(freeNodes);
        for (IWorker<T> r : runnables) {
            this.m_activeRunnables.add(r);
            this.setStatus(r, DynamicGraph.Status.RUNNING);
            try {
                this.execute(r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(IWorker<T> worker, DynamicGraph.Status status) {
        if (status == DynamicGraph.Status.FINISHED) {
            this.m_activeRunnables.remove(worker);
        }
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            for (T m : worker.getTasks()) {
                this.m_graph.setStatus(m, status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterExecute(Runnable r, Throwable t) {
        this.setStatus((IWorker)r, DynamicGraph.Status.FINISHED);
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            if (this.m_graph.getNodeCount() == this.m_graph.getNodeCountWithStatus(DynamicGraph.Status.FINISHED)) {
                this.shutdown();
            } else {
                List<T> freeNodes = this.m_graph.getFreeNodes();
                this.runNodes(freeNodes);
            }
        }
    }
}

