/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Graph;

public class Tarjan<T> {
    int m_index = 0;
    private Stack<T> m_s;
    Map<T, Integer> m_indices = Maps.newHashMap();
    Map<T, Integer> m_lowlinks = Maps.newHashMap();
    private List<T> m_cycle;

    public Tarjan(Graph<T> graph, T start) {
        this.m_s = new Stack();
        this.run(graph, start);
    }

    private void run(Graph<T> graph, T v) {
        this.m_indices.put(v, this.m_index);
        this.m_lowlinks.put(v, this.m_index);
        ++this.m_index;
        this.m_s.push(v);
        for (T vprime : graph.getPredecessors(v)) {
            if (!this.m_indices.containsKey(vprime)) {
                this.run(graph, vprime);
                int min = Math.min(this.m_lowlinks.get(v), this.m_lowlinks.get(vprime));
                this.m_lowlinks.put(v, min);
                continue;
            }
            if (!this.m_s.contains(vprime)) continue;
            this.m_lowlinks.put(v, Math.min(this.m_lowlinks.get(v), this.m_indices.get(vprime)));
        }
        if (Objects.equals(this.m_lowlinks.get(v), this.m_indices.get(v))) {
            T n;
            this.m_cycle = Lists.newArrayList();
            do {
                n = this.m_s.pop();
                this.m_cycle.add(n);
            } while (!n.equals(v));
        }
    }

    public List<T> getCycle() {
        return this.m_cycle;
    }
}

