/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import org.testng.IInvokedMethod;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.TestNgMethodUtils;

public class InvokedMethod
implements IInvokedMethod {
    private final Object m_instance;
    private final ITestNGMethod m_testMethod;
    private final long m_date;
    private final ITestResult m_testResult;

    public InvokedMethod(Object instance, ITestNGMethod method, long date, ITestResult testResult) {
        this.m_instance = instance;
        this.m_testMethod = method;
        this.m_date = date;
        this.m_testResult = testResult;
    }

    @Override
    public boolean isTestMethod() {
        return this.m_testMethod.isTest();
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.m_testMethod);
        for (Object p : this.m_testResult.getParameters()) {
            result.append(p).append(" ");
        }
        result.append(" ").append(this.m_instance != null ? Integer.valueOf(this.m_instance.hashCode()) : " <static>");
        return result.toString();
    }

    @Override
    public boolean isConfigurationMethod() {
        return TestNgMethodUtils.isConfigurationMethod(this.m_testMethod);
    }

    @Override
    public ITestNGMethod getTestMethod() {
        return this.m_testMethod;
    }

    @Override
    public long getDate() {
        return this.m_date;
    }

    @Override
    public ITestResult getTestResult() {
        return this.m_testResult;
    }
}

