/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavContainer;
import javax.baja.nav.BNavContainer;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpace;
import javax.baja.space.BISpaceContainer;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BMockHost;
import javax.baja.test.BMockSessionScheme;

@NiagaraType
@NiagaraSlots
public class BMockSession
extends BNavContainer
implements BISession,
BISpaceContainer,
BINavContainer {
    public static final Type TYPE = Sys.loadType(BMockSession.class);
    private final Set<BISpace> spaces = ConcurrentHashMap.newKeySet();

    public Type getType() {
        return TYPE;
    }

    BMockSession(String name) {
        super(name);
    }

    public boolean isConnected() {
        return true;
    }

    public void connect() throws Exception {
    }

    public void disconnect() {
    }

    public void close() {
        BMockHost.INSTANCE.removeSession(this.getNavName());
    }

    public BHost getHost() {
        return BMockHost.INSTANCE;
    }

    public BOrd getAbsoluteOrd() {
        return BOrd.make((BOrd)BMockHost.INSTANCE.getAbsoluteOrd(), (OrdQuery)new BMockSessionScheme.MockSessionQuery(this.getNavName()));
    }

    public BOrd getOrdInHost() {
        return BOrd.make((OrdQuery)new BMockSessionScheme.MockSessionQuery(this.getNavName()));
    }

    public Context getSessionContext() {
        return null;
    }

    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BISpace mountSpace(BISpace space) {
        Set<BISpace> set = this.spaces;
        synchronized (set) {
            if (this.spaces.contains(space)) {
                throw new IllegalArgumentException("Space already mounted " + space);
            }
            this.spaces.add(space);
            space.setSpaceContainer((BISpaceContainer)this);
            return space;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmountSpace(BISpace space) {
        Set<BISpace> set = this.spaces;
        synchronized (set) {
            if (!this.spaces.contains(space)) {
                throw new IllegalArgumentException("Space not mounted " + space);
            }
            this.spaces.remove(space);
            space.setSpaceContainer(null);
        }
    }

    public Iterator<BISpace> getSpaces() {
        return this.spaces.iterator();
    }
}

