/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.nre.RunnableWithException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.FileUtil;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import org.testng.Assert;

public final class TestUtil {
    private static final int WAIT_FOR_TRUE_INTERVAL = 10;
    private static final int WAIT_FOR_TRUE_TIMEOUT = 5000;

    private TestUtil() {
    }

    @Deprecated
    public static void waitFor(int seconds, BooleanSupplier condition, String message) {
        Assert.assertTrue(TestUtil.waitFor(condition, (long)seconds * 1000L, 10L), message + ": wait time expired");
    }

    public static void assertWillBeTrue(BooleanSupplier condition, String message) {
        Assert.assertTrue(TestUtil.waitFor(condition, 5000L, 10L), message);
    }

    public static void assertWillBeTrue(BooleanSupplier condition, Supplier<String> message) {
        if (!TestUtil.waitFor(condition, 5000L, 10L)) {
            Assert.fail(message.get());
        }
    }

    public static void assertWillBeTrue(BooleanSupplier condition, long timeout, String message) {
        Assert.assertTrue(TestUtil.waitFor(condition, timeout, 10L), message);
    }

    public static void assertWillBeTrue(BooleanSupplier condition, long timeout, Supplier<String> message) {
        if (!TestUtil.waitFor(condition, timeout, 10L)) {
            Assert.fail(message.get());
        }
    }

    public static boolean waitFor(BooleanSupplier condition) {
        return TestUtil.waitFor(condition, 5000L, 10L);
    }

    @Deprecated
    public static boolean waitFor(BooleanSupplier condition, double timeout) {
        return TestUtil.waitFor(condition, (long)(timeout * 1000.0), 10L);
    }

    public static boolean waitFor(BooleanSupplier condition, long timeout) {
        return TestUtil.waitFor(condition, timeout, 10L);
    }

    @Deprecated
    public static boolean waitFor(BooleanSupplier condition, long interval, double timeout) {
        return TestUtil.waitFor(condition, (long)(timeout * 1000.0), interval);
    }

    public static boolean waitFor(BooleanSupplier condition, long timeout, long interval) {
        long now = Clock.ticks();
        long end = now + timeout;
        while (now < end) {
            if (condition.getAsBoolean()) {
                return true;
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            now = Clock.ticks();
        }
        return condition.getAsBoolean();
    }

    public static void waitForClockChange() {
        BAbsTime start = Clock.time();
        TestUtil.waitFor(() -> Clock.time().getMillis() > start.getMillis());
    }

    public static void fieldEditorSlotFacetsToHaveUxFieldEditorDefined(String expectedFeType, String expectedUxFeType) {
        Assert.assertNotNull(expectedFeType, "expectedFeType argument");
        Assert.assertNotNull(expectedUxFeType, "expectedUxFeType argument");
        Registry registry = Sys.getRegistry();
        for (TypeInfo type : registry.getConcreteTypes(BComplex.TYPE.getTypeInfo())) {
            BComplex instance;
            if (type.isAbstract() || type.isInterface() || type.is(BWidget.TYPE)) continue;
            try {
                instance = type.getInstance().asComplex();
            }
            catch (Throwable ignore) {
                continue;
            }
            for (Property property : instance.getProperties()) {
                BFacets facets = property.getFacets();
                String actualFeType = facets.gets("fieldEditor", null);
                if (!expectedFeType.equals(actualFeType)) continue;
                String actualUxFeType = facets.gets("uxFieldEditor", null);
                String message = "actual UX field editor type for " + type.getModuleName() + ':' + type.getTypeName() + '.' + property.getName();
                Assert.assertNotNull(actualUxFeType, message);
                Assert.assertEquals(actualUxFeType, expectedUxFeType, message);
            }
        }
    }

    public static Object getPrivateField(Object object, String variableName) {
        return TestUtil.actOnField(object, variableName, field -> field.get(object));
    }

    public static void setPrivateField(Object object, String variableName, Object value) {
        TestUtil.actOnField(object, variableName, field -> {
            field.set(object, value);
            return null;
        });
    }

    private static <T> T actOnField(Object object, String variableName, ExceptionFunction<Field, T, IllegalAccessException> function) {
        Field field = null;
        boolean fieldAccessible = false;
        Field modifierField = null;
        boolean modifiedFieldAccessible = false;
        int modifiers = 0;
        try {
            Class<?> cls = object instanceof Class ? (Class<?>)object : object.getClass();
            field = cls.getDeclaredField(variableName);
            fieldAccessible = field.isAccessible();
            field.setAccessible(true);
            modifierField = field.getClass().getDeclaredField("modifiers");
            modifiedFieldAccessible = modifierField.isAccessible();
            modifierField.setAccessible(true);
            modifiers = modifierField.getInt(field);
            modifierField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            T t = function.apply(field);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot remove final", e);
        }
        finally {
            try {
                if (modifierField != null && field != null) {
                    modifierField.setInt(field, modifiers);
                    modifierField.setAccessible(modifiedFieldAccessible);
                    field.setAccessible(fieldAccessible);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void runWithAlternateValue(Object object, String variableName, Object alternateValue, RunnableWithException<E> r) throws E {
        Object originalValue = TestUtil.getPrivateField(object, variableName);
        TestUtil.setPrivateField(object, variableName, alternateValue);
        try {
            r.run();
        }
        finally {
            TestUtil.setPrivateField(object, variableName, originalValue);
        }
    }

    public static void copyFile(BOrd original, FilePath destination) throws IOException {
        BIFile inFile = (BIFile)original.get();
        BIFile outFile = BFileSystem.INSTANCE.makeFile(destination);
        try (InputStream in = inFile.getInputStream();
             OutputStream out = outFile.getOutputStream();){
            FileUtil.pipe((InputStream)in, (OutputStream)out);
            out.flush();
        }
    }

    public static BIFile unpackModuleFileAsTempFile(String moduleFilePath) throws IOException {
        try {
            BOrd moduleOrd = BOrd.make((String)("module://" + moduleFilePath));
            BIFile moduleFile = (BIFile)moduleOrd.get();
            File tempFile = File.createTempFile(moduleFile.getFileName(), '.' + moduleFile.getExtension());
            tempFile.deleteOnExit();
            TestUtil.copyFile(moduleOrd, BFileSystem.INSTANCE.localFileToPath(tempFile));
            return (BIFile)BFileSystem.INSTANCE.localFileToOrd(tempFile).get().as(BIFile.class);
        }
        catch (Exception e) {
            System.err.println("Failed to unpack file '" + moduleFilePath + "', exception '" + e.getMessage() + '\'');
            e.printStackTrace();
            throw e;
        }
    }

    private static interface ExceptionFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    public static class LatestHandler
    extends Handler {
        String latestMessage;
        Level latestLevel;

        public Level getLatestLevel() {
            return this.latestLevel;
        }

        public String getLatestMessage() {
            return this.latestMessage;
        }

        @Override
        public void publish(LogRecord record) {
            this.latestMessage = record.getMessage();
            this.latestLevel = record.getLevel();
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

