/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.authn.AuthenticationClient;
import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.file.types.bog.BBogFile;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.testng.TestAuthenticationClient;
import com.tridium.util.FilePathUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.baja.file.BFileSystem;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BHost;
import javax.baja.naming.BLocalHost;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.nre.security.ExemptionApprover;
import javax.baja.nre.security.ExemptionHandler;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.web.BWebService;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public final class StationRunner {
    private Path niagaraUserHome;
    private Path bogFile;
    private BStation station;
    private boolean addExemptions;
    private int foxPort;
    private int foxsPort;
    private int httpsPort;
    private Process stationProcess;
    private BufferedReader reader;
    private BufferedWriter writer;
    private static final String FOX_STARTED_REGEX = ".*FOX.? server started on port \\[[0-9]+\\].*";
    private static final String STATION_STARTED_REGEX = ".*\\*\\*\\* Station Started.*";

    private StationRunner() {
    }

    public static StationRunner make() {
        return new StationRunner();
    }

    public StationRunner withNiagaraUserHome(Path niagaraUserHome) {
        this.niagaraUserHome = niagaraUserHome;
        return this;
    }

    public StationRunner withNiagaraUserHome(File niagaraUserHome) {
        this.niagaraUserHome = niagaraUserHome.toPath();
        return this;
    }

    public StationRunner withBogFile(Path bogFile) {
        this.bogFile = bogFile;
        return this;
    }

    public StationRunner withBogFile(File bogFile) {
        this.bogFile = bogFile.toPath();
        return this;
    }

    public StationRunner withStation(BStation station) {
        this.station = station;
        return this;
    }

    public StationRunner start() throws Exception {
        Objects.requireNonNull(this.niagaraUserHome);
        if (this.bogFile != null && this.station != null) {
            throw new IllegalStateException("Cannot specify both station bog and station component");
        }
        if (this.bogFile != null) {
            try (BBogFile bog = null;){
                bog = (BBogFile)BFileSystem.INSTANCE.findFile(FilePathUtil.makeFromPathAbsolute((Path)this.bogFile));
                BStation bogStation = (BStation)bog.getBogSpace().getRootComponent();
                this.getPortsFromStation(bogStation);
            }
        } else {
            this.getPortsFromStation(this.station);
        }
        String stationName = null;
        if (this.station == null) {
            throw new UnsupportedOperationException("Raw config.bog support not fully implemented yet");
        }
        stationName = this.station.getStationName();
        Files.createDirectory(this.niagaraUserHome.resolve("stations"), new FileAttribute[0]);
        Path stationDir = Files.createDirectory(this.niagaraUserHome.resolve("stations/" + stationName), new FileAttribute[0]);
        Path stationBog = stationDir.resolve("config.bog");
        BBogFile stationFile = (BBogFile)BFileSystem.INSTANCE.makeFile(FilePathUtil.makeFromPathAbsolute((Path)stationBog));
        ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)new BufferedOutputStream(stationFile.getOutputStream()));
        encoder.encodeDocument((BValue)this.station);
        encoder.close();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Map<String, String> environment = processBuilder.environment();
        environment.put("niagara_user_home", this.niagaraUserHome.toAbsolutePath().toString());
        if (environment.containsKey("NIAGARA_USER_HOME")) {
            environment.put("NIAGARA_USER_HOME", this.niagaraUserHome.toAbsolutePath().toString());
        }
        environment.put("NIAGARA_USE_SIMPLE_KM", "1");
        environment.put("NIAGARA_USE_SIMPLE_SP", "1");
        processBuilder.command("station", stationName);
        processBuilder.redirectErrorStream(true);
        this.stationProcess = processBuilder.start();
        this.reader = new BufferedReader(new InputStreamReader(this.stationProcess.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.stationProcess.getOutputStream()));
        ArrayList<String> requiredMatches = new ArrayList<String>(Arrays.asList(STATION_STARTED_REGEX, FOX_STARTED_REGEX));
        while (!requiredMatches.isEmpty()) {
            String line = this.reader.readLine();
            StationRunner.stationLog(line);
            requiredMatches.removeIf(requiredMatch -> line.matches((String)requiredMatch));
        }
        if (!this.stationProcess.isAlive()) {
            throw new RuntimeException("Could not start station?");
        }
        return this;
    }

    public int stop() throws IOException, InterruptedException {
        this.writer.write("quit\n");
        this.writer.flush();
        this.reader.lines().forEach(StationRunner::stationLog);
        if (!this.stationProcess.waitFor(5L, TimeUnit.SECONDS)) {
            this.stationProcess.destroy();
        }
        return this.stationProcess.exitValue();
    }

    public BFoxSession getFoxSession(String username, String password, boolean useFoxs) throws Exception {
        BFoxSession session = BFoxSession.make((BHost)BLocalHost.INSTANCE, (int)(useFoxs ? this.foxsPort : this.foxPort), (boolean)useFoxs);
        TestAuthenticationClient client = new TestAuthenticationClient(username, password);
        session.getConnection().setAuthenticationClient((AuthenticationClient)client);
        SocketFactory factory = CertManagerFactory.getInstance().getClientSocketFactory(ClientTlsParameters.DEFAULT);
        if (factory instanceof ExemptionHandler) {
            ((ExemptionHandler)factory).setExemptionApprover(new ExemptionApprover(){

                public boolean approveExemption(CertValidationResult result) {
                    return true;
                }

                public boolean isTransientApproval() {
                    return true;
                }
            });
        }
        session.getConnection().setSSLSocketFactory((SSLSocketFactory)factory);
        BFoxSession foxSession = BFoxSession.connect((BFoxSession)session);
        return foxSession;
    }

    public BStation getRemoteStation(String username, String password, boolean useFoxs) throws Exception {
        BFoxSession foxSession = this.getFoxSession(username, password, useFoxs);
        BBrokerChannel channel = (BBrokerChannel)foxSession.getConnection().getChannels().get("station", BBrokerChannel.TYPE);
        BComponent remoteStationComp = channel.fromOrd("slot:/");
        if (!(remoteStationComp instanceof BStation)) {
            throw new RuntimeException("Could not get remote station component");
        }
        return (BStation)remoteStationComp;
    }

    private static void stationLog(String msg) {
        System.out.println("[station] " + msg);
    }

    private void getPortsFromStation(BStation station) {
        this.httpsPort = ((BWebService[])station.getServices().getChildren(BWebService.class))[0].getHttpsPort().getPublicServerPort();
        BFoxService foxService = ((BFoxService[])station.getServices().getChildren(BFoxService.class))[0];
        this.foxPort = foxService.getFoxPort().getPublicServerPort();
        this.foxsPort = foxService.getFoxsPort().getPublicServerPort();
    }
}

