/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.test.diagnostics;

import com.tridium.nre.diagnostics.DiagnosticStats;
import com.tridium.test.diagnostics.BDiagnosticManager;
import javax.baja.data.BIDataValue;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public final class BDiagnosticStat
extends BComponent {
    public static final Property functionName = BDiagnosticStat.newProperty((int)0, (String)"", null);
    public static final Property key = BDiagnosticStat.newProperty((int)0, (String)"", null);
    public static final Property lastDuration = BDiagnosticStat.newProperty((int)67, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property totalTimeDisplay = BDiagnosticStat.newProperty((int)67, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE")));
    public static final Property totalTime = BDiagnosticStat.newProperty((int)67, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property avgPerCall = BDiagnosticStat.newProperty((int)67, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property callCount = BDiagnosticStat.newProperty((int)67, (int)0, null);
    public static final Type TYPE = Sys.loadType(BDiagnosticStat.class);
    private static double CONVERT_TO_MILLIS = 1000000.0;

    public String getFunctionName() {
        return this.getString(functionName);
    }

    public void setFunctionName(String v) {
        this.setString(functionName, v, null);
    }

    public String getKey() {
        return this.getString(key);
    }

    public void setKey(String v) {
        this.setString(key, v, null);
    }

    public double getLastDuration() {
        return this.getDouble(lastDuration);
    }

    public void setLastDuration(double v) {
        this.setDouble(lastDuration, v, null);
    }

    public BRelTime getTotalTimeDisplay() {
        return (BRelTime)this.get(totalTimeDisplay);
    }

    public void setTotalTimeDisplay(BRelTime v) {
        this.set(totalTimeDisplay, (BValue)v, null);
    }

    public double getTotalTime() {
        return this.getDouble(totalTime);
    }

    public void setTotalTime(double v) {
        this.setDouble(totalTime, v, null);
    }

    public double getAvgPerCall() {
        return this.getDouble(avgPerCall);
    }

    public void setAvgPerCall(double v) {
        this.setDouble(avgPerCall, v, null);
    }

    public long getCallCount() {
        return this.getLong(callCount);
    }

    public void setCallCount(long v) {
        this.setLong(callCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context cx) {
        BComplex c;
        if (!this.isRunning()) {
            return;
        }
        if ((prop.equals(functionName) || prop.equals(key)) && (c = this.getParent()) instanceof BDiagnosticManager) {
            ((BDiagnosticManager)c).poll();
        }
    }

    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser()) {
            return BPermissions.DEFAULT;
        }
        return super.getPermissions(cx);
    }

    public void copyFrom(DiagnosticStats.KeyStat keyStat) {
        if (keyStat != null) {
            double totalMsTime = (double)keyStat.getTotalTime() / CONVERT_TO_MILLIS;
            this.setTotalTime(totalMsTime);
            this.setTotalTimeDisplay(BRelTime.make((long)((long)totalMsTime)));
            this.setAvgPerCall(totalMsTime / (double)keyStat.getCallCount());
            this.setCallCount(keyStat.getCallCount());
            this.setLastDuration((double)keyStat.getLastDuration() / CONVERT_TO_MILLIS);
        } else {
            this.setTotalTime(0.0);
            this.setTotalTimeDisplay(BRelTime.DEFAULT);
            this.setAvgPerCall(0.0);
            this.setCallCount(0L);
            this.setLastDuration(0.0);
        }
    }

    public void copyFrom(DiagnosticStats stat) {
        if (stat != null) {
            double totalMsTime = stat.getTotalTime() / CONVERT_TO_MILLIS;
            this.setTotalTime(totalMsTime);
            this.setTotalTimeDisplay(BRelTime.make((long)((long)totalMsTime)));
            this.setAvgPerCall(totalMsTime / (double)stat.getFunctionCalls());
            this.setCallCount(stat.getFunctionCalls());
            this.setLastDuration(stat.getLastDuration() / CONVERT_TO_MILLIS);
        } else {
            this.copyFrom((DiagnosticStats.KeyStat)null);
        }
    }
}

