/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.test.diagnostics;

import com.tridium.nre.diagnostics.DiagnosticStats;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.test.diagnostics.BDiagnosticStat;
import javax.baja.data.BIDataValue;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

public final class BDiagnosticManager
extends BComponent
implements BIService,
BIRestrictedComponent,
DiagnosticStats.IDiagnosticListener {
    public static final Property collectionInterval = BDiagnosticManager.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L))));
    public static final Action reset = BDiagnosticManager.newAction((int)0, null);
    public static final Action pause = BDiagnosticManager.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BDiagnosticManager.class);
    private DiagnosticCollectionThread thread;
    private long lastPollCompleteTime = 0L;
    private static final BIcon ICON = BIcon.std((String)"log.png");

    public BRelTime getCollectionInterval() {
        return (BRelTime)this.get(collectionInterval);
    }

    public void setCollectionInterval(BRelTime v) {
        this.set(collectionInterval, (BValue)v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void pause() {
        this.invoke(pause, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doReset(Context cx) {
        DiagnosticUtil.reset();
        this.poll();
    }

    public void doPause(Context cx) {
        DiagnosticUtil.pause();
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(collectionInterval)) {
            this.checkCollection();
        }
    }

    public void changed(DiagnosticStats.KeyStat keyStat, String functionName) {
        if (this.getCollectionInterval().getMillis() != 0L) {
            return;
        }
        for (BDiagnosticStat stat : (BDiagnosticStat[])this.getChildren(BDiagnosticStat.class)) {
            if (!stat.getFunctionName().equals(functionName)) continue;
            if (stat.getKey().length() > 0) {
                if (keyStat == null || !stat.getKey().toString().equals(keyStat.getKey().toString())) continue;
                stat.copyFrom(keyStat);
                continue;
            }
            DiagnosticStats recordedStat = (DiagnosticStats)DiagnosticUtil.getAllStats().get(functionName);
            if (recordedStat == null) continue;
            stat.copyFrom(recordedStat);
        }
    }

    public void poll() {
        if (!this.isRunning()) {
            return;
        }
        for (BDiagnosticStat stat : (BDiagnosticStat[])this.getChildren(BDiagnosticStat.class)) {
            DiagnosticStats recordedStat = (DiagnosticStats)DiagnosticUtil.getAllStats().get(stat.getFunctionName());
            if (recordedStat != null) {
                if (stat.getKey().length() > 0) {
                    DiagnosticStats.KeyStat keyStat;
                    if (recordedStat.getKeyUsage() != null && (keyStat = (DiagnosticStats.KeyStat)recordedStat.getKeyUsage().get(stat.getKey())) != null) {
                        stat.copyFrom(keyStat);
                        continue;
                    }
                } else {
                    stat.copyFrom(recordedStat);
                    continue;
                }
            }
            stat.copyFrom((DiagnosticStats.KeyStat)null);
        }
        this.lastPollCompleteTime = System.currentTimeMillis();
    }

    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser()) {
            return BPermissions.DEFAULT;
        }
        return super.getPermissions(cx);
    }

    public void checkCollection() {
        if (this.getCollectionInterval().equals((Object)BRelTime.DEFAULT)) {
            DiagnosticStats.setDiagnosticListener((DiagnosticStats.IDiagnosticListener)this);
        } else {
            if (this.thread == null) {
                this.thread = new DiagnosticCollectionThread();
                this.thread.start();
            }
            DiagnosticStats.setDiagnosticListener(null);
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE, TYPE};
    }

    public void serviceStarted() throws Exception {
        this.checkCollection();
    }

    public void serviceStopped() throws Exception {
        DiagnosticStats.setDiagnosticListener(null);
        if (this.thread != null) {
            this.thread.kill();
            try {
                this.thread.join(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public void spy(SpyWriter out) throws Exception {
        out.a("spy:/sysManagers/diagnosticManager", (Object)"Diagnostic Manager Spy");
        out.startProps();
        out.endProps();
        super.spy(out);
    }

    private class DiagnosticCollectionThread
    extends Thread {
        private boolean stopRequested;

        public DiagnosticCollectionThread() {
            super("test:DiagnosticCollectionThread");
            this.stopRequested = false;
        }

        void kill() {
            this.stopRequested = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.stopRequested && !BDiagnosticManager.this.getCollectionInterval().equals((Object)BRelTime.DEFAULT)) {
                try {
                    DiagnosticCollectionThread.sleep(BDiagnosticManager.this.getCollectionInterval().getMillis());
                }
                catch (InterruptedException e) {
                    if (this.stopRequested) break;
                }
                if (BDiagnosticManager.this.getCollectionInterval().equals((Object)BRelTime.DEFAULT)) break;
                BDiagnosticManager.this.poll();
            }
        }
    }
}

