/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.comps;

import com.tridium.nv.comps.BNiagaraVirtualSchedule;
import com.tridium.schedule.BIScheduleSnapshotHandler;
import com.tridium.schedule.ScheduleUtil;
import com.tridium.sys.schema.ComplexSlotMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDate;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"niagaraVirtual:NiagaraVirtualSchedule"})})
@NiagaraSingleton
public final class BNiagaraVirtualScheduleSnapshotHandler
extends BSingleton
implements BIScheduleSnapshotHandler {
    public static final BNiagaraVirtualScheduleSnapshotHandler INSTANCE = new BNiagaraVirtualScheduleSnapshotHandler();
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualScheduleSnapshotHandler.class);
    private final String TRANSPORT_FACET = "transportType";
    private final String TRANSPORT_TYPE_BOX = "box";

    private BNiagaraVirtualScheduleSnapshotHandler() {
    }

    public Type getType() {
        return TYPE;
    }

    public BAbstractSchedule getSnapshot(BComponent source, Context cx) {
        BNiagaraVirtualSchedule virtual = BNiagaraVirtualScheduleSnapshotHandler.toVirtualSchedule(source);
        return virtual.getNiagaraVirtualGateway().getStationAdapter().getScheduleSnapshot(virtual.getNiagaraVirtualCompInfo().getSlotOrd(), cx);
    }

    public BAbstractSchedule saveSnapshot(BComponent source, BAbstractSchedule schedule, Context cx) {
        OrdQuery auditSlotPath;
        BNiagaraVirtualSchedule virtual = BNiagaraVirtualScheduleSnapshotHandler.toVirtualSchedule(source);
        boolean audit = cx != null && cx.getFacets() != null && "box".equalsIgnoreCase(cx.getFacets().gets("transportType", null));
        BAbstractSchedule originalSchedule = audit ? this.getSnapshot(source, cx) : null;
        BAbstractSchedule result = virtual.getNiagaraVirtualGateway().getStationAdapter().saveScheduleSnapshot(virtual.getNiagaraVirtualCompInfo().getSlotOrd(), schedule, cx);
        if (audit && (auditSlotPath = ComplexSlotMap.getAuditSlotPath((BComponent)virtual, (Context)cx)) != null) {
            ScheduleUtil.stationSideAuditableCopyFrom((BAbstractSchedule)originalSchedule, (BAbstractSchedule)schedule, (Context)cx, (String)auditSlotPath.getBody());
        }
        return result;
    }

    public BOrd getRefBaseOrd(BComponent source) {
        return BNiagaraVirtualScheduleSnapshotHandler.toVirtualSchedule(source).getNiagaraVirtualCompInfo().getSlotOrd();
    }

    public List<BDate> getHighlightedDates(BComponent source, BAbstractSchedule sched, BDate start, BDate end, Context cx) {
        BNiagaraVirtualSchedule virtual = BNiagaraVirtualScheduleSnapshotHandler.toVirtualSchedule(source);
        return virtual.getNiagaraVirtualGateway().getStationAdapter().getHighlightedDates(virtual.getNiagaraVirtualCompInfo().getSlotOrd(), sched, start, end, cx);
    }

    public List<Map<String, String>> getSummary(BComponent source, BAbstractSchedule sched, BDate start, BDate end, Context cx) {
        BNiagaraVirtualSchedule virtual = BNiagaraVirtualScheduleSnapshotHandler.toVirtualSchedule(source);
        return virtual.getNiagaraVirtualGateway().getStationAdapter().getSummary(virtual.getNiagaraVirtualCompInfo().getSlotOrd(), sched, start, end, cx);
    }

    public List<BOrd> findCalendarSchedules(BComponent source, Context cx) {
        BNiagaraVirtualSchedule virtual = BNiagaraVirtualScheduleSnapshotHandler.toVirtualSchedule(source);
        return virtual.getNiagaraVirtualGateway().getStationAdapter().findCalendarSchedules(virtual.getNiagaraVirtualCompInfo().getSlotOrd(), cx);
    }

    public Map<String, Object> getScheduleOptions(BComponent source, Context cx) {
        BNiagaraVirtualSchedule virtual = BNiagaraVirtualScheduleSnapshotHandler.toVirtualSchedule(source);
        Map<String, Object> options = virtual.getNiagaraVirtualGateway().getStationAdapter().getScheduleOptions(virtual.getNiagaraVirtualCompInfo().getSlotOrd(), cx);
        boolean readonly = (Boolean)options.getOrDefault("readonly", false);
        if (!readonly && !virtual.getPermissions(cx).hasOperatorWrite()) {
            options = new HashMap<String, Object>(options);
            options.put("readonly", true);
        }
        return options;
    }

    private static BNiagaraVirtualSchedule toVirtualSchedule(BComponent comp) {
        return (BNiagaraVirtualSchedule)comp;
    }
}

