/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.cache;

import com.tridium.nv.cache.BNvaEntry;
import java.security.AccessController;
import java.util.Comparator;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;

public final class NvaEncoder {
    private BOrd dirOrd;
    private BFileSpace space;
    private BDirectory dir;
    private BComponent root = null;
    private int limit = 0;
    private int count = 0;
    private static final BString version = BString.make((String)"1.0.0.0");
    private static final String fileName = "cache";
    private static final int defaultNvaFileEntryLimit = 3000;
    private static int nvaFileEntryLimit = 3000;

    private NvaEncoder(BFileSpace space, BOrd dirOrd) {
        this.space = space;
        this.dirOrd = dirOrd;
    }

    public static NvaEncoder make(BFileSpace space, BOrd dirOrd) {
        return new NvaEncoder(space, dirOrd);
    }

    public static NvaEncoder make(BOrd localDirOrd) {
        return NvaEncoder.make((BFileSpace)BFileSystem.INSTANCE, localDirOrd);
    }

    public void add(BNvaEntry entry) throws Exception {
        if (this.root == null) {
            this.root = new BComponent();
            this.root.add("version", (BValue)version, 1);
        }
        this.root.add("entry?", (BValue)entry, 1);
        if (++this.limit >= nvaFileEntryLimit) {
            this.save();
        }
    }

    public void close() throws Exception {
        this.save();
    }

    private void initDir() throws Exception {
        FilePath path = null;
        OrdQuery[] queries = this.dirOrd.parse();
        for (int i = 0; i < queries.length; ++i) {
            if (!(queries[i] instanceof FilePath)) continue;
            path = (FilePath)queries[i];
            break;
        }
        if (path == null) {
            throw new Exception("Could not find valid path in Cache Directory ORD!");
        }
        BIFile f = this.space.findFile(path);
        if (f == null) {
            f = this.space.makeDir(path);
        }
        if (!f.isDirectory()) {
            throw new Exception("Cache Dir does not point to a valid Directory!");
        }
        this.dir = (BDirectory)f;
        BIFile[] cacheFiles = NvaEncoder.getCacheFilesFromDir((BIDirectory)this.dir);
        for (int i = 0; i < cacheFiles.length; ++i) {
            cacheFiles[i].delete();
        }
    }

    private void save() throws Exception {
        if (this.dir == null) {
            this.initDir();
        }
        if (this.root == null) {
            return;
        }
        BFileSystem space = BFileSystem.INSTANCE;
        FilePath newPath = this.dir.getFilePath().merge(fileName + String.valueOf(++this.count) + ".nva");
        BIFile file = space.findFile(newPath);
        if (file != null) {
            file.delete();
        }
        file = space.makeFile(newPath);
        ValueDocEncoder encoder = new ValueDocEncoder(file.getOutputStream());
        encoder.setZipped(true);
        encoder.encodeDocument((BValue)this.root);
        encoder.close();
        this.root = null;
        this.limit = 0;
    }

    static BIFile[] getCacheFilesFromDir(BIDirectory dir) {
        Array fileArray = new Array(BIFile.class);
        fileArray.addAll((Object[])dir.listFiles());
        fileArray = fileArray.filter(new IFilter(){

            public boolean accept(Object obj) {
                BIFile file = (BIFile)obj;
                return file.getExtension().toLowerCase().equals("nva");
            }
        });
        fileArray = fileArray.sort((Comparator)new Comparator<BIFile>(){

            @Override
            public int compare(BIFile f1, BIFile f2) {
                int f2Num;
                int f1Num = NvaEncoder.parseOutInt(f1.getFileName());
                if (f1Num == (f2Num = NvaEncoder.parseOutInt(f2.getFileName()))) {
                    return 0;
                }
                if (f1Num < f2Num) {
                    return -1;
                }
                return 1;
            }
        });
        return (BIFile[])fileArray.trim();
    }

    private static int parseOutInt(String s) {
        StringBuffer buff = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < '0' || chars[i] > '9') continue;
            buff.append(chars[i]);
        }
        if (buff.length() == 0) {
            buff.append('0');
        }
        return Integer.parseInt(buff.toString());
    }

    static {
        String entryStr = AccessController.doPrivileged(() -> System.getProperty("niagara.niagaraVirtuals.nvaFileEntryLimit", String.valueOf(3000)));
        try {
            nvaFileEntryLimit = Integer.parseInt(entryStr);
            if (nvaFileEntryLimit < 5) {
                nvaFileEntryLimit = 5;
            }
        }
        catch (NumberFormatException e) {
            nvaFileEntryLimit = 3000;
        }
    }
}

