/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.cache;

import com.tridium.nv.cache.BNvaEntry;
import com.tridium.nv.cache.NvaEncoder;
import javax.baja.collection.AbstractCursor;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.io.ValueDocDecoder;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;

public final class NvaDecoder {
    private BIFile[] files;

    private NvaDecoder(BIFile[] files) {
        this.files = files;
    }

    public static NvaDecoder make(BObject base, BOrd dirOrd) {
        try {
            BIDirectory dir = (BIDirectory)dirOrd.get(base);
            return new NvaDecoder(NvaEncoder.getCacheFilesFromDir(dir));
        }
        catch (Exception e) {
            return new NvaDecoder(new BIFile[0]);
        }
    }

    public static NvaDecoder make(BIFile file) {
        return new NvaDecoder(new BIFile[]{file});
    }

    public Cursor<BNvaEntry> getCursor() throws Exception {
        return new NvaCursor(this.files, false);
    }

    private static boolean next(Cursor<BValue> c, Class<?> cls) {
        while (c.next()) {
            if (!cls.isInstance(c.get())) continue;
            return true;
        }
        return false;
    }

    public Cursor<BNvaEntry> getReverseCursor() throws Exception {
        return new NvaCursor(this.files, true);
    }

    private static class ReversePropertyCursor
    extends AbstractCursor<BValue> {
        private Property[] props;
        private int index = 0;
        private BComplex clx;
        private BValue val;

        ReversePropertyCursor(BComplex clx) {
            this.clx = clx;
            this.props = clx.getPropertiesArray();
            this.index = this.props.length;
            this.val = null;
        }

        protected BValue doGet() {
            return this.val;
        }

        protected boolean advanceCursor() {
            if (--this.index < 0) {
                return false;
            }
            this.val = this.clx.get(this.props[this.index]);
            return true;
        }
    }

    private static final class NvaCursor
    extends AbstractCursor<BNvaEntry> {
        private int fileIndex = 0;
        private Cursor<BValue> cursor;
        private boolean reverse = false;
        private BIFile[] nFiles;

        private NvaCursor(BIFile[] nFiles, boolean reverse) {
            if (reverse) {
                BIFile[] temp = new BIFile[nFiles.length];
                for (int i = 0; i < nFiles.length; ++i) {
                    temp[i] = nFiles[nFiles.length - 1 - i];
                }
                nFiles = temp;
            }
            this.nFiles = nFiles;
            this.reverse = reverse;
        }

        protected BNvaEntry doGet() {
            if (this.cursor == null) {
                return null;
            }
            BObject obj = (BObject)this.cursor.get();
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof BNvaEntry)) {
                return null;
            }
            return (BNvaEntry)obj.asValue().newCopy(true);
        }

        protected boolean advanceCursor() {
            boolean res;
            if (this.cursor != null && (res = NvaDecoder.next((Cursor<BValue>)this.cursor, BNvaEntry.class))) {
                return true;
            }
            while (this.loadCursorFromNextFile()) {
                if (!NvaDecoder.next((Cursor<BValue>)this.cursor, BNvaEntry.class)) continue;
                return true;
            }
            return false;
        }

        private boolean loadCursorFromNextFile() {
            if (this.fileIndex >= this.nFiles.length) {
                this.cursor = null;
                return false;
            }
            BValue val = null;
            try {
                val = new ValueDocDecoder(this.nFiles[this.fileIndex++]).decodeDocument();
                BComponent comp = (BComponent)val;
                this.cursor = this.reverse ? new ReversePropertyCursor((BComplex)comp) : comp.getProperties();
                return true;
            }
            catch (Exception e) {
                System.out.println("Decoding Niagara Virtual Archive File...");
                e.printStackTrace();
                this.cursor = null;
                return false;
            }
        }
    }
}

