/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import com.tridium.nv.BNiagaraVirtualComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

public final class NiagaraVirtualUtil {
    private static Type[] unsupportedWritableFE = null;
    private static Pattern virtualPathCharsPattern;

    private NiagaraVirtualUtil() {
    }

    static BValue resolvePath(BComplex root, SlotPath path) {
        if (path == null) {
            return null;
        }
        String[] names = path.getNames();
        BComplex val = root;
        for (int i = 0; i < names.length; ++i) {
            if (!(val instanceof BComplex)) {
                return null;
            }
            BComplex clx = val.asComplex();
            Property prop = clx.getProperty(path instanceof VirtualPath ? VirtualPath.toSlotPathName((String)names[i]) : names[i]);
            if (prop == null) {
                return null;
            }
            val = clx.get(prop);
        }
        return val;
    }

    public static VirtualPath fromServerOrdToClientVirtual(BOrd rootSlotOrd, BOrd ord) {
        List<String> rootNames = NiagaraVirtualUtil.fromServerOrdToClientVirtualPathNames(rootSlotOrd, true);
        return NiagaraVirtualUtil.fromServerOrdToClientVirtualPath(ord, rootNames.size());
    }

    private static List<String> fromServerOrdToClientVirtualPathNames(BOrd ord, boolean includeBackups) {
        OrdQuery[] queries = ord.parse();
        ArrayList<String> names = new ArrayList<String>();
        for (OrdQuery query : queries) {
            int j;
            if (!(query instanceof SlotPath)) continue;
            SlotPath path = (SlotPath)query;
            if (query instanceof VirtualPath && path.isAbsolute()) {
                names.add("virtual");
            }
            if (includeBackups && path.getBackupDepth() > 0) {
                for (j = 0; j < path.getBackupDepth(); ++j) {
                    names.add("..");
                }
            }
            for (j = 0; j < path.depth(); ++j) {
                names.add(path instanceof VirtualPath ? path.nameAt(j) : VirtualPath.toVirtualPathName((String)path.nameAt(j)));
            }
        }
        return names;
    }

    private static VirtualPath fromServerOrdToClientVirtualPath(BOrd ord, int skipFromBeginning) {
        OrdQuery[] queries = ord.parse();
        ArrayList<String> names = new ArrayList<String>();
        int skipsRemaining = skipFromBeginning;
        ArrayList<Integer> virtualPathStartIndexes = new ArrayList<Integer>();
        for (OrdQuery query : queries) {
            int i;
            if (!(query instanceof SlotPath)) continue;
            SlotPath path = (SlotPath)query;
            if (query instanceof VirtualPath && path.isAbsolute() && --skipsRemaining < 0) {
                names.add("virtual");
                virtualPathStartIndexes.add(names.size() - 1);
            }
            int backups = path.getBackupDepth();
            for (i = names.size() - 1; backups > 0 && i >= 0; --i) {
                names.remove(i);
                if (virtualPathStartIndexes.contains(i)) continue;
                --backups;
            }
            for (i = 0; i < backups; ++i) {
                if (--skipsRemaining >= 0) continue;
                names.add("..");
            }
            for (i = 0; i < path.depth(); ++i) {
                if (--skipsRemaining >= 0) continue;
                names.add(path instanceof VirtualPath ? path.nameAt(i) : VirtualPath.toVirtualPathName((String)path.nameAt(i)));
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            if (i != 0 || !"..".equals(name)) {
                sb.append('/');
            }
            sb.append(name);
        }
        return new VirtualPath(sb.toString());
    }

    public static BOrd fromClientVirtualToServerOrd(BOrd rootOrd, BComponent root, VirtualPath vPath) {
        String newSlotStr;
        StringBuffer buff = new StringBuffer(rootOrd.toString());
        boolean isVirtualPath = false;
        boolean addedVirtualScheme = false;
        int size = vPath.depth();
        if (root instanceof BVirtualComponent) {
            isVirtualPath = true;
            addedVirtualScheme = true;
        } else if (root instanceof BVirtualGateway && size > 0 && vPath.nameAt(0).equals("virtual")) {
            isVirtualPath = true;
        }
        BComponent comp = root;
        for (int i = 0; i < size; ++i) {
            if (isVirtualPath) {
                if (!addedVirtualScheme) {
                    buff.append("|virtual:/");
                    addedVirtualScheme = true;
                    continue;
                }
                if (buff.charAt(buff.length() - 1) != '/') {
                    buff.append("/");
                }
                buff.append(vPath.nameAt(i));
                continue;
            }
            String slotName = VirtualPath.toSlotPathName((String)vPath.nameAt(i));
            Slot slot = comp.getSlot(slotName);
            if (slot == null) {
                buff = new StringBuffer();
                break;
            }
            if (buff.charAt(buff.length() - 1) != '/') {
                buff.append("/");
            }
            buff.append(slotName);
            if (!slot.isProperty()) continue;
            BValue val = comp.get(slot.asProperty());
            if (val instanceof BVirtualGateway) {
                comp = (BComponent)val;
                if (i + 1 >= size || !vPath.nameAt(i + 1).equals("virtual")) continue;
                isVirtualPath = true;
                continue;
            }
            if (!(val instanceof BComponent)) break;
            comp = (BComponent)val;
        }
        if ((newSlotStr = buff.toString()).length() > 0) {
            return BOrd.make((String)newSlotStr);
        }
        return BOrd.NULL;
    }

    public static VirtualPath toVirtualPath(BOrd ord) {
        int i;
        if (ord.isNull()) {
            return null;
        }
        OrdQuery[] queries = ord.parse();
        for (i = 0; i < queries.length; ++i) {
            if (!(queries[i] instanceof VirtualPath)) continue;
            return (VirtualPath)queries[i];
        }
        for (i = 0; i < queries.length; ++i) {
            if (!(queries[i] instanceof SlotPath)) continue;
            return VirtualPath.convertFromSlotPath((SlotPath)((SlotPath)queries[i]));
        }
        return null;
    }

    static String getSlotNameFromVirtualPath(VirtualPath vPath) {
        return VirtualPath.toSlotPathName((String)NiagaraVirtualUtil.getPathNameFromVirtualPath(vPath));
    }

    public static String getPathNameFromVirtualPath(VirtualPath vPath) {
        return vPath.nameAt(vPath.depth() - 1);
    }

    public static BOrd toSlotOrd(BOrd rootOrd, BComponent comp, String propName) {
        OrdQuery[] queries = comp.getNavOrd().relativizeToHost().parse();
        if (propName.length() > 0) {
            int lastIndex = queries.length - 1;
            if (queries[lastIndex] instanceof VirtualPath) {
                VirtualPath vPath = (VirtualPath)queries[lastIndex];
                queries[lastIndex] = vPath.merge((SlotPath)new VirtualPath(VirtualPath.toVirtualPathName((String)propName)));
            } else if (queries[lastIndex] instanceof SlotPath) {
                SlotPath path = (SlotPath)queries[lastIndex];
                queries[lastIndex] = path.merge(new SlotPath(propName));
            }
        }
        if (!rootOrd.isNull()) {
            return BOrd.make((BOrd)rootOrd, (BOrd)BOrd.make((OrdQuery[])queries)).normalize();
        }
        return BOrd.make((OrdQuery[])queries);
    }

    static BOrd addSlotNameToOrd(BOrd slotOrd, String slotName) {
        int lastIndex;
        if (slotOrd.isNull()) {
            return BOrd.NULL;
        }
        OrdQuery[] queries = slotOrd.parse();
        if (queries[lastIndex = queries.length - 1] instanceof VirtualPath) {
            VirtualPath nPath = (VirtualPath)queries[lastIndex];
            queries[lastIndex] = nPath.merge((SlotPath)new VirtualPath(VirtualPath.toVirtualPathName((String)slotName)));
        } else if (queries[lastIndex] instanceof SlotPath) {
            SlotPath path = (SlotPath)queries[lastIndex];
            queries[lastIndex] = path.merge(new SlotPath(slotName));
        }
        return BOrd.make((OrdQuery[])queries);
    }

    public static BOrd convertOrdTargetToClientVirtual(OrdTarget target) {
        BOrd ord = target.getComponent().getNavOrd();
        OrdQuery[] queries = ord.parse();
        boolean unescape = queries[queries.length - 1].getScheme().equals("virtual");
        Property[] slots = target.getPropertyPathInComponent();
        if (slots == null && target.getSlotInComponent() != null) {
            slots = new Slot[]{target.getSlotInComponent()};
        }
        if (slots != null) {
            for (int i = 0; i < slots.length; ++i) {
                String sName = slots[i].getName();
                if (unescape) {
                    sName = VirtualPath.toVirtualPathName((String)sName);
                }
                ord = BOrd.make((String)(ord.toString() + "/" + sName));
            }
        }
        List<String> clientVirtPathNames = NiagaraVirtualUtil.fromServerOrdToClientVirtualPathNames(ord, false);
        return BOrd.make((OrdQuery)new VirtualPath("virtual", clientVirtPathNames.toArray(new String[clientVirtPathNames.size()])));
    }

    static void findVirtualComponents(Array<BNiagaraVirtualComponent> a, BNiagaraVirtualComponent c) {
        if (c == null) {
            return;
        }
        if (c instanceof BNiagaraVirtualComponent) {
            a.add((Object)c);
        }
        BNiagaraVirtualComponent[] comps = (BNiagaraVirtualComponent[])c.getChildren(BNiagaraVirtualComponent.class);
        for (int i = 0; i < comps.length; ++i) {
            NiagaraVirtualUtil.findVirtualComponents(a, comps[i]);
        }
    }

    public static <T extends BValue> T lookupPropertyFromAncestry(BComplex comp, String propName, Type valueType, Type stopAncestorType) {
        while (comp != null) {
            try {
                BValue val = comp.get(propName);
                if (val != null && val.getType().is(valueType)) {
                    return (T)val;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (comp.getType().is(stopAncestorType)) break;
            comp = comp.getParent();
        }
        return null;
    }

    public static final BObject findInstance(BComponent newTargetParent, String propName, Type targetType) {
        final String pName = propName;
        IFilter filter = new IFilter(){

            public boolean accept(Object obj) {
                if (obj instanceof BComplex) {
                    BComplex clx = (BComplex)obj;
                    return clx.getName().equals(pName);
                }
                return false;
            }
        };
        return NiagaraVirtualUtil.findInstance(newTargetParent, filter, targetType);
    }

    public static final BObject findInstance(BComponent newTargetParent, IFilter filter, Type targetType) {
        Property[] props = newTargetParent.getDynamicPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BValue val = newTargetParent.get(props[i]);
            if (!filter.accept((Object)val)) continue;
            if (!val.getType().is(targetType)) {
                newTargetParent.remove(props[i]);
                return targetType.getInstance();
            }
            return val;
        }
        return targetType.getInstance();
    }

    static HashMap<String, BFormat> getDisplayNamesHashMap(BComponent comp) {
        BNameMap oldDisplayNames = (BNameMap)comp.get("displayNames");
        HashMap<String, BFormat> newDisplayNameMap = new HashMap<String, BFormat>();
        if (oldDisplayNames != null) {
            String[] keys = oldDisplayNames.list();
            for (int i = 0; i < keys.length; ++i) {
                newDisplayNameMap.put(keys[i], oldDisplayNames.get(keys[i]));
            }
        }
        return newDisplayNameMap;
    }

    static void setDisplayNames(BComponent comp, HashMap<String, BFormat> displayNamesMap) {
        if (comp.get("displayNames") != null) {
            comp.set("displayNames", (BValue)BNameMap.make(displayNamesMap));
        } else {
            comp.add("displayNames", (BValue)BNameMap.make(displayNamesMap), 261, null);
        }
    }

    static void updateDisplayNames(BComponent comp, String name, BFormat displayName) {
        if (displayName.getFormat().length() <= 0) {
            return;
        }
        BNameMap nameMap = (BNameMap)comp.get("displayNames");
        boolean add = false;
        if (nameMap == null) {
            nameMap = BNameMap.DEFAULT;
            add = true;
        }
        nameMap = BNameMap.make((BNameMap)nameMap, (String)name, (BFormat)displayName);
        if (!add) {
            comp.set("displayNames", (BValue)nameMap);
        } else {
            comp.add("displayNames", (BValue)nameMap, 261, null);
        }
    }

    static int getVirtualFlags(BValue val, int flags, BFacets facets) {
        AgentList list;
        AgentInfo[] infos;
        String typeSpecStr;
        int i;
        if ((flags & 1) == 1) {
            return flags;
        }
        if ((flags & 0x10000000) != 0x10000000) {
            return flags;
        }
        Type wbType = null;
        try {
            wbType = Sys.getType((String)"workbench:WbFieldEditor");
        }
        catch (Exception e) {
            return flags;
        }
        if (unsupportedWritableFE == null) {
            String[] strs = Sys.getRegistry().getDefs("niagaraDriver.virtual.fe");
            Array ar = new Array(Type.class);
            for (i = 0; i < strs.length; ++i) {
                try {
                    ar.add((Object)Sys.getType((String)strs[i]));
                    continue;
                }
                catch (ModuleException moduleException) {
                    continue;
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            unsupportedWritableFE = (Type[])ar.trim();
        }
        if ((typeSpecStr = facets.gets("fieldEditor", "")).length() <= 0 && (infos = (list = val.getAgents().filter(AgentFilter.is((Type)wbType))).list()).length > 0) {
            typeSpecStr = infos[0].getAgentType().getTypeSpec().toString();
        }
        if (typeSpecStr.length() > 0) {
            try {
                Type t = Sys.getType((String)typeSpecStr);
                for (i = 0; i < unsupportedWritableFE.length; ++i) {
                    if (!t.is(unsupportedWritableFE[i])) continue;
                    flags |= 1;
                    break;
                }
            }
            catch (ModuleException moduleException) {
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return flags;
    }

    public static boolean hasIllegalVirtualPathChars(String slotName) {
        return virtualPathCharsPattern.matcher(slotName).find();
    }

    static {
        try {
            virtualPathCharsPattern = Pattern.compile("\\$(2[Ff]|7[Cc]|24|3[Aa])");
        }
        catch (PatternSyntaxException e) {
            Logger.getLogger(NiagaraVirtualUtil.class.getCanonicalName()).log(Level.SEVERE, "virtualPathCharsPattern", e);
        }
    }
}

