/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui.editors;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.enums.BAaPhpDataTypesEnum;
import com.tridium.aaphp.util.AaPhpOrdParser;
import com.tridium.aaphp.util.AaPhpTextUtil;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import com.tridium.workbench.fieldeditors.BStringFE;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BAaPhpStarAttrOrdEditor
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BAaPhpStarAttrOrdEditor.class);
    public static String COLON_PIPE = ":|";
    static final String PRESET_AAPHP_ORD = "aaphp" + COLON_PIPE + "point" + COLON_PIPE + "channel" + ':';
    static final BFacets MIN_00_MAX_FF = BFacets.makeInt((int)0, (int)255);
    static final String SUB_UNIT_LABEL = BAaPhpDevice.LEXICON.getTextAsName("starAttrOrdEditor.subUnit");
    static final String AAPHP_TYPE_LABEL = BAaPhpDevice.LEXICON.getTextAsName("starAttrOrdEditor.aaphpType");
    static final String CARD_LABEL = BAaPhpDevice.LEXICON.getTextAsName("starAttrOrdEditor.card");
    static final String CHANNEL_LABEL = BAaPhpDevice.LEXICON.getTextAsName("starAttrOrdEditor.channel");
    static final String ATTR_LABEL = BAaPhpDevice.LEXICON.getTextAsName("starAttrOrdEditor.attr");
    BIntegerFE subUnit = new BIntegerFE();
    BFrozenEnumFE aaphpType = new BFrozenEnumFE();
    BIntegerFE card = new BIntegerFE();
    BIntegerFE channel = new BIntegerFE();
    BStringFE attr = new BStringFE();

    public Type getType() {
        return TYPE;
    }

    public BAaPhpStarAttrOrdEditor() {
        BGridPane pane = new BGridPane(2);
        pane.add("r1c1", (BValue)new BLabel(SUB_UNIT_LABEL));
        pane.add("r1c2", (BValue)this.subUnit);
        pane.add("r2c1", (BValue)new BLabel(AAPHP_TYPE_LABEL));
        pane.add("r2c2", (BValue)this.aaphpType);
        pane.add("r3c1", (BValue)new BLabel(CARD_LABEL));
        pane.add("r3c2", (BValue)this.card);
        pane.add("r4c1", (BValue)new BLabel(CHANNEL_LABEL));
        pane.add("r4c2", (BValue)this.channel);
        pane.add("r5c1", (BValue)new BLabel(ATTR_LABEL));
        pane.add("r5c2", (BValue)this.attr);
        this.setContent((BWidget)pane);
        this.linkTo("lk0", (BComponent)this.subUnit, (Slot)BIntegerFE.setModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.subUnit, (Slot)BIntegerFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.aaphpType, (Slot)BFrozenEnumFE.setModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.aaphpType, (Slot)BFrozenEnumFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk4", (BComponent)this.card, (Slot)BIntegerFE.setModified, (Slot)setModified);
        this.linkTo("lk5", (BComponent)this.card, (Slot)BIntegerFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk6", (BComponent)this.channel, (Slot)BIntegerFE.setModified, (Slot)setModified);
        this.linkTo("lk7", (BComponent)this.channel, (Slot)BIntegerFE.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk8", (BComponent)this.subUnit, (Slot)BStringFE.setModified, (Slot)setModified);
        this.linkTo("lk9", (BComponent)this.subUnit, (Slot)BStringFE.actionPerformed, (Slot)actionPerformed);
    }

    protected void doLoadValue(BObject value, Context cx) {
        try {
            AaPhpOrdParser aaphpOrdParser = new AaPhpOrdParser(((BString)value).getString());
            if (aaphpOrdParser.isChannelAttr()) {
                String aaphpChannel = aaphpOrdParser.getChannel();
                int starSubUnit = Integer.parseInt(aaphpChannel.substring(0, 2), 16);
                BAaPhpDataTypesEnum starAaPhpType = BAaPhpDataTypesEnum.make((int)Integer.parseInt(aaphpChannel.substring(2, 4), 16));
                int starCard = Integer.parseInt(aaphpChannel.substring(4, 6), 16);
                int starChannel = Integer.parseInt(aaphpChannel.substring(6, 8), 16);
                this.subUnit.loadValue((BObject)BInteger.make((int)starSubUnit), (Context)MIN_00_MAX_FF);
                this.aaphpType.loadValue((BObject)starAaPhpType);
                this.card.loadValue((BObject)BInteger.make((int)starCard), (Context)MIN_00_MAX_FF);
                this.channel.loadValue((BObject)BInteger.make((int)starChannel), (Context)MIN_00_MAX_FF);
                this.attr.loadValue((BObject)BString.make((String)aaphpOrdParser.getAttr()));
            }
        }
        catch (BajaRuntimeException bre) {
            this.subUnit.loadValue((BObject)BInteger.make((int)0), (Context)MIN_00_MAX_FF);
            this.aaphpType.loadValue((BObject)BAaPhpDataTypesEnum.sy);
            this.card.loadValue((BObject)BInteger.make((int)0), (Context)MIN_00_MAX_FF);
            this.channel.loadValue((BObject)BInteger.make((int)0), (Context)MIN_00_MAX_FF);
            this.attr.loadValue((BObject)BString.make((String)"CV"));
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        BInteger starSubUnit = (BInteger)this.subUnit.saveValue();
        BAaPhpDataTypesEnum starAaPhpType = (BAaPhpDataTypesEnum)this.aaphpType.saveValue();
        BInteger starCard = (BInteger)this.card.saveValue();
        BInteger starChannel = (BInteger)this.channel.saveValue();
        BString starAttr = (BString)this.attr.saveValue();
        StringBuffer aaphpOrdBuf = new StringBuffer(PRESET_AAPHP_ORD);
        aaphpOrdBuf.append(AaPhpTextUtil.byteToString((int)starSubUnit.getInt()));
        aaphpOrdBuf.append(AaPhpTextUtil.byteToString((int)starAaPhpType.getOrdinal()));
        aaphpOrdBuf.append(AaPhpTextUtil.byteToString((int)starCard.getInt()));
        aaphpOrdBuf.append(AaPhpTextUtil.byteToString((int)starChannel.getInt()));
        aaphpOrdBuf.append("attr").append(':');
        aaphpOrdBuf.append(AaPhpTextUtil.truncate((String)AaPhpTextUtil.padLeft((String)starAttr.getString(), (int)2), (int)2));
        return BString.make((String)aaphpOrdBuf.toString());
    }

    protected void doSetReadonly(boolean readonly) {
        this.subUnit.setReadonly(readonly);
        this.aaphpType.setReadonly(readonly);
        this.card.setReadonly(readonly);
        this.channel.setReadonly(readonly);
        this.attr.setReadonly(readonly);
    }
}

