/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.aaphp.BAaPhpStarDevice;
import com.tridium.aaphp.datatypes.BAaPhpLearnStarPointsParam;
import com.tridium.aaphp.datatypes.BAaPhpStarAttribute;
import com.tridium.aaphp.job.BAaPhpLearnStarPointsJob;
import com.tridium.aaphp.point.BAaPhpPointDeviceExt;
import com.tridium.aaphp.point.BAaPhpStarPointFolder;
import com.tridium.aaphp.point.BAaPhpStarProxyExt;
import com.tridium.aaphp.ui.AaPhpBooleanWritableActionSupport;
import com.tridium.aaphp.ui.AaPhpExaminePointDiscoveryCommand;
import com.tridium.aaphp.ui.AaPhpStarPointState;
import com.tridium.aaphp.ui.BAaPhpDeviceManager;
import java.util.ArrayList;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BAaPhpStarPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BAaPhpStarPointManager.class);
    static Lexicon lex = Lexicon.make(BAaPhpDeviceManager.class);
    static BImage floatElementIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
    static BImage booleanElementIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
    static BImage enumElementIcon = BImage.make((String)"module://icons/x16/statusEnum.png");
    static BImage stringElementIcon = BImage.make((String)"module://icons/x16/statusString.png");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colToString = new MgrColumn.ToString("Out", 0);
    MgrColumn colSubUnit = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BAaPhpStarProxyExt.aaPhpOrd, BAaPhpStarAttribute.subUnit}, 1);
    MgrColumn colCard = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BAaPhpStarProxyExt.aaPhpOrd, BAaPhpStarAttribute.card}, 1);
    MgrColumn colChannel = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BAaPhpStarProxyExt.aaPhpOrd, BAaPhpStarAttribute.channel}, 1);
    MgrColumn colSubChannel = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BAaPhpStarProxyExt.aaPhpOrd, BAaPhpStarAttribute.subChannel}, 3);
    MgrColumn colFundType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BAaPhpStarProxyExt.aaPhpOrd, BAaPhpStarAttribute.fundamentalType}, 1);
    MgrColumn colAttr = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BAaPhpStarProxyExt.aaPhpOrd, BAaPhpStarAttribute.attr}, 1);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn colNumericEncodingType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BAaPhpStarProxyExt.aaPhpOrd, BAaPhpStarAttribute.numericEncodingType}, 3);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colSubUnit, this.colCard, this.colChannel, this.colSubChannel, this.colFundType, this.colAttr, this.colToString, this.colNumericEncodingType, this.colEnabled, this.colFacets, this.colTuning, this.colDeviceFacets, this.colConversion, this.colFaultCause, this.colReadValue, this.colWriteValue};

    public Type getType() {
        return TYPE;
    }

    public BAaPhpStarDevice getAaPhpStarDevice() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BAaPhpStarPointFolder) {
            return (BAaPhpStarDevice)((BAaPhpStarPointFolder)owner).getDevice();
        }
        return (BAaPhpStarDevice)((BAaPhpPointDeviceExt)owner).getDevice();
    }

    void updateLearnData(BAaPhpLearnStarPointsJob starLearnJob) {
        try {
            starLearnJob.getLearnedPoints().getComponentSpace().sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLearn().updateRoots(starLearnJob.getLearnedPoints().getChildren(BAaPhpStarAttribute.class));
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
    }

    public void handleComponentEvent(BComponentEvent event) {
        BAaPhpLearnStarPointsJob starJob = (BAaPhpLearnStarPointsJob)this.getLearn().getJob();
        if (starJob != null && event.getId() == 5 && event.getSlot().equals((Object)BAaPhpLearnStarPointsJob.learnedEntirePoint)) {
            this.updateLearnData(starJob);
        }
        super.handleComponentEvent(event);
    }

    protected MgrModel makeModel() {
        return new StarModel(this);
    }

    protected MgrLearn makeLearn() {
        return new StarLearn(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrState makeState() {
        return new AaPhpStarPointState();
    }

    class StarLearn
    extends MgrLearn {
        StarLearn(BAaPhpStarPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        public boolean hasChildren(Object discovery) {
            return ((BAaPhpStarAttribute)discovery).getChildComponents() != null && ((BAaPhpStarAttribute)discovery).getChildComponents().length > 0;
        }

        public Object[] getChildren(Object discovery) {
            BAaPhpStarAttribute mainCv = (BAaPhpStarAttribute)discovery;
            mainCv.lease(5000);
            try {
                mainCv.getComponentSpace().sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mainCv.getChildren(BAaPhpStarAttribute.class);
        }

        public boolean isDepthExpandable(int depth) {
            return depth == 0;
        }

        public BImage getIcon(Object discovery) {
            BAaPhpStarAttribute pi = (BAaPhpStarAttribute)discovery;
            MgrTypeInfo ti = this.getDefaultCpType(pi);
            if (ti == PointModel.NUMERIC_POINT || ti == PointModel.NUMERIC_WRITABLE) {
                return floatElementIcon;
            }
            if (ti == PointModel.BOOLEAN_POINT || ti == PointModel.BOOLEAN_WRITABLE) {
                return booleanElementIcon;
            }
            if (ti == PointModel.ENUM_POINT || ti == PointModel.ENUM_WRITABLE) {
                return enumElementIcon;
            }
            return stringElementIcon;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Prop(BAaPhpStarAttribute.subUnit, 1), new MgrColumn.Prop(BAaPhpStarAttribute.card, 1), new MgrColumn.Prop(BAaPhpStarAttribute.channel, 1), new MgrColumn.Prop(BAaPhpStarAttribute.subChannel, 1), new MgrColumn.Prop(BAaPhpStarAttribute.attr, 1), new MgrColumn.Prop(BAaPhpStarAttribute.discoverValue, 1), new MgrColumn.Prop(BAaPhpStarAttribute.fundamentalType, 3), new MgrColumn.Prop(BAaPhpStarAttribute.rawDataHex, 6), new MgrColumn.Prop(BAaPhpStarAttribute.numericEncodingType, 6)};
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            BAaPhpStarAttribute learnEntry = (BAaPhpStarAttribute)discovery;
            row.setDefaultName(learnEntry.getPropertyInParent().getName());
            row.setCell(BAaPhpStarPointManager.this.colSubUnit, (BValue)BInteger.make((int)learnEntry.getSubUnit()));
            row.setCell(BAaPhpStarPointManager.this.colCard, (BValue)BInteger.make((int)learnEntry.getCard()));
            row.setCell(BAaPhpStarPointManager.this.colChannel, (BValue)BInteger.make((int)learnEntry.getChannel()));
            row.setCell(BAaPhpStarPointManager.this.colSubChannel, (BValue)BInteger.make((int)learnEntry.getSubChannel()));
            row.setCell(BAaPhpStarPointManager.this.colFundType, (BValue)learnEntry.getFundamentalType());
            row.setCell(BAaPhpStarPointManager.this.colAttr, (BValue)BString.make((String)learnEntry.getAttr()));
            row.setCell(BAaPhpStarPointManager.this.colFacets, (BValue)learnEntry.getPropertyInParent().getFacets());
            row.setCell(BAaPhpStarPointManager.this.colNumericEncodingType, (BValue)BInteger.make((int)learnEntry.getNumericEncodingType()));
        }

        public boolean isExisting(Object discovery, BComponent component) {
            if (component instanceof BControlPoint) {
                BAaPhpStarAttribute sa = (BAaPhpStarAttribute)discovery;
                BControlPoint ct = (BControlPoint)component;
                BAbstractProxyExt p = ct.getProxyExt();
                if (p instanceof BAaPhpStarProxyExt) {
                    return ((BAaPhpStarProxyExt)p).getAaPhpOrd().equivalent((Object)sa);
                }
            }
            return super.isExisting(discovery, component);
        }

        public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
            ArrayList<MgrTypeInfo> allTypes = new ArrayList<MgrTypeInfo>();
            MgrTypeInfo defaultType = this.getDefaultCpType((BAaPhpStarAttribute)discovery);
            if (defaultType == PointModel.STRING_POINT) {
                allTypes.add(PointModel.STRING_POINT);
                allTypes.add(PointModel.STRING_WRITABLE);
                PointModel.addEnumPointTypes(allTypes, (boolean)true);
                PointModel.addBooleanPointTypes(allTypes, (boolean)true);
                PointModel.addNumericPointTypes(allTypes, (boolean)true);
            } else if (defaultType == PointModel.NUMERIC_POINT) {
                allTypes.add(PointModel.NUMERIC_POINT);
                allTypes.add(PointModel.NUMERIC_WRITABLE);
                PointModel.addEnumPointTypes(allTypes, (boolean)true);
                PointModel.addBooleanPointTypes(allTypes, (boolean)true);
                PointModel.addStringPointTypes(allTypes, (boolean)true);
            } else if (defaultType == PointModel.ENUM_POINT) {
                allTypes.add(PointModel.ENUM_POINT);
                allTypes.add(PointModel.ENUM_WRITABLE);
                PointModel.addNumericPointTypes(allTypes, (boolean)true);
                PointModel.addStringPointTypes(allTypes, (boolean)true);
                PointModel.addBooleanPointTypes(allTypes, (boolean)true);
            } else if (defaultType == PointModel.BOOLEAN_POINT) {
                allTypes.add(PointModel.BOOLEAN_POINT);
                allTypes.add(PointModel.BOOLEAN_WRITABLE);
                PointModel.addEnumPointTypes(allTypes, (boolean)true);
                PointModel.addNumericPointTypes(allTypes, (boolean)true);
                PointModel.addStringPointTypes(allTypes, (boolean)true);
            } else {
                PointModel.addNumericPointTypes(allTypes, (boolean)true);
                PointModel.addBooleanPointTypes(allTypes, (boolean)true);
                PointModel.addStringPointTypes(allTypes, (boolean)true);
                PointModel.addEnumPointTypes(allTypes, (boolean)true);
                allTypes.remove(defaultType);
                ArrayList<MgrTypeInfo> allTypes2 = new ArrayList<MgrTypeInfo>();
                allTypes2.add(defaultType);
                allTypes2.addAll(allTypes);
                allTypes = allTypes2;
            }
            return allTypes.toArray(new MgrTypeInfo[allTypes.size()]);
        }

        public MgrTypeInfo getDefaultCpType(BAaPhpStarAttribute discovery) {
            BFacets facets = discovery.getParent().getSlotFacets((Slot)discovery.getPropertyInParent());
            if (facets == null) {
                return PointModel.STRING_POINT;
            }
            if (facets.get("range") != null) {
                return PointModel.ENUM_POINT;
            }
            if (facets.get("trueText") != null || facets.get("falseText") != null) {
                return PointModel.BOOLEAN_POINT;
            }
            if (facets.get("radix") != null) {
                int rad = facets.geti("radix", 10);
                if (rad != 10) {
                    return PointModel.STRING_POINT;
                }
                return PointModel.NUMERIC_POINT;
            }
            if (facets.get("min") != null || facets.get("max") != null) {
                double min = facets.getd("min", Double.MIN_VALUE);
                double max = facets.getd("max", Double.MAX_VALUE);
                if (min == 0.0 && max == 1.0) {
                    return PointModel.BOOLEAN_POINT;
                }
                return PointModel.NUMERIC_POINT;
            }
            if (facets.get("units") != null) {
                return PointModel.NUMERIC_POINT;
            }
            return PointModel.STRING_POINT;
        }

        public void jobComplete(BJob job) {
            BAaPhpStarPointManager.this.updateLearnData((BAaPhpLearnStarPointsJob)job);
            super.jobComplete(job);
        }
    }

    class Controller
    extends PointController {
        final BAaPhpStarPointManager mgr;
        final AaPhpExaminePointDiscoveryCommand examineDiscovery;

        Controller(BAaPhpStarPointManager mgr) {
            super((BPointManager)mgr);
            this.mgr = mgr;
            this.examineDiscovery = new AaPhpExaminePointDiscoveryCommand(mgr);
            this.examineDiscovery.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return Controller.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.examineDiscovery});
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BAaPhpStarDevice dev = this.mgr.getAaPhpStarDevice();
            dev.lease(5000);
            BAaPhpLearnStarPointsParam param = (BAaPhpLearnStarPointsParam)BWbFieldEditor.dialog((BWidget)this.mgr, (String)lex.getText("starPoints.learnExhaustive.prompt"), (BObject)dev.getLastExhaustiveLearn().newCopy());
            if (param != null) {
                dev.setLastExhaustiveLearn((BAaPhpLearnStarPointsParam)param.newCopy());
                BOrd ordToJob = this.mgr.getAaPhpStarDevice().submitStarBruteDiscoveryJob(param);
                this.mgr.getLearn().setJob(ordToJob);
                BAaPhpStarPointManager.this.updateLearnData((BAaPhpLearnStarPointsJob)this.mgr.getLearn().getJob());
                BAaPhpStarPointManager.this.registerForComponentEvents((BComponent)((BAaPhpLearnStarPointsJob)BAaPhpStarPointManager.this.getLearn().getJob()).getLearnedPoints(), 1);
            }
            return null;
        }

        public void updateCommands() {
            BAaPhpLearnStarPointsJob starDisJob;
            BAaPhpStarAttribute[] learnedStuff;
            BJob learnJob = this.mgr.getLearn().getJob();
            boolean enableSaveDiscovery = false;
            if (learnJob != null && learnJob.getJobState() == BJobState.success && learnJob instanceof BAaPhpLearnStarPointsJob && (learnedStuff = (BAaPhpStarAttribute[])(starDisJob = (BAaPhpLearnStarPointsJob)learnJob).getLearnedPoints().getChildren(BAaPhpStarAttribute.class)) != null && learnedStuff.length > 0) {
                enableSaveDiscovery = true;
            }
            this.examineDiscovery.setEnabled(enableSaveDiscovery);
            super.updateCommands();
        }
    }

    class StarModel
    extends PointModel {
        StarModel(BAaPhpStarPointManager manager) {
            super((BPointManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return BAaPhpStarPointManager.this.cols;
        }

        public int getSubscribeDepth() {
            return 3;
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            for (int i = 0; i < rows.length; ++i) {
                BComponent newCP = rows[i].getTarget();
                if (!(newCP instanceof BBooleanWritable)) continue;
                AaPhpBooleanWritableActionSupport.renameActiveInactiveActions((BBooleanWritable)newCP, ((BBooleanWritable)newCP).getFacets());
            }
            return super.addInstances(rows, cx);
        }
    }
}

