/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.platform.ui.util.BTextOutputPane;
import com.tridium.ui.file.BNFileChooser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.ui.BWidget;

public class AaPhpTextFileCompare {
    final BTextOutputPane outputPane;
    final BIFile file1;
    final BIFile file2;

    public AaPhpTextFileCompare(BTextOutputPane outputPane, BIFile file1, BIFile file2) {
        this.outputPane = outputPane;
        this.file1 = file1;
        this.file2 = file2;
    }

    public static BOrd promptForFile(BWidget parentWidget, String title, BOrd defaultFile, IFileFilter fileFilter) {
        BNFileChooser openDialog = (BNFileChooser)BNFileChooser.makeOpen((BWidget)parentWidget);
        openDialog.setTitle(title);
        openDialog.setCurrentDirectory(defaultFile);
        if (fileFilter != null) {
            openDialog.setCurrentFilter(fileFilter);
        }
        return openDialog.show();
    }

    public void compareOutLn(String out) {
        this.outputPane.append(out);
        this.outputPane.append("\n");
    }

    public void compareAsync() {
        new Thread(new AsyncCompare()).start();
    }

    class AsyncCompare
    implements Runnable {
        AsyncCompare() {
        }

        @Override
        public void run() {
            try {
                BufferedReader fh = new BufferedReader(new InputStreamReader(AaPhpTextFileCompare.this.file1.getInputStream()), 80);
                BufferedReader sh = new BufferedReader(new InputStreamReader(AaPhpTextFileCompare.this.file2.getInputStream()), 80);
                String s = "";
                String y = "";
                AaPhpTextFileCompare.this.compareOutLn("Comparing files:");
                AaPhpTextFileCompare.this.compareOutLn("Was: " + AaPhpTextFileCompare.this.file2.getFilePath());
                AaPhpTextFileCompare.this.compareOutLn("Now: " + AaPhpTextFileCompare.this.file1.getFilePath());
                AaPhpTextFileCompare.this.compareOutLn("===========================================================================================================");
                boolean different = false;
                int file1Line = 0;
                int file2Line = 0;
                while (s != null || y != null) {
                    do {
                        ++file1Line;
                    } while ((s = fh.readLine()) != null && s.trim().length() == 0);
                    do {
                        ++file2Line;
                    } while ((y = sh.readLine()) != null && y.trim().length() == 0);
                    if (y == null && s == null || y != null && s != null && y.equals(s)) continue;
                    String was = "";
                    String now = "";
                    now = s == null ? "<<Empty>>" : (s.trim().length() == 0 ? SlotPath.escape((String)s) : s);
                    was = y == null ? "<<Empty>>" : (y.trim().length() == 0 ? SlotPath.escape((String)y) : y);
                    AaPhpTextFileCompare.this.compareOutLn("Difference:");
                    AaPhpTextFileCompare.this.compareOutLn("Was: " + was + "[Line " + file2Line + "]");
                    AaPhpTextFileCompare.this.compareOutLn("Now: " + now + "[Line " + file1Line + "]");
                    AaPhpTextFileCompare.this.compareOutLn("===========================================================================================================");
                    different = true;
                }
                if (!different) {
                    AaPhpTextFileCompare.this.compareOutLn("No changes detected.");
                }
                sh.close();
                fh.close();
            }
            catch (Exception e) {
                AaPhpTextFileCompare.this.compareOutLn(e.toString() + "[Stack Trace in Workbench Stdout]");
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
    }
}

