/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.datatypes.BAaPhpRecvFileJobParam;
import com.tridium.aaphp.datatypes.BAaPhpRecvFileParam;
import com.tridium.aaphp.ui.BAaPhpDeviceManager;
import com.tridium.aaphp.util.AaPhpOrdParser;
import com.tridium.fox.sys.BFoxSession;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrController;

public class AaPhpRecvFileCommand
extends MgrController.MgrCommand {
    final BAaPhpDeviceManager aaphpDeviceManager;

    public AaPhpRecvFileCommand(BAaPhpDeviceManager aaphpDeviceManager) {
        super((BWidget)aaphpDeviceManager, BAaPhpDevice.LEXICON, "recvFile");
        this.aaphpDeviceManager = aaphpDeviceManager;
    }

    public boolean ifIsOnClient(BOrd saveOrd) {
        try {
            ((BIFile)saveOrd.resolve().get()).getInputStream();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean validateSyntax(BAaPhpRecvFileParam aaphpRecvFileParam) {
        if (aaphpRecvFileParam != null) {
            try {
                new AaPhpOrdParser(aaphpRecvFileParam.getSource());
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.aaphpDeviceManager, (String)"recvFile", (Object)"Unrecognized AaPhp File Ord", (Throwable)e);
                return false;
            }
            return aaphpRecvFileParam.getDestination() != null && aaphpRecvFileParam.getDestination() != BOrd.NULL;
        }
        return false;
    }

    String getFoxSession(BOrd clientSaveOrd) {
        BFoxSession session = (BFoxSession)BOrd.toSession((BObject)this.aaphpDeviceManager.getAaPhpNetwork());
        return session.getConnection().session().getRemoteId();
    }

    void receiveFile(BAaPhpRecvFileParam aaphpRecvFileParam, BAaPhpDevice aaphpDevice) throws Exception {
        BOrd saveTo = aaphpRecvFileParam.getDestination();
        BAaPhpRecvFileJobParam jobParam = new BAaPhpRecvFileJobParam();
        jobParam.setRecvFileParam((BAaPhpRecvFileParam)aaphpRecvFileParam.newCopy());
        if (this.ifIsOnClient(saveTo)) {
            jobParam.setClientSessionId(this.getFoxSession(saveTo));
        }
        BOrd recvFileJobOrd = aaphpDevice.submitRecvFileJob(jobParam);
        this.aaphpDeviceManager.getLearn().setJob(recvFileJobOrd);
        this.aaphpDeviceManager.getController().doLearnMode(true);
    }

    public CommandArtifact doInvoke() throws Exception {
        BAaPhpRecvFileParam aaphpRecvFileParam;
        this.aaphpDeviceManager.getController().learnMode.setSelected(true);
        BAaPhpDevice[] devices = this.aaphpDeviceManager.getSelectedDevices();
        if (devices != null && devices.length > 0 && this.validateSyntax(aaphpRecvFileParam = (BAaPhpRecvFileParam)BWbFieldEditor.dialog((BWidget)this.aaphpDeviceManager, (String)"recvFile", (BObject)this.aaphpDeviceManager.getAaPhpNetwork().getLastRecvFileParam().newCopy()))) {
            this.aaphpDeviceManager.getAaPhpNetwork().setLastRecvFileParam((BAaPhpRecvFileParam)aaphpRecvFileParam.newCopy());
            this.receiveFile(aaphpRecvFileParam, devices[0]);
        }
        return null;
    }
}

