/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.webeditors.ssc;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeConfig;

public class BSimpleConfigurable
extends BObject
implements BTypeConfig.IConfigurable {
    public static final Type TYPE = Sys.loadType(BSimpleConfigurable.class);
    private Map<String, BValue> configMap = new HashMap<String, BValue>();
    private Map<String, BFacets> facetsMap = new HashMap<String, BFacets>();

    public Type getType() {
        return TYPE;
    }

    BSimpleConfigurable(BTypeConfig typeConfig, BComponent comp) {
        for (Property prop : comp.getPropertiesArray()) {
            Slot configSlot = typeConfig.getSlot(prop.getName());
            if (configSlot != null && configSlot.isFrozen()) continue;
            this.configMap.put(prop.getName(), comp.get(prop));
            this.facetsMap.put(prop.getName(), comp.getSlotFacets((Slot)prop));
        }
    }

    public String[] listConfig() {
        Set<String> keys = this.configMap.keySet();
        return this.configMap.keySet().toArray(new String[keys.size()]);
    }

    public BValue getConfig(String key) {
        return this.configMap.get(key);
    }

    public BFacets getConfigFacets(String key) {
        return this.facetsMap.get(key);
    }

    public void setConfig(String key, BValue value) {
        this.configMap.put(key, value);
    }
}

