/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.webChart;

import com.tridium.history.BHistory;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.webChart.WebChartUtil;
import java.io.StringWriter;
import java.util.List;
import javax.baja.file.BIFile;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.schedule.BControlSchedule;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
public final class BWebChartQueryRpc
extends BComponent {
    public static final Type TYPE = Sys.loadType(BWebChartQueryRpc.class);

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getCurrentTime(Context cx) {
        JSONObject obj = new JSONObject();
        obj.put("currentTime", (Object)BAbsTime.now().encodeToString());
        return obj;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getSourceList(String ordString, Context cx) {
        BOrd ord = BOrd.NULL;
        if (ordString != null) {
            ord = BOrd.make((String)ordString);
        }
        StringWriter writer = new StringWriter();
        BHistorySpace historySpace = (BHistorySpace)BOrd.make((String)"history:").get(null, cx);
        if (!historySpace.getPermissions(cx).hasOperatorRead()) {
            return null;
        }
        Array navNodes = new Array(BINavNode.class);
        Array a = new Array(String.class);
        if (ord.isNull()) {
            navNodes.addAll((Object[])historySpace.listDevices());
        } else {
            BINavNode[] o = ord.get(null, cx);
            if (o instanceof BINavNode) {
                BINavNode folder = (BINavNode)o;
                navNodes.addAll((Object[])folder.getNavChildren());
            }
        }
        for (BINavNode navNode : (BINavNode[])navNodes.trim()) {
            BINavNode[] history;
            if (navNode instanceof BIHistory && (history = (BINavNode[])navNode).getRecordType().getResolvedType().is(BTrendRecord.TYPE) && history.getPermissions(cx).hasOperatorRead()) {
                a.add((Object)history.getNavOrd().toString());
            }
            history = navNode.getNavChildren();
            int n = history.length;
            for (int i = 0; i < n; ++i) {
                BIHistory history2;
                BINavNode navChild = history[i];
                if (!(navChild instanceof BIHistory) || !(history2 = (BIHistory)navChild).getRecordType().getResolvedType().is(BTrendRecord.TYPE) || !history2.getPermissions(cx).hasOperatorRead()) continue;
                a.add((Object)history2.getNavOrd().toString());
            }
        }
        JSONWriter out = QuickJSONWriter.make((Appendable)writer);
        out.object();
        out.key("sources").array();
        for (String value : (String[])a.trim()) {
            out.value((Object)value);
        }
        out.endArray();
        out.endObject();
        return new JSONObject(writer.toString());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getInfo(List<String> args, Context cx) throws Exception {
        int i;
        StringWriter writer = new StringWriter();
        Array displayPaths = new Array(String.class);
        Array capacities = new Array(String.class);
        Array valueFacets = new Array(String.class);
        Array recordTypes = new Array(String.class);
        Array timeZoneIds = new Array(String.class);
        for (int i2 = 0; i2 < args.size(); ++i2) {
            String string = args.get(i2);
            if (string.equals("")) continue;
            BOrd ord = BOrd.make((String)string).relativizeToSession().normalize();
            BObject o = ord.get(null, cx);
            if (o instanceof BIProtected && !((BIProtected)o).getPermissions(cx).hasOperatorRead()) {
                return null;
            }
            if (o instanceof BHistory) {
                BHistory history = (BHistory)o;
                capacities.add((Object)("" + history.getConfig().getCapacity().getMaxRecords()));
                BHistoryRecord record = history.getConfig().makeRecord();
                if (record instanceof BTrendRecord) {
                    BTrendRecord trendRecord = (BTrendRecord)record;
                    BFacets facets = (BFacets)history.getConfig().get(trendRecord.getValueProperty().getName() + "Facets");
                    if (facets != null) {
                        valueFacets.add((Object)facets.encodeToString());
                    } else {
                        valueFacets.add((Object)"");
                    }
                    recordTypes.add((Object)("" + trendRecord.getValueProperty().getType()));
                }
                timeZoneIds.add((Object)history.getConfig().getTimeZone().getId());
            } else if (o instanceof BControlSchedule) {
                BControlSchedule schedule = (BControlSchedule)o;
                BStatusValue statusValue = (BStatusValue)schedule.getProperty("out").getType().getInstance();
                recordTypes.add((Object)("" + statusValue.getValueValue().getType()));
                BFacets facets = schedule.getFacets();
                if (facets != null) {
                    valueFacets.add((Object)facets.encodeToString());
                } else {
                    valueFacets.add((Object)"");
                }
            }
            displayPaths.add((Object)WebChartUtil.getNavDisplayPath(o, cx));
        }
        JSONWriter out = QuickJSONWriter.make((Appendable)writer);
        out.object();
        out.key("capacities").array();
        for (i = 0; i < capacities.size(); ++i) {
            out.value(capacities.get(i));
        }
        out.endArray();
        out.key("valueFacets").array();
        for (i = 0; i < valueFacets.size(); ++i) {
            out.value(valueFacets.get(i));
        }
        out.endArray();
        out.key("recordTypes").array();
        for (i = 0; i < recordTypes.size(); ++i) {
            out.value(recordTypes.get(i));
        }
        out.endArray();
        out.key("displayPaths").array();
        for (i = 0; i < displayPaths.size(); ++i) {
            out.value(displayPaths.get(i));
        }
        out.endArray();
        out.key("timezoneIDs").array();
        for (i = 0; i < timeZoneIds.size(); ++i) {
            out.value(timeZoneIds.get(i));
        }
        out.endArray();
        out.endObject();
        return new JSONObject(writer.toString());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static String getStationsTimeZoneId(Context cx) {
        return BTimeZone.getLocal().getId();
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getPermissions(String ordString, Context cx) throws Exception {
        StringWriter writer = new StringWriter();
        BOrd ord = BOrd.make((String)ordString);
        JSONWriter out = QuickJSONWriter.make((Appendable)writer);
        out.object();
        out.key("permissions");
        BPermissions permissions = BWebChartQueryRpc.getPermissionsOnOrd(ord, cx);
        out.value((Object)permissions.encodeToString());
        out.endObject();
        return new JSONObject(writer.toString());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getDisplayPath(String path, Context cx) throws Exception {
        StringWriter writer = new StringWriter();
        BOrd ord = BOrd.make((String)path).relativizeToSession().normalize();
        BObject o = ord.get(null, cx);
        if (o instanceof BIProtected && !((BIProtected)o).getPermissions(cx).hasOperatorRead()) {
            return null;
        }
        JSONWriter out = QuickJSONWriter.make((Appendable)writer);
        out.object();
        out.key("displayPath");
        out.value((Object)WebChartUtil.getNavDisplayPath(o, cx));
        out.endObject();
        return new JSONObject(writer.toString());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getChartSettings(String ordString, Context cx) {
        try {
            BOrd ord = BOrd.make((String)ordString);
            BIFile file = (BIFile)ord.get(null, cx);
            return new JSONObject(new String(file.read()));
        }
        catch (Exception e) {
            return null;
        }
    }

    static BPermissions getPermissionsOnOrd(BOrd ord, Context cx) {
        try {
            OrdTarget target = ord.resolve(null, cx);
            return target.getPermissionsForTarget();
        }
        catch (UnresolvedException e) {
            BOrd parentPath = ord.getParent();
            if (parentPath != null) {
                return BWebChartQueryRpc.getPermissionsOnOrd(parentPath, cx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BPermissions.none;
    }
}

