/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.tls.BTlsConsole;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTlsPointDeviceExt;
import com.tridium.tls.util.ClearDataAsyncRequest;
import com.tridium.tls.util.ReadDataAsyncRequest;
import javax.baja.control.BIWritablePoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BTlsProxyExt
extends BBasicProxyExt
implements TlsMessageConst,
BIBasicPollable {
    public static final Property pollFrequency = BTlsProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Action readData = BTlsProxyExt.newAction((int)0, null);
    public static final Action clearData = BTlsProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTlsProxyExt.class);
    protected long lastPollTicks;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public void readData() {
        this.invoke(readData, null, null);
    }

    public void clearData() {
        this.invoke(clearData, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BTlsPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        BComplex parent = this.getParent();
        if (parent instanceof BIWritablePoint) {
            return BReadWriteMode.readWrite;
        }
        return BReadWriteMode.readonly;
    }

    public boolean pollIntervalCheck(long minimumPollInterval) {
        boolean pollDebug;
        boolean bl = pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        if (pollDebug) {
            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollIntervalCheck... check for minimumPollInterval");
        }
        if (minimumPollInterval == 0L) {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollIntervalCheck... minimumPollInterval set for never poll");
            }
            return false;
        }
        long curTicks = System.currentTimeMillis();
        if (minimumPollInterval != 0L && curTicks - this.lastPollTicks < minimumPollInterval) {
            if (pollDebug) {
                long msecTilNextPoll = minimumPollInterval - (curTicks - this.lastPollTicks);
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollIntervalCheck... msec til next pollIntervalCheck=" + msecTilNextPoll);
            }
            return false;
        }
        this.lastPollTicks = curTicks;
        return true;
    }

    public void setValue(Tls350Response rsp) {
    }

    public void doWrite(BStatusValue out) {
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
    }

    public String toString(Context context) {
        try {
            return super.toString(context) + ' ' + this.getParent().getName();
        }
        catch (Exception ex) {
            return super.toString(context);
        }
    }

    public void writeFail(String cause) {
        this.getDevice().ping();
        super.writeFail(cause);
    }

    public BTlsDevice device() {
        return (BTlsDevice)this.getDevice();
    }

    protected BTlsConsole network() {
        return this.device().network();
    }

    protected boolean isTraceOn() {
        return this.getLog().isTraceOn();
    }

    public Log getLog() {
        return this.network().getLog();
    }

    public void poll() {
    }

    public void doReadData(Context cx) throws Exception {
        BTlsConsole network = this.network();
        if (this.isTraceOn() && this.device().getUserData().indexOf("action") != -1) {
            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :readData");
        }
        network.postWrite(new ReadDataAsyncRequest(this));
    }

    public void doClearData(Context cx) throws Exception {
        BTlsConsole network = this.network();
        if (this.isTraceOn() && this.device().getUserData().indexOf("action") != -1) {
            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :clearData");
        }
        network.postWrite(new ClearDataAsyncRequest(this));
    }

    public void readDataNow() {
    }

    public void clearDataNow() {
    }
}

