/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BInTankInvHistoryRecord;
import com.tridium.tls.datatypes.BInTankInventoryEntry;
import com.tridium.tls.datatypes.BInTankInventoryTable;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350InventoryReport;
import com.tridium.tls.messages.Tls350InventoryReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350ItiDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTls350InTankInvProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    public static final Property minimumPollInterval = BTls350InTankInvProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    public static final Property inTankInventoryTable = BTls350InTankInvProxyExt.newProperty((int)0, (BValue)new BInTankInventoryTable(), null);
    public static final Property maxOldEntriesSaved = BTls350InTankInvProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Type TYPE = Sys.loadType(BTls350InTankInvProxyExt.class);
    private Vector<BInTankInventoryEntry> iTIEntriesVector;

    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    public void setMinimumPollInterval(BRelTime v) {
        this.set(minimumPollInterval, (BValue)v, null);
    }

    public BInTankInventoryTable getInTankInventoryTable() {
        return (BInTankInventoryTable)this.get(inTankInventoryTable);
    }

    public void setInTankInventoryTable(BInTankInventoryTable v) {
        this.set(inTankInventoryTable, (BValue)v, null);
    }

    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    public void setMaxOldEntriesSaved(int v) {
        this.setInt(maxOldEntriesSaved, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            TlsHistoryHelper.initHistory(BInTankInvHistoryRecord.TYPE);
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        super.stopped();
    }

    @Override
    public void poll() {
        if (!(this.getDevice().getEnabled() && this.getEnabled() && this.pollIntervalCheck(this.getMinimumPollInterval().getMillis()))) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        int tankNumber = ((BTls350FuelTankDevice)this.device()).getTankNumber();
        Tls350InventoryReport req = new Tls350InventoryReport(tankNumber, this);
        Tls350InventoryReportResponse rsp = (Tls350InventoryReportResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (rsp.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                if (tankNumber == 0) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! proxy point's tank number not initialized... initialize tank number to valid tank\n\n");
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! proxy point's tank number not initialized... initialize tank number to valid tank\n\n");
                    }
                    return;
                }
                if (tankNumber != rsp.getMessageTank()) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + rsp.getMessageTank() + " may be lost\n\n");
                    }
                    return;
                }
                if (rsp.getProduct().trim() == null || rsp.getProduct().trim().length() == 0) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... poll response contains no productCode... nothing to record tankNumber=" + rsp.getMessageTank());
                    }
                    return;
                }
                BAbsTime rt = rsp.getReadTime();
                if (rt == null) {
                    rt = BAbsTime.make();
                }
                String productCode = rsp.getProduct();
                boolean delInProgress = rsp.isDeliveryInProcess();
                boolean leakTestInProg = rsp.isLeakTestInProcess();
                boolean invlFuelHgtAlm = rsp.isInvalidFuelHeight();
                float newVolume = rsp.getVolume();
                float newTcVolume = rsp.getTcVolume();
                float newUllage = rsp.getUllage();
                float newFuelLevel = rsp.getFuelLevel();
                float newWaterLevel = rsp.getWaterLevel();
                float newTemperature = rsp.getTemperature();
                float newWaterVolume = rsp.getWaterVolume();
                this.iTIEntriesVector = new Vector();
                BInTankInventoryEntry newITIEntry = new BInTankInventoryEntry();
                newITIEntry.setStore(Sys.getStation().getStationName());
                newITIEntry.setTank(tankNumber);
                newITIEntry.setReadTime(rt);
                newITIEntry.setProductCode(productCode);
                newITIEntry.setDelInProgress(delInProgress);
                newITIEntry.setLeakTestInProg(leakTestInProg);
                newITIEntry.setInvlFuelHgtAlm(invlFuelHgtAlm);
                newITIEntry.setVolume(newVolume);
                newITIEntry.setTcVolume(newTcVolume);
                newITIEntry.setUllage(newUllage);
                newITIEntry.setFuelLevel(newFuelLevel);
                newITIEntry.setWaterLevel(newWaterLevel);
                newITIEntry.setTemperature(newTemperature);
                newITIEntry.setWaterVolume(newWaterVolume);
                this.iTIEntriesVector.addElement(newITIEntry);
                if (this.iTIEntriesVector.size() > 0) {
                    this.setValue(this.iTIEntriesVector);
                    return;
                }
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)sv);
                this.updateDemuxedProxyPoints();
            } else {
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
    }

    public void setValue(Vector<BInTankInventoryEntry> values) {
        BInTankInventoryEntry[] valuesCopy = new BInTankInventoryEntry[values.size()];
        values.copyInto((Object[])valuesCopy);
        BInTankInventoryTable sendToCsMgrCopy = new BInTankInventoryTable();
        for (int i = 0; i < valuesCopy.length; ++i) {
            try {
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                String newValue = valuesCopy[i].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + newValue);
                }
                sv.setValue(newValue);
                this.readOk((BStatusValue)sv);
                this.getInTankInventoryTable().add("inTankInventoryEntry?", (BValue)valuesCopy[i]);
                sendToCsMgrCopy.add("inTankInventoryEntry?", (BValue)((BInTankInventoryEntry)valuesCopy[i].newCopy()));
                BInTankInvHistoryRecord newrec = new BInTankInvHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), valuesCopy[i]);
                TlsHistoryHelper.appendTlsHistory((BStruct)newrec);
                continue;
            }
            catch (Exception e) {
                this.readFail(e.toString());
            }
        }
        this.updateDemuxedProxyPoints();
        BInTankInventoryEntry[] sortedValues = this.getInTankInventoryTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        int numRemoveEntries = sortedValues.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350InTankInvProxyExt setValue sortedValues.length=" + sortedValues.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (numRemoveEntries > 0) {
            Vector<BInTankInventoryEntry> removeEntries = new Vector<BInTankInventoryEntry>();
            for (int i = 0; i < numRemoveEntries; ++i) {
                removeEntries.addElement(sortedValues[i]);
            }
            Enumeration re = removeEntries.elements();
            while (re.hasMoreElements()) {
                BInTankInventoryEntry oldestEntryCopy = (BInTankInventoryEntry)((Object)re.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350InTankInvProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + oldestEntryCopy.createCommaDelimitedString());
                }
                this.getInTankInventoryTable().remove((BComplex)oldestEntryCopy);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, sendToCsMgrCopy));
    }

    private void updateDemuxedProxyPoints() {
        BInTankInventoryEntry[] sortedValues = this.getInTankInventoryTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        BInTankInventoryEntry mostRecentValue = sortedValues[sortedValues.length - 1];
        String[] demuxedValueStrings = CsMgrBaseUtil.createStringArrayOfAllNames((String)mostRecentValue.createCommaDelimitedString());
        if (demuxedValueStrings != null && demuxedValueStrings.length > 0) {
            BControlPoint[] dCPA;
            BTls350ItiDemuxedPointDeviceExt itidExt = null;
            BDeviceExt[] exts = this.getDevice().getDeviceExts();
            for (int k = 0; k < exts.length; ++k) {
                if (!(exts[k] instanceof BTls350ItiDemuxedPointDeviceExt)) continue;
                itidExt = (BTls350ItiDemuxedPointDeviceExt)exts[k];
                break;
            }
            if (itidExt != null && (dCPA = itidExt.getPoints()) != null && dCPA.length > 0) {
                for (int k = 0; k < dCPA.length; ++k) {
                    if (dCPA[k].getProxyExt().getType() != BTls350DemuxedProxyExt.TYPE) continue;
                    ((BTls350DemuxedProxyExt)dCPA[k].getProxyExt()).updateValueFrom(demuxedValueStrings);
                }
            }
        }
    }

    @Override
    public void readDataNow() {
        this.pollForDataNow();
    }

    @Override
    public void clearDataNow() {
        this.getInTankInventoryTable().lease(2);
        BInTankInventoryEntry[] itie = (BInTankInventoryEntry[])this.getInTankInventoryTable().getChildren(BInTankInventoryEntry.class);
        if (itie != null && itie.length > 0) {
            for (int i = 0; i < itie.length; ++i) {
                this.getInTankInventoryTable().remove((BComplex)itie[i]);
            }
        }
    }
}

