/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.tls.enums.BTls250DataTypeEnum;
import com.tridium.tls.point.BTls250IrDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls250PointDeviceExt;
import com.tridium.tls.point.BTls250ProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTls250DemuxedProxyExt
extends BTls250ProxyExt {
    public static final Property msgType = BTls250DemuxedProxyExt.newProperty((int)0, (BValue)BTls250DataTypeEnum.None, null);
    public static final Property dataType = BTls250DemuxedProxyExt.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BTls250DemuxedProxyExt.class);

    public BTls250DataTypeEnum getMsgType() {
        return (BTls250DataTypeEnum)this.get(msgType);
    }

    public void setMsgType(BTls250DataTypeEnum v) {
        this.set(msgType, (BValue)v, null);
    }

    public BDynamicEnum getDataType() {
        return (BDynamicEnum)this.get(dataType);
    }

    public void setDataType(BDynamicEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTls250DemuxedProxyExt() {
    }

    public BTls250DemuxedProxyExt(BTls250DataTypeEnum msgType) {
        this.setMsgType(msgType);
    }

    public BTls250DemuxedProxyExt(BTls250DataTypeEnum msgType, BDynamicEnum dataType) {
        this.setMsgType(msgType);
        this.setDataType(dataType);
    }

    @Override
    public Type getDeviceExtType() {
        BTls250DataTypeEnum msgType = this.getMsgType();
        if (msgType == BTls250DataTypeEnum.Tls250InvRptMsgType) {
            return BTls250IrDemuxedPointDeviceExt.TYPE;
        }
        return BTls250PointDeviceExt.TYPE;
    }

    public void started() throws Exception {
    }

    public void stopped() throws Exception {
    }

    public void updateValueFrom(String[] newValuesSA) {
        if (this.getParentPoint() instanceof BNumericPoint) {
            int myDataTypeOrdinal = this.getDataType().getOrdinal();
            int mySAIndex = myDataTypeOrdinal++;
            String myValueString = "";
            try {
                if (mySAIndex < newValuesSA.length) {
                    myValueString = newValuesSA[mySAIndex];
                    double myValue = Double.parseDouble(myValueString);
                    BStatusNumeric sv = (BStatusNumeric)this.getReadValue().newCopy();
                    if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + myValue);
                    }
                    sv.setValue(myValue);
                    this.readOk((BStatusValue)sv);
                }
            }
            catch (NumberFormatException nfe) {
                this.getLog().error("BTls250DemuxedProxyExt updateValueFrom nfe=" + nfe);
                this.getLog().error("BTls250DemuxedProxyExt updateValueFrom myValueString=" + myValueString);
            }
            catch (Exception e) {
                this.getLog().error("BTls250DemuxedProxyExt updateValueFrom e=" + e);
                this.getLog().error("BTls250DemuxedProxyExt updateValueFrom myValueString=" + myValueString);
            }
        }
    }
}

