/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350PriAlmHisProxyExt;
import java.util.Vector;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class TlsConsolePriorityAlarmHistoryReportResponse
extends Tls350Response {
    public BAbsTime readTime;
    public PriorityAlarmHistory[] priorityAlarmHistoryEntries = null;
    private BTls350PriAlmHisProxyExt ext;
    private boolean debug;

    public TlsConsolePriorityAlarmHistoryReportResponse() {
    }

    public TlsConsolePriorityAlarmHistoryReportResponse(BTls350PriAlmHisProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public PriorityAlarmHistory[] getPriorityAlarmHistoryEntries() {
        if (this.debug) {
            this.ext.getLog().trace("TlsCPAHResponse :readResponse priorityAlarmHistoryEntries.length=" + this.priorityAlarmHistoryEntries.length);
        }
        return this.priorityAlarmHistoryEntries;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsCPAHResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16 || !this.functionCode.equalsIgnoreCase("111")) {
            this.priorityAlarmHistoryEntries = new PriorityAlarmHistory[0];
            return inStream;
        }
        this.readTime = inStream.readDateTime(true);
        boolean readResponseDone = false;
        Vector<PriorityAlarmHistory> entries = new Vector<PriorityAlarmHistory>();
        while (!readResponseDone) {
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) break;
            inStream.reset();
            if (inStream.available() < 8) break;
            PriorityAlarmHistory nextEntry = new PriorityAlarmHistory();
            nextEntry.setDateTimeRetrieved(this.readTime);
            nextEntry.setAlarmWarningCategory(inStream.readAsciiInt(2));
            nextEntry.setSensorCategory(inStream.readAsciiInt(2));
            nextEntry.setAlarmTypeNumber(inStream.readAsciiInt(2));
            nextEntry.setTankSensorNumber(inStream.readAsciiInt(2));
            nextEntry.setAlarmState(inStream.readAsciiInt(2));
            nextEntry.setDateTimeOccurred(inStream.readDateTime(true));
            if (this.debug) {
                this.ext.getLog().trace("TlsCPAHResponse :readResponse nextEntry=" + nextEntry.getPAHLogString());
            }
            entries.addElement(nextEntry);
        }
        if (entries != null && this.debug) {
            this.ext.getLog().trace("TlsCPAHResponse :readResponse entries.size()=" + entries.size());
        }
        if (entries == null || entries.size() <= 0) {
            this.priorityAlarmHistoryEntries = new PriorityAlarmHistory[0];
        } else {
            this.priorityAlarmHistoryEntries = new PriorityAlarmHistory[entries.size()];
            entries.copyInto(this.priorityAlarmHistoryEntries);
        }
        if (this.priorityAlarmHistoryEntries != null && this.debug) {
            this.ext.getLog().trace("TlsCPAHResponse :readResponse priorityAlarmHistoryEntries.length=" + this.priorityAlarmHistoryEntries.length);
        }
        return inStream;
    }

    public class PriorityAlarmHistory {
        BAbsTime retrievedDateTime;
        int alarmWarningCategory;
        int sensorCategory;
        int alarmTypeNumber;
        int tankSensorNumber;
        int alarmState;
        BAbsTime dateTimeOccurred;

        public void setDateTimeRetrieved(BAbsTime tr) {
            this.retrievedDateTime = tr;
        }

        public void setAlarmWarningCategory(int aw) {
            this.alarmWarningCategory = aw;
        }

        public void setSensorCategory(int sc) {
            this.sensorCategory = sc;
        }

        public void setAlarmTypeNumber(int at) {
            this.alarmTypeNumber = at;
        }

        public void setTankSensorNumber(int ts) {
            this.tankSensorNumber = ts;
        }

        public void setAlarmState(int as) {
            this.alarmState = as;
        }

        public void setDateTimeOccurred(BAbsTime to) {
            this.dateTimeOccurred = to;
        }

        public BAbsTime getDateTimeRetrieved() {
            return this.retrievedDateTime;
        }

        public int getAlarmWarningCategory() {
            return this.alarmWarningCategory;
        }

        public int getSensorCategory() {
            return this.sensorCategory;
        }

        public int getAlarmTypeNumber() {
            return this.alarmTypeNumber;
        }

        public int getTankSensorNumber() {
            return this.tankSensorNumber;
        }

        public int getAlarmState() {
            return this.alarmState;
        }

        public BAbsTime getDateTimeOccurred() {
            return this.dateTimeOccurred;
        }

        public String getPAHLogString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.retrievedDateTime.encodeToString());
            sb.append(", ");
            sb.append(this.alarmWarningCategory);
            sb.append(", ");
            sb.append(this.sensorCategory);
            sb.append(", ");
            sb.append(this.alarmTypeNumber);
            sb.append(", ");
            sb.append(this.tankSensorNumber);
            sb.append(", ");
            sb.append(this.alarmState);
            sb.append(", ");
            sb.append(this.dateTimeOccurred.encodeToString());
            return sb.toString();
        }
    }
}

