/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.messages.TlsOutputStream;
import com.tridium.tls.messages.TlsReceivedMessage;
import java.io.OutputStream;

public class Tls350Message
extends Message
implements TlsMessageConst {
    public String functionCode;
    public int tank;
    public int errorCode = 0;
    public byte[] messageData;

    public Tls350Message() {
    }

    public Tls350Message(String fc, int t) {
        this.functionCode = fc;
        this.tank = t;
    }

    public Tls350Message(String fc) {
        this.functionCode = fc;
        this.tank = 0;
    }

    public void write(OutputStream out) {
        try {
            out.write(this.getByteArray());
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public byte[] getByteArray() {
        TlsOutputStream outStream = new TlsOutputStream();
        outStream.write(1);
        outStream.write(105);
        outStream.writeString(this.functionCode);
        outStream.writeAsciiInt(this.tank, 2);
        outStream.writeCksum();
        return outStream.toByteArray();
    }

    public Message toResponse(ReceivedMessage response) {
        TlsReceivedMessage rm = (TlsReceivedMessage)response;
        byte[] rmBytes = rm.getBytes();
        Tls350Response rsp = new Tls350Response();
        rsp.readResponse(rmBytes);
        return rsp;
    }

    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = new TlsInputStream(message);
        inStream.read();
        this.functionCode = inStream.readString(3);
        this.tank = inStream.readAsciiInt(2);
        this.messageData = new byte[inStream.available() - 1];
        for (int i = 0; i < this.messageData.length; ++i) {
            this.messageData[i] = (byte)(inStream.read() & 0xFF);
        }
        inStream = new TlsInputStream(this.messageData);
        return inStream;
    }

    public void dataToString(StringBuffer sb) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n----msg header ----");
        sb.append("\n functionCode  = " + this.functionCode);
        sb.append("\n tank          = 0x" + Integer.toHexString(this.tank));
        sb.append("\n----msg data ----");
        if (this.messageData != null) {
            for (int i = 0; i < this.messageData.length; ++i) {
                sb.append("\n data[" + i + "]      = " + Integer.toHexString(this.messageData[i] & 0xFF));
            }
        } else {
            sb.append("\n data[]        = none");
        }
        return sb.toString();
    }
}

