/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350LiqSenAlmHisProxyExt;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class Tls350LiqSenAlmHisReportResponse
extends Tls350Response
implements TlsMessageConst {
    public int sensorNumber;
    public BAbsTime readTime;
    public int numAlarms;
    public BAbsTime[] alarmDateTimes;
    public int[] alarmTypes;
    private BTls350LiqSenAlmHisProxyExt ext;
    private boolean debug;

    public Tls350LiqSenAlmHisReportResponse() {
    }

    public Tls350LiqSenAlmHisReportResponse(BTls350LiqSenAlmHisProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public BAbsTime getReadTime() {
        return this.readTime;
    }

    public int getSensorNumber() {
        return this.sensorNumber;
    }

    public int getNumAlarms() {
        return this.numAlarms;
    }

    public BAbsTime[] getAlarmDateTimes() {
        return this.alarmDateTimes;
    }

    public int[] getAlarmTypes() {
        if (this.debug) {
            this.ext.getLog().trace("TlsLiqSenAlmHisResponse :readResponse alarmTypes.length=" + this.alarmTypes.length);
        }
        return this.alarmTypes;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsLiqSenAlmHisResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16 || !this.functionCode.equalsIgnoreCase("302")) {
            this.alarmTypes = new int[0];
            this.sensorNumber = this.tank;
            return inStream;
        }
        this.readTime = inStream.readDateTime(true);
        boolean readResponseDone = false;
        while (!readResponseDone) {
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) {
                this.alarmTypes = new int[0];
                this.sensorNumber = this.tank;
                return inStream;
            }
            inStream.reset();
            if (inStream.available() < 8) {
                this.alarmTypes = new int[0];
                this.sensorNumber = this.tank;
                return inStream;
            }
            if (this.tank <= 0) break;
            this.sensorNumber = inStream.readAsciiInt(2);
            if (this.debug) {
                this.ext.getLog().trace("TlsLiqSenAlmHisResponse :readResponse sensorNumber=" + this.sensorNumber);
            }
            int numAlarms = inStream.readAsciiInt(2);
            if (this.debug) {
                this.ext.getLog().trace("TlsLiqSenAlmHisResponse :readResponse numAlarms=" + numAlarms);
            }
            if (this.ext.device().getUserData().indexOf("db1") != -1) {
                this.alarmTypes = new int[0];
                this.sensorNumber = this.tank;
                return inStream;
            }
            if (numAlarms == 0) {
                this.alarmTypes = new int[0];
                return inStream;
            }
            StringBuffer sb = new StringBuffer();
            if (this.ext.device().getUserData().indexOf("db2") != -1) {
                this.alarmTypes = new int[0];
                this.sensorNumber = this.tank;
                return inStream;
            }
            this.alarmTypes = new int[numAlarms];
            this.alarmDateTimes = new BAbsTime[numAlarms];
            if (this.ext.device().getUserData().indexOf("db3") != -1) {
                this.alarmTypes = new int[0];
                this.sensorNumber = this.tank;
                return inStream;
            }
            for (int i = 0; i < numAlarms; ++i) {
                if (this.ext.device().getUserData().indexOf("db4") != -1) {
                    this.alarmTypes = new int[0];
                    this.sensorNumber = this.tank;
                    return inStream;
                }
                this.alarmDateTimes[i] = inStream.readDateTime(true);
                if (this.ext.device().getUserData().indexOf("db5") != -1) {
                    this.alarmTypes = new int[0];
                    this.sensorNumber = this.tank;
                    return inStream;
                }
                if (this.debug) {
                    this.ext.getLog().trace("TlsLiqSenAlmHisResponse :readResponse alarmDateTimes[" + i + "]=" + this.alarmDateTimes[i]);
                }
                if (this.ext.device().getUserData().indexOf("db6") != -1) {
                    this.alarmTypes = new int[0];
                    this.sensorNumber = this.tank;
                    return inStream;
                }
                this.alarmTypes[i] = inStream.readAsciiInt(4);
                if (this.ext.device().getUserData().indexOf("db7") != -1) {
                    this.alarmTypes = new int[0];
                    this.sensorNumber = this.tank;
                    return inStream;
                }
                if (this.debug) {
                    this.ext.getLog().trace("TlsLiqSenAlmHisResponse :readResponse alarmTypes[" + i + "]=" + this.alarmTypes[i]);
                }
                if (this.ext.device().getUserData().indexOf("db8") != -1) {
                    this.alarmTypes = new int[0];
                    this.sensorNumber = this.tank;
                    return inStream;
                }
                if (i == 0) {
                    sb.append(i + "|" + this.alarmDateTimes[i] + "|" + this.alarmTypes[i]);
                } else {
                    sb.append("," + i + "|" + this.alarmDateTimes[i] + "|" + this.alarmTypes[i]);
                }
                if (this.ext.device().getUserData().indexOf("db9") != -1) {
                    this.alarmTypes = new int[0];
                    this.sensorNumber = this.tank;
                    return inStream;
                }
                if (this.debug) {
                    this.ext.getLog().trace("TlsLiqSenAlmHisResponse :readResponse nextEntry=" + sb.toString());
                }
                if (this.ext.device().getUserData().indexOf("db10") == -1) continue;
                this.alarmTypes = new int[0];
                this.sensorNumber = this.tank;
                return inStream;
            }
            readResponseDone = true;
        }
        return inStream;
    }
}

