/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350InvReconcileReportProxyExt;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class Tls350InvReconcileReportResponse
extends Tls350Response
implements TlsMessageConst {
    private BTls350InvReconcileReportProxyExt ext;
    private boolean debug;
    private boolean debug_negative;
    public BAbsTime readTime;
    private int productNumber;
    private int numberTanks;
    private String tanksString;
    private int numRecDaysToFollow;
    private int numberFieldsToFollowInt;
    public InvReconcileRecordEntry[] invReconcileRecordEntries = null;

    public Tls350InvReconcileReportResponse() {
    }

    public Tls350InvReconcileReportResponse(BTls350InvReconcileReportProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public InvReconcileRecordEntry[] getInvReconcileRecordEntries() {
        if (this.debug) {
            this.ext.getLog().trace("TlsIRRResponse :readResponse invReconcileReportEntries.length=" + this.invReconcileRecordEntries.length);
        }
        return this.invReconcileRecordEntries;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsIRRResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16 || !this.functionCode.equalsIgnoreCase("C05")) {
            this.productNumber = this.tank;
            this.invReconcileRecordEntries = new InvReconcileRecordEntry[0];
            return inStream;
        }
        this.readTime = inStream.readDateTime(true);
        boolean readResponseDone = false;
        while (!readResponseDone) {
            int i;
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) {
                this.productNumber = this.tank;
                this.invReconcileRecordEntries = new InvReconcileRecordEntry[0];
                return inStream;
            }
            inStream.reset();
            if (inStream.available() < 8) {
                this.productNumber = this.tank;
                this.invReconcileRecordEntries = new InvReconcileRecordEntry[0];
                return inStream;
            }
            this.productNumber = inStream.readAsciiInt(2);
            if (this.productNumber == -1) {
                this.invReconcileRecordEntries = new InvReconcileRecordEntry[0];
                return inStream;
            }
            if (this.debug) {
                this.ext.getLog().trace("TlsIRRResponse :readResponse readTime=" + this.readTime + " productNumber=" + this.productNumber);
            }
            this.numberTanks = inStream.readAsciiInt(2);
            if (this.numberTanks < 1) {
                this.productNumber = this.tank;
                this.invReconcileRecordEntries = new InvReconcileRecordEntry[0];
                return inStream;
            }
            int[] tankNumbers = new int[this.numberTanks];
            this.tanksString = new String();
            for (i = 0; i < this.numberTanks; ++i) {
                tankNumbers[i] = inStream.readAsciiInt(2);
                this.tanksString = i == 0 ? this.tanksString + tankNumbers[i] : this.tanksString + "|" + tankNumbers[i];
            }
            if (this.debug) {
                this.ext.getLog().trace("TlsIRRResponse :readResponse numberTanks=" + this.numberTanks + " tanksString=" + this.tanksString);
            }
            this.numRecDaysToFollow = inStream.readAsciiHex(2);
            if (this.debug) {
                this.ext.getLog().trace("TlsIRRResponse :readResponse numRecDaysToFollow=" + this.numRecDaysToFollow);
            }
            if (this.numRecDaysToFollow != 0) {
                this.invReconcileRecordEntries = new InvReconcileRecordEntry[this.numRecDaysToFollow];
                for (i = 0; i < this.numRecDaysToFollow; ++i) {
                    this.invReconcileRecordEntries[i] = new InvReconcileRecordEntry();
                    this.invReconcileRecordEntries[i].setProductNumber(this.productNumber);
                    this.invReconcileRecordEntries[i].setNumberTanks(this.numberTanks);
                    this.invReconcileRecordEntries[i].setTanks(this.tanksString);
                    this.invReconcileRecordEntries[i].setOpenningTime(inStream.readDateTime(true));
                    this.invReconcileRecordEntries[i].setClosingTime(inStream.readDateTime(true));
                    if (this.debug) {
                        this.ext.getLog().trace("TlsIRRResponse :readResponse openningTime=" + this.invReconcileRecordEntries[i].getOpenningTime());
                        this.ext.getLog().trace("TlsIRRResponse :readResponse closingTime=" + this.invReconcileRecordEntries[i].getClosingTime());
                    }
                    this.numberFieldsToFollowInt = inStream.readAsciiHex(2);
                    if (this.debug) {
                        this.ext.getLog().trace("TlsIRRResponse :readResponse numberFieldsToFollowInt=" + this.numberFieldsToFollowInt);
                    }
                    block13: for (int j = 0; j < this.numberFieldsToFollowInt; ++j) {
                        float flTemp = inStream.readAsciiFloat();
                        if (this.debug) {
                            this.ext.getLog().trace("TlsIRRResponse :readResponse j=" + j + " flTemp=" + flTemp);
                        }
                        if (flTemp < 0.0f && this.debug_negative) {
                            System.out.println("ADRR (-) value=" + flTemp + " j=" + j);
                            System.out.println("ADRR - ba=" + ByteArrayUtil.toHexString((byte[])message, (int)0, (int)message.length));
                        }
                        switch (j) {
                            case 0: {
                                this.invReconcileRecordEntries[i].setInvAtPrevClose(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block13;
                            }
                            case 1: {
                                this.invReconcileRecordEntries[i].setSumTotAdjDel(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block13;
                            }
                            case 2: {
                                this.invReconcileRecordEntries[i].setSumTotMeteredSales(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block13;
                            }
                            case 3: {
                                this.invReconcileRecordEntries[i].setManAdjForPer(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block13;
                            }
                            case 4: {
                                this.invReconcileRecordEntries[i].setCalcInvCurPer(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block13;
                            }
                            case 5: {
                                this.invReconcileRecordEntries[i].setProbeMeasInvCurPer(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block13;
                            }
                            case 6: {
                                this.invReconcileRecordEntries[i].setWaterLevCurPer(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block13;
                            }
                            case 7: {
                                this.invReconcileRecordEntries[i].setProbeCalcInvVar(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                            }
                        }
                    }
                    if (!this.debug) continue;
                    this.ext.getLog().trace("TlsIRRResponse :readResponse invReconcileRecordEntries[" + i + "]=" + this.invReconcileRecordEntries[i].getIRRLogString());
                }
            }
            readResponseDone = true;
        }
        return inStream;
    }

    public class InvReconcileRecordEntry {
        int productNumber;
        int numberTanks;
        BAbsTime openningTime;
        BAbsTime closingTime;
        float invAtPrevClose;
        float sumTotAdjDel;
        float sumTotMeteredSales;
        float manAdjForPer;
        float calcInvCurPer;
        float probeMeasInvCurPer;
        float waterLevCurPer;
        float probeCalcInvVar;

        public void setProductNumber(int pn) {
            this.productNumber = pn;
        }

        public void setNumberTanks(int nt) {
            this.numberTanks = nt;
        }

        public void setTanks(String t) {
            Tls350InvReconcileReportResponse.this.tanksString = t;
        }

        public void setOpenningTime(BAbsTime ot) {
            this.openningTime = ot;
        }

        public void setClosingTime(BAbsTime ct) {
            this.closingTime = ct;
        }

        public void setInvAtPrevClose(float iapc) {
            this.invAtPrevClose = iapc;
        }

        public void setSumTotAdjDel(float stad) {
            this.sumTotAdjDel = stad;
        }

        public void setSumTotMeteredSales(float stms) {
            this.sumTotMeteredSales = stms;
        }

        public void setManAdjForPer(float mafp) {
            this.manAdjForPer = mafp;
        }

        public void setCalcInvCurPer(float cicp) {
            this.calcInvCurPer = cicp;
        }

        public void setProbeMeasInvCurPer(float pmicp) {
            this.probeMeasInvCurPer = pmicp;
        }

        public void setWaterLevCurPer(float wlcp) {
            this.waterLevCurPer = wlcp;
        }

        public void setProbeCalcInvVar(float pciv) {
            this.probeCalcInvVar = pciv;
        }

        public int getProductNumber() {
            return this.productNumber;
        }

        public int getNumberTanks() {
            return this.numberTanks;
        }

        public String getTanks() {
            return Tls350InvReconcileReportResponse.this.tanksString;
        }

        public BAbsTime getOpenningTime() {
            return this.openningTime;
        }

        public BAbsTime getClosingTime() {
            return this.closingTime;
        }

        public float getInvAtPrevClose() {
            return this.invAtPrevClose;
        }

        public float getSumTotAdjDel() {
            return this.sumTotAdjDel;
        }

        public float getSumTotMeteredSales() {
            return this.sumTotMeteredSales;
        }

        public float getManAdjForPer() {
            return this.manAdjForPer;
        }

        public float getCalcInvCurPer() {
            return this.calcInvCurPer;
        }

        public float getProbeMeasInvCurPer() {
            return this.probeMeasInvCurPer;
        }

        public float getWaterLevCurPer() {
            return this.waterLevCurPer;
        }

        public float getProbeCalcInvVar() {
            return this.probeCalcInvVar;
        }

        public String getIRRLogString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.productNumber);
            sb.append(", ");
            sb.append(Tls350InvReconcileReportResponse.this.tanksString);
            sb.append(", ");
            sb.append(this.openningTime.encodeToString());
            sb.append(", ");
            sb.append(this.closingTime.encodeToString());
            sb.append(", ");
            sb.append(this.invAtPrevClose);
            sb.append(", ");
            sb.append(this.sumTotAdjDel);
            sb.append(", ");
            sb.append(this.sumTotMeteredSales);
            sb.append(", ");
            sb.append(this.manAdjForPer);
            sb.append(", ");
            sb.append(this.calcInvCurPer);
            sb.append(", ");
            sb.append(this.probeMeasInvCurPer);
            sb.append(", ");
            sb.append(this.waterLevCurPer);
            sb.append(", ");
            sb.append(this.probeCalcInvVar);
            return sb.toString();
        }
    }
}

