/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350BirAdjDelProxyExt;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class Tls350BirAdjustedDeliveryReportResponse
extends Tls350Response {
    public BAbsTime readTime;
    private int tankNumber;
    private int numberDeliveryEntries;
    private int numberFieldsToFollowInt;
    public BirAdjustedDelivery[] adjustedDeliveryEntries = null;
    private BTls350BirAdjDelProxyExt ext;
    private boolean debug;
    private boolean debug_negative;

    public Tls350BirAdjustedDeliveryReportResponse() {
    }

    public Tls350BirAdjustedDeliveryReportResponse(BTls350BirAdjDelProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
        this.debug_negative = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("negv") != -1;
    }

    public BirAdjustedDelivery[] getBirAdjustedDeliveryEntries() {
        if (this.debug) {
            this.ext.getLog().trace("TlsBADResponse :readResponse adjustedDeliveryEntries.length=" + this.adjustedDeliveryEntries.length);
        }
        return this.adjustedDeliveryEntries;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsBADResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16 || !this.functionCode.equalsIgnoreCase("20B")) {
            this.tankNumber = this.tank;
            return inStream;
        }
        this.readTime = inStream.readDateTime(true);
        boolean readResponseDone = false;
        while (!readResponseDone) {
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) {
                this.adjustedDeliveryEntries = new BirAdjustedDelivery[0];
                this.tankNumber = this.tank;
                return inStream;
            }
            inStream.reset();
            if (inStream.available() < 8) {
                this.adjustedDeliveryEntries = new BirAdjustedDelivery[0];
                this.tankNumber = this.tank;
                return inStream;
            }
            this.tankNumber = inStream.readAsciiInt(2);
            if (this.tankNumber == -1) {
                this.adjustedDeliveryEntries = new BirAdjustedDelivery[0];
                return inStream;
            }
            this.numberDeliveryEntries = inStream.readAsciiInt(2);
            if (this.numberDeliveryEntries != 0) {
                this.adjustedDeliveryEntries = new BirAdjustedDelivery[this.numberDeliveryEntries];
                for (int i = 0; i < this.numberDeliveryEntries; ++i) {
                    this.adjustedDeliveryEntries[i] = new BirAdjustedDelivery();
                    this.adjustedDeliveryEntries[i].setTankNumber(this.tankNumber);
                    this.adjustedDeliveryEntries[i].setDeliveryStartDateTime(inStream.readDateTime(true));
                    this.adjustedDeliveryEntries[i].setDeliveryEndDateTime(inStream.readDateTime(true));
                    String numberFieldsToFollowIntStr = inStream.readString(2);
                    try {
                        this.numberFieldsToFollowInt = Integer.parseInt(numberFieldsToFollowIntStr, 16);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("AdjustedDeliveryReportResponse could not convert numberFieldsToFollowIntStr from str-hex-int... numberFieldsToFollowIntStr=" + numberFieldsToFollowIntStr);
                        return inStream;
                    }
                    block27: for (int j = 0; j < 21 && j != this.numberFieldsToFollowInt; ++j) {
                        float flTemp = inStream.readAsciiFloat();
                        if (flTemp < 0.0f && this.debug_negative) {
                            System.out.println("ADRR (-) value=" + flTemp + " j=" + j);
                            System.out.println("ADRR - ba=" + ByteArrayUtil.toHexString((byte[])message, (int)0, (int)message.length));
                        }
                        switch (j) {
                            case 0: {
                                this.adjustedDeliveryEntries[i].setStartVolume(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 1: {
                                this.adjustedDeliveryEntries[i].setEndVolume(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 2: {
                                this.adjustedDeliveryEntries[i].setAdjustedDelivery(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 3: {
                                this.adjustedDeliveryEntries[i].setAdjustedTcDelivery(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 4: {
                                this.adjustedDeliveryEntries[i].setStartFuelHeight(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 5: {
                                this.adjustedDeliveryEntries[i].setStartFuelTemp1(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 6: {
                                this.adjustedDeliveryEntries[i].setStartFuelTemp2(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 7: {
                                this.adjustedDeliveryEntries[i].setStartFuelTemp3(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 8: {
                                this.adjustedDeliveryEntries[i].setStartFuelTemp4(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 9: {
                                this.adjustedDeliveryEntries[i].setStartFuelTemp5(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 10: {
                                this.adjustedDeliveryEntries[i].setStartFuelTemp6(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 11: {
                                this.adjustedDeliveryEntries[i].setEndFuelHeight(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 12: {
                                this.adjustedDeliveryEntries[i].setEndFuelTemp1(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 13: {
                                this.adjustedDeliveryEntries[i].setEndFuelTemp2(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 14: {
                                this.adjustedDeliveryEntries[i].setEndFuelTemp3(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 15: {
                                this.adjustedDeliveryEntries[i].setEndFuelTemp4(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 16: {
                                this.adjustedDeliveryEntries[i].setEndFuelTemp5(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 17: {
                                this.adjustedDeliveryEntries[i].setEndFuelTemp6(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 18: {
                                this.adjustedDeliveryEntries[i].setTotDispensedDurDel(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 19: {
                                this.adjustedDeliveryEntries[i].setStartFuelTempAvg(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                                continue block27;
                            }
                            case 20: {
                                this.adjustedDeliveryEntries[i].setEndFuelTempAvg(j < this.numberFieldsToFollowInt ? flTemp : Float.NaN);
                            }
                        }
                    }
                    if (!this.debug) continue;
                    this.ext.getLog().trace("TlsBADResponse :readResponse adjustedDeliveryEntries[" + i + "]=" + this.adjustedDeliveryEntries[i].getBADLogString());
                }
            }
            readResponseDone = true;
        }
        return inStream;
    }

    public class BirAdjustedDelivery {
        int tankNumber;
        BAbsTime deliveryStartDateTime;
        BAbsTime deliveryEndDateTime;
        float startVolume;
        float endVolume;
        float adjustedDelVolume;
        float adjustedTcDelVolume;
        float startFuelHeight;
        float startFuelTemp1;
        float startFuelTemp2;
        float startFuelTemp3;
        float startFuelTemp4;
        float startFuelTemp5;
        float startFuelTemp6;
        float endFuelHeight;
        float endFuelTemp1;
        float endFuelTemp2;
        float endFuelTemp3;
        float endFuelTemp4;
        float endFuelTemp5;
        float endFuelTemp6;
        float totDispensedDuringDel;
        float startFuelTempAvg;
        float endFuelTempAvg;

        public void setTankNumber(int tn) {
            this.tankNumber = tn;
        }

        public void setDeliveryStartDateTime(BAbsTime ds) {
            this.deliveryStartDateTime = ds;
        }

        public void setDeliveryEndDateTime(BAbsTime de) {
            this.deliveryEndDateTime = de;
        }

        public void setStartVolume(float sv) {
            this.startVolume = sv;
        }

        public void setEndVolume(float ev) {
            this.endVolume = ev;
        }

        public void setAdjustedDelivery(float ad) {
            this.adjustedDelVolume = ad;
        }

        public void setAdjustedTcDelivery(float td) {
            this.adjustedTcDelVolume = td;
        }

        public void setStartFuelHeight(float fh) {
            this.startFuelHeight = fh;
        }

        public void setStartFuelTemp1(float t1) {
            this.startFuelTemp1 = t1;
        }

        public void setStartFuelTemp2(float t2) {
            this.startFuelTemp2 = t2;
        }

        public void setStartFuelTemp3(float t3) {
            this.startFuelTemp3 = t3;
        }

        public void setStartFuelTemp4(float t4) {
            this.startFuelTemp4 = t4;
        }

        public void setStartFuelTemp5(float t5) {
            this.startFuelTemp5 = t5;
        }

        public void setStartFuelTemp6(float t6) {
            this.startFuelTemp6 = t6;
        }

        public void setEndFuelHeight(float fh) {
            this.endFuelHeight = fh;
        }

        public void setEndFuelTemp1(float t1) {
            this.endFuelTemp1 = t1;
        }

        public void setEndFuelTemp2(float t2) {
            this.endFuelTemp2 = t2;
        }

        public void setEndFuelTemp3(float t3) {
            this.endFuelTemp3 = t3;
        }

        public void setEndFuelTemp4(float t4) {
            this.endFuelTemp4 = t4;
        }

        public void setEndFuelTemp5(float t5) {
            this.endFuelTemp5 = t5;
        }

        public void setEndFuelTemp6(float t6) {
            this.endFuelTemp6 = t6;
        }

        public void setTotDispensedDurDel(float td) {
            this.totDispensedDuringDel = td;
        }

        public void setStartFuelTempAvg(float st) {
            this.startFuelTempAvg = st;
        }

        public void setEndFuelTempAvg(float et) {
            this.endFuelTempAvg = et;
        }

        public int getTankNumber() {
            return this.tankNumber;
        }

        public BAbsTime getDeliveryStartDateTime() {
            return this.deliveryStartDateTime;
        }

        public BAbsTime getDeliveryEndDateTime() {
            return this.deliveryEndDateTime;
        }

        public float getStartVolume() {
            return this.startVolume;
        }

        public float getEndVolume() {
            return this.endVolume;
        }

        public float getAdjustedDelivery() {
            return this.adjustedDelVolume;
        }

        public float getAdjustedTcDelivery() {
            return this.adjustedTcDelVolume;
        }

        public float getStartFuelHeight() {
            return this.startFuelHeight;
        }

        public float getStartFuelTemp1() {
            return this.startFuelTemp1;
        }

        public float getStartFuelTemp2() {
            return this.startFuelTemp2;
        }

        public float getStartFuelTemp3() {
            return this.startFuelTemp3;
        }

        public float getStartFuelTemp4() {
            return this.startFuelTemp4;
        }

        public float getStartFuelTemp5() {
            return this.startFuelTemp5;
        }

        public float getStartFuelTemp6() {
            return this.startFuelTemp6;
        }

        public float getEndFuelHeight() {
            return this.endFuelHeight;
        }

        public float getEndFuelTemp1() {
            return this.endFuelTemp1;
        }

        public float getEndFuelTemp2() {
            return this.endFuelTemp2;
        }

        public float getEndFuelTemp3() {
            return this.endFuelTemp3;
        }

        public float getEndFuelTemp4() {
            return this.endFuelTemp4;
        }

        public float getEndFuelTemp5() {
            return this.endFuelTemp5;
        }

        public float getEndFuelTemp6() {
            return this.endFuelTemp6;
        }

        public float getTotDispensedDurDel() {
            return this.totDispensedDuringDel;
        }

        public float getStartFuelTempAvg() {
            return this.startFuelTempAvg;
        }

        public float getEndFuelTempAvg() {
            return this.endFuelTempAvg;
        }

        public String getBADLogString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.tankNumber);
            sb.append(", ");
            sb.append(this.deliveryStartDateTime.encodeToString());
            sb.append(", ");
            sb.append(this.deliveryEndDateTime.encodeToString());
            sb.append(", ");
            sb.append(this.startVolume);
            sb.append(", ");
            sb.append(this.endVolume);
            sb.append(", ");
            sb.append(this.adjustedDelVolume);
            sb.append(", ");
            sb.append(this.adjustedTcDelVolume);
            sb.append(", ");
            sb.append(this.startFuelHeight);
            sb.append(", ");
            sb.append(this.startFuelTemp1);
            sb.append(", ");
            sb.append(this.startFuelTemp2);
            sb.append(", ");
            sb.append(this.startFuelTemp3);
            sb.append(", ");
            sb.append(this.startFuelTemp4);
            sb.append(", ");
            sb.append(this.startFuelTemp5);
            sb.append(", ");
            sb.append(this.startFuelTemp6);
            sb.append(", ");
            sb.append(this.endFuelHeight);
            sb.append(", ");
            sb.append(this.endFuelTemp1);
            sb.append(", ");
            sb.append(this.endFuelTemp2);
            sb.append(", ");
            sb.append(this.endFuelTemp3);
            sb.append(", ");
            sb.append(this.endFuelTemp4);
            sb.append(", ");
            sb.append(this.endFuelTemp5);
            sb.append(", ");
            sb.append(this.endFuelTemp6);
            sb.append(", ");
            sb.append(this.totDispensedDuringDel);
            sb.append(", ");
            sb.append(this.startFuelTempAvg);
            sb.append(", ");
            sb.append(this.endFuelTempAvg);
            return sb.toString();
        }
    }
}

