/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.Tls250Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.messages.TlsOutputStream;
import com.tridium.tls.messages.TlsReceivedMessage;
import java.io.OutputStream;

public class Tls250Message
extends Message
implements TlsMessageConst {
    public String functionCode;
    public int tank;
    public int errorCode = 0;
    public byte[] messageData;

    public Tls250Message() {
    }

    public Tls250Message(String fc, int t) {
        this.functionCode = fc;
        this.tank = t;
    }

    public void write(OutputStream out) {
        try {
            out.write(this.getByteArray());
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public byte[] getByteArray() {
        TlsOutputStream outStream = new TlsOutputStream();
        outStream.write(1);
        outStream.writeString(this.functionCode);
        outStream.writeAsciiInt(this.tank, 1);
        outStream.writeCksum();
        return outStream.toByteArray();
    }

    public Message toResponse(ReceivedMessage response) {
        TlsReceivedMessage rm = (TlsReceivedMessage)response;
        byte[] rmBytes = rm.getBytes();
        Tls250Response rsp = new Tls250Response();
        rsp.readResponse(rmBytes);
        return rsp;
    }

    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = new TlsInputStream(message);
        inStream.read();
        this.functionCode = inStream.readString(2);
        this.tank = inStream.readAsciiInt(1);
        this.messageData = new byte[inStream.available() - 1];
        for (int i = 0; i < this.messageData.length; ++i) {
            this.messageData[i] = (byte)(inStream.read() & 0xFF);
        }
        inStream = new TlsInputStream(this.messageData);
        return inStream;
    }

    public void dataToString(StringBuffer sb) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n------------------header start-------------------");
        sb.append("\n functionCode  = " + this.functionCode);
        sb.append("\n tank          = 0x" + Integer.toHexString(this.tank));
        if (this.messageData != null) {
            for (int i = 0; i < this.messageData.length; ++i) {
                sb.append("\n data[" + i + "]      = " + Integer.toHexString(this.messageData[i] & 0xFF));
            }
        }
        return sb.toString();
    }
}

