/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.jni.client.da;

import java.util.Vector;

public class OpcItem {
    public String id;
    public String name;
    private Vector<Property> properties;

    public OpcItem() {
    }

    public OpcItem(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public Property getProperty(int pid) {
        Vector<Property> v = this.properties;
        int i = v.size();
        while (--i >= 0) {
            Property p = v.elementAt(i);
            if (p.pid != pid) continue;
            return p;
        }
        return null;
    }

    public Property[] getProperties() {
        if (this.properties == null) {
            return new Property[0];
        }
        Object[] ret = new Property[this.properties.size()];
        this.properties.copyInto(ret);
        return ret;
    }

    public String toString() {
        return '[' + this.name + "] " + this.id;
    }

    private void addProperty(int pid, String desc, int dt) {
        Property p;
        if (this.properties == null) {
            this.properties = new Vector();
        }
        if (!this.properties.contains(p = new Property(pid, desc, dt))) {
            this.properties.addElement(p);
        }
    }

    public static class Property {
        public int pid;
        public String description;
        public int dataType;

        public Property(int pid, String desc, int dt) {
            this.pid = pid;
            this.description = desc != null ? desc : "";
            this.dataType = dt;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Property)) {
                return false;
            }
            Property p = (Property)o;
            return this.pid == p.pid;
        }

        public int hashCode() {
            return this.pid;
        }

        public String toString() {
            return "[" + this.pid + "," + this.dataType + "] " + this.description;
        }
    }
}

