/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.jni;

import com.tridium.opc.OpcEnv;
import com.tridium.opc.OpcException;
import com.tridium.opc.jni.OpcInterface;

public class ComObjectClient {
    protected long peer = 0L;

    public ComObjectClient query(OpcInterface ifc) throws OpcException {
        ComObjectClient o = null;
        try {
            o = ifc.newInstance();
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new OpcException(x.toString());
        }
        o.peer = this.query(this.peer, ifc.iid);
        if (o.peer == 0L) {
            throw new OpcException("Query interface failed: " + ifc);
        }
        return o;
    }

    public void release() throws OpcException {
        if (this.peer != 0L) {
            this.release(this.peer);
        }
        this.peer = 0L;
    }

    protected void doFinalize() throws Throwable {
    }

    protected final void finalize() throws Throwable {
        Exception t = null;
        try {
            OpcEnv.initializeThread();
            this.release();
        }
        catch (Exception x) {
            t = x;
            System.out.println("Failure releasing peer: " + this.peer);
            x.printStackTrace();
        }
        this.doFinalize();
        if (t != null) {
            throw t;
        }
    }

    protected long getPeer() {
        return this.peer;
    }

    private native void release(long var1);

    private native long query(long var1, String var3);
}

