/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.util;

import com.tridium.opc.OpcEnv;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BThreadPoolWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

public class BOpcThreadPool
extends BThreadPoolWorker {
    public static final Type TYPE = Sys.loadType(BOpcThreadPool.class);
    private ThreadPoolWorker worker;
    private CoalesceQueue queue;
    Log opcWriteLog = Log.getLog((String)"OpcDaWriteLog");
    Log opcLog = Log.getLog((String)"OpcDaLog");

    public Type getType() {
        return TYPE;
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new CoalesceQueue();
            this.worker = new MyWorker();
        }
        return this.worker;
    }

    public boolean post(Runnable request) {
        if (this.queue == null) {
            this.opcWriteLog.trace("BOpcThreadPool::post Queue is null so returning without queuing the request: " + request.toString());
            throw new IllegalStateException("Null queue, please report this error.");
        }
        if (!this.isRunning()) {
            return false;
        }
        boolean retVal = this.queue.enqueue((Object)request);
        if (!retVal) {
            System.out.println("BOpcThreadPool::post - Enqueue operation returned false. This means it was coalesced.");
        }
        return retVal;
    }

    public void started() throws Exception {
        super.started();
        this.getWorker().start("Opc Worker");
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.worker != null) {
            this.worker.stop();
        }
    }

    protected String getWorkerThreadName() {
        return "Opc Worker";
    }

    protected void threadStarted() {
        OpcEnv.initializeThread();
    }

    private class MyWorker
    extends ThreadPoolWorker {
        MyWorker() {
            super((Worker.ITodo)BOpcThreadPool.this.queue);
        }

        protected void threadStarted() {
            BOpcThreadPool.this.threadStarted();
        }

        protected void threadStopped() {
        }
    }
}

