/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.point;

import com.tridium.opc.client.BOpcDaClient;
import com.tridium.opc.client.point.BOpcPointDeviceExt;
import com.tridium.opc.client.point.BOpcPointDiscoveryJob;
import com.tridium.opc.client.util.BOpcDataType;
import com.tridium.opc.jni.client.da.BrowseResult;
import com.tridium.opc.jni.client.da.OpcBrowseServerAddressSpace;
import com.tridium.opc.jni.client.da.OpcItemMgt;
import com.tridium.opc.jni.client.da.OpcItemProperties;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOpcPointDiscoveryResult
extends BComponent {
    public static final Property id = BOpcPointDiscoveryResult.newProperty((int)0, (String)"", null);
    public static final Property folder = BOpcPointDiscoveryResult.newProperty((int)0, (boolean)false, null);
    public static final Property dataType = BOpcPointDiscoveryResult.newProperty((int)0, (BValue)BOpcDataType.vtInt4, null);
    public static final Property mode = BOpcPointDiscoveryResult.newProperty((int)0, (BValue)BReadWriteMode.readWrite, null);
    public static final Property facets = BOpcPointDiscoveryResult.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property kidCheck = BOpcPointDiscoveryResult.newProperty((int)0, (boolean)false, null);
    public static final Property actualdataType = BOpcPointDiscoveryResult.newProperty((int)0, (BValue)BOpcDataType.vtInt4, null);
    public static final Action discover = BOpcPointDiscoveryResult.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOpcPointDiscoveryResult.class);
    protected BOpcPointDeviceExt ext;
    Log opcLog = Log.getLog((String)"OpcDaLog");

    public String getId() {
        return this.getString(id);
    }

    public void setId(String v) {
        this.setString(id, v, null);
    }

    public boolean getFolder() {
        return this.getBoolean(folder);
    }

    public void setFolder(boolean v) {
        this.setBoolean(folder, v, null);
    }

    public BOpcDataType getDataType() {
        return (BOpcDataType)this.get(dataType);
    }

    public void setDataType(BOpcDataType v) {
        this.set(dataType, (BValue)v, null);
    }

    public BReadWriteMode getMode() {
        return (BReadWriteMode)this.get(mode);
    }

    public void setMode(BReadWriteMode v) {
        this.set(mode, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public boolean getKidCheck() {
        return this.getBoolean(kidCheck);
    }

    public void setKidCheck(boolean v) {
        this.setBoolean(kidCheck, v, null);
    }

    public BOpcDataType getActualdataType() {
        return (BOpcDataType)this.get(actualdataType);
    }

    public void setActualdataType(BOpcDataType v) {
        this.set(actualdataType, (BValue)v, null);
    }

    public void discover() {
        this.invoke(discover, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doDiscover() {
        this.setKidCheck(true);
        if (this.ext == null) {
            return;
        }
        BOpcDaClient server = this.ext.getDaClient();
        BrowseResult[] res = null;
        try {
            if (server.getState().isDisengaged()) {
                return;
            }
            this.opcLog.trace("Browsing - " + this.getId());
            if (res == null || res.length == 0) {
                try {
                    OpcBrowseServerAddressSpace opc2 = server.getPeer().getBrowseServerAddressSpace();
                    if (opc2 != null) {
                        OpcItemMgt mgt = this.ext.getPeer().getItemMgt();
                        res = opc2.browse(this.getPath(), mgt);
                        opc2.release();
                        mgt.release();
                    }
                }
                catch (Exception x) {
                    this.opcLog.trace("IOPCBrowseServerAddressSpace browse_down failed", (Throwable)x);
                }
            }
            OpcItemProperties props = server.getPeer().getItemProperties();
            int len = 0;
            if (res != null) {
                len = res.length;
            }
            for (int i = 0; i < len; ++i) {
                BOpcPointDiscoveryResult br = new BOpcPointDiscoveryResult();
                br.setFolder(!res[i].isItem());
                br.ext = this.ext;
                if (res[i].isItem()) {
                    if (BOpcDataType.isSupported(res[i].getDataType()) || res[i].getDataType() == 0) {
                        br.setId(res[i].getId());
                        BOpcPointDiscoveryJob.prepare(br, res[i], props);
                        br.setActualdataType(BOpcDataType.make(res[i].getDataType()));
                        this.add(SlotPath.escape((String)res[i].getName()) + "?", (BValue)br);
                        continue;
                    }
                    this.opcLog.message(res[i].getId() + " is an unsupported datatype: " + res[i].getDataType());
                    continue;
                }
                br.setId(res[i].getName());
                this.add(SlotPath.escape((String)res[i].getName()) + "?", (BValue)br);
            }
            props.release();
        }
        catch (Exception x) {
            this.opcLog.message("Discovery failure", (Throwable)x);
        }
    }

    protected String[] getPath() {
        int len = 0;
        BOpcPointDiscoveryResult cur = this;
        while (cur instanceof BOpcPointDiscoveryResult) {
            ++len;
            cur = cur.getParent();
        }
        String[] ret = new String[len];
        cur = this;
        while (--len >= 0) {
            ret[len] = cur.getId();
            cur = cur.getParent();
        }
        return ret;
    }

    protected void setMode(boolean read, boolean write) {
        if (read && write) {
            this.setMode(BReadWriteMode.readWrite);
        } else if (write) {
            this.setMode(BReadWriteMode.writeonly);
        } else {
            this.setMode(BReadWriteMode.readonly);
        }
    }
}

