/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.client.point;

import com.tridium.opc.OpcEnv;
import com.tridium.opc.client.BOpcDaClient;
import com.tridium.opc.client.BOpcDevice;
import com.tridium.opc.client.BOpcNetwork;
import com.tridium.opc.client.point.BOpcPointDiscoveryJob;
import com.tridium.opc.client.point.BOpcPointFolder;
import com.tridium.opc.client.point.BOpcProxyExt;
import com.tridium.opc.client.util.BOpcQuality;
import com.tridium.opc.client.util.BOpcQualityBad;
import com.tridium.opc.client.util.BOpcReadMode;
import com.tridium.opc.client.util.BOpcState;
import com.tridium.opc.client.util.BOpcWriteMode;
import com.tridium.opc.jni.ComObjectClient;
import com.tridium.opc.jni.client.da.OpcAsyncIo2;
import com.tridium.opc.jni.client.da.OpcGroup;
import com.tridium.opc.jni.client.da.OpcItem;
import com.tridium.opc.jni.client.da.OpcItemMgt;
import com.tridium.opc.jni.client.da.OpcItemProperties;
import com.tridium.opc.jni.client.da.OpcSyncIo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BOpcPointDeviceExt
extends BPointDeviceExt {
    public static final Property readDelay = BOpcPointDeviceExt.newProperty((int)0, (BValue)BRelTime.make((long)2000L), null);
    public static final Property writeDelay = BOpcPointDeviceExt.newProperty((int)0, (BValue)BRelTime.make((long)4000L), null);
    public static final Property groupName = BOpcPointDeviceExt.newProperty((int)0, (String)"tridium", null);
    public static final Property percentDeadband = BOpcPointDeviceExt.newProperty((int)0, (double)0.0, null);
    public static final Property updateRate = BOpcPointDeviceExt.newProperty((int)0, (int)1000, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property revisedUpdateRate = BOpcPointDeviceExt.newProperty((int)3, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property batchLimit = BOpcPointDeviceExt.newProperty((int)0, (int)500, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)25.0)));
    public static final Property message = BOpcPointDeviceExt.newProperty((int)67, (String)"", null);
    public static final Property messageTime = BOpcPointDeviceExt.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property serverHandle = BOpcPointDeviceExt.newProperty((int)67, (int)0, null);
    public static final Property state = BOpcPointDeviceExt.newProperty((int)3, (BValue)BOpcState.detached, null);
    public static final Property asyncIo = BOpcPointDeviceExt.newProperty((int)67, (boolean)false, null);
    public static final Property readMode = BOpcPointDeviceExt.newProperty((int)0, (BValue)BOpcReadMode.cov, null);
    public static final Property writeMode = BOpcPointDeviceExt.newProperty((int)0, (BValue)BOpcWriteMode.async, null);
    public static final Property WriteAsACollection = BOpcPointDeviceExt.newProperty((int)5, (boolean)false, null);
    public static final Property defaultPointFacets = BOpcPointDeviceExt.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property readTrigger = BOpcPointDeviceExt.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeSeconds((int)1))), null);
    public static final Property writeTrigger = BOpcPointDeviceExt.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeSeconds((int)1))), null);
    public static final Property flatDiscovery = BOpcPointDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property maxReadWriteWaitTime = BOpcPointDeviceExt.newProperty((int)4, (int)15, null);
    public static final Property useThreadPool = BOpcPointDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property writeState = BOpcPointDeviceExt.newProperty((int)2, (int)0, null);
    public static final Action getDeviceOrd = BOpcPointDeviceExt.newAction((int)4, null);
    public static final Action read = BOpcPointDeviceExt.newAction((int)20, null);
    public static final Action submitPointDiscoveryJob = BOpcPointDeviceExt.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action write = BOpcPointDeviceExt.newAction((int)20, null);
    public static final Action clearWritingFlag = BOpcPointDeviceExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOpcPointDeviceExt.class);
    private BAbsTime attachTime;
    private BOpcDaClient daClient;
    private TreeMap<Object, BOpcProxyExt> extMap;
    private TreeMap<Integer, BOpcProxyExt> extServerHandleMap;
    private Object mutexRead = new Object();
    private Object mutexSubscribe = new Object();
    private Object mutexUnsubscribe = new Object();
    private Object mutexWrite = new Object();
    private Object mutexReadWriteInProgress = new Object();
    private Object mutexAsyncReadMap = new Object();
    private Object mutexAsyncWriteMap = new Object();
    private Object mutexUnregisterCallbackInProgress = new Object();
    private OpcGroup peer = null;
    private TreeMap<Object, BOpcProxyExt> pendingRead = new TreeMap();
    private TreeMap<Object, BOpcProxyExt> pendingSubscribe = new TreeMap();
    private TreeMap<Object, BOpcProxyExt> pendingUnsubscribe = new TreeMap();
    private TreeMap<Object, BOpcProxyExt> pendingWrite = new TreeMap();
    private volatile boolean reading = false;
    private volatile boolean writing = false;
    private long writingTicks = 0L;
    private long readingTicks = 0L;
    private int writingState = 0;
    private long writingBusyCount = 0L;
    private long readingBusyCount = 0L;
    private long writingClearedCount = 0L;
    private long readingClearedCount = 0L;
    private long doWriteCount = 0L;
    private long doReadCount = 0L;
    private boolean waitingWr = false;
    private long lastWriteTime = -1L;
    private long lastTotalWriteTime = -1L;
    private Counter readTxsId = new Counter();
    private Counter writeTxsId = new Counter();
    private TreeMap<Integer, Integer> extAsyncWriteMap = new TreeMap();
    private TreeMap<Integer, Integer> extAsyncReadMap = new TreeMap();
    private boolean isFirstTime = true;
    public static final int WR_WRITING_TRUE = 1;
    public static final int WR_POSTED = 2;
    public static final int WR_DOWRITE_ENTERED = 3;
    public static final int WR_MUTEX_BLOCK = 4;
    public static final int WR_WRITE_ASYNC_CALL = 5;
    public static final int WR_WRITE_ASYNC_RTN = 6;
    public static final int WR_DOWRITE_FINALLY = 7;
    Log opcLog = Log.getLog((String)"OpcDaLog");
    Log opcWriteLog = Log.getLog((String)"OpcDaWriteLog");
    Log opcSubscriptionLog = Log.getLog((String)"OpcDaSubLog");

    public BRelTime getReadDelay() {
        return (BRelTime)this.get(readDelay);
    }

    public void setReadDelay(BRelTime v) {
        this.set(readDelay, (BValue)v, null);
    }

    public BRelTime getWriteDelay() {
        return (BRelTime)this.get(writeDelay);
    }

    public void setWriteDelay(BRelTime v) {
        this.set(writeDelay, (BValue)v, null);
    }

    public String getGroupName() {
        return this.getString(groupName);
    }

    public void setGroupName(String v) {
        this.setString(groupName, v, null);
    }

    public double getPercentDeadband() {
        return this.getDouble(percentDeadband);
    }

    public void setPercentDeadband(double v) {
        this.setDouble(percentDeadband, v, null);
    }

    public int getUpdateRate() {
        return this.getInt(updateRate);
    }

    public void setUpdateRate(int v) {
        this.setInt(updateRate, v, null);
    }

    public int getRevisedUpdateRate() {
        return this.getInt(revisedUpdateRate);
    }

    public void setRevisedUpdateRate(int v) {
        this.setInt(revisedUpdateRate, v, null);
    }

    public int getBatchLimit() {
        return this.getInt(batchLimit);
    }

    public void setBatchLimit(int v) {
        this.setInt(batchLimit, v, null);
    }

    public String getMessage() {
        return this.getString(message);
    }

    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    public BAbsTime getMessageTime() {
        return (BAbsTime)this.get(messageTime);
    }

    public void setMessageTime(BAbsTime v) {
        this.set(messageTime, (BValue)v, null);
    }

    public int getServerHandle() {
        return this.getInt(serverHandle);
    }

    public void setServerHandle(int v) {
        this.setInt(serverHandle, v, null);
    }

    public BOpcState getState() {
        return (BOpcState)this.get(state);
    }

    public void setState(BOpcState v) {
        this.set(state, (BValue)v, null);
    }

    public boolean getAsyncIo() {
        return this.getBoolean(asyncIo);
    }

    public void setAsyncIo(boolean v) {
        this.setBoolean(asyncIo, v, null);
    }

    public BOpcReadMode getReadMode() {
        return (BOpcReadMode)this.get(readMode);
    }

    public void setReadMode(BOpcReadMode v) {
        this.set(readMode, (BValue)v, null);
    }

    public BOpcWriteMode getWriteMode() {
        return (BOpcWriteMode)this.get(writeMode);
    }

    public void setWriteMode(BOpcWriteMode v) {
        this.set(writeMode, (BValue)v, null);
    }

    public boolean getWriteAsACollection() {
        return this.getBoolean(WriteAsACollection);
    }

    public void setWriteAsACollection(boolean v) {
        this.setBoolean(WriteAsACollection, v, null);
    }

    public BFacets getDefaultPointFacets() {
        return (BFacets)this.get(defaultPointFacets);
    }

    public void setDefaultPointFacets(BFacets v) {
        this.set(defaultPointFacets, (BValue)v, null);
    }

    public BTimeTrigger getReadTrigger() {
        return (BTimeTrigger)this.get(readTrigger);
    }

    public void setReadTrigger(BTimeTrigger v) {
        this.set(readTrigger, (BValue)v, null);
    }

    public BTimeTrigger getWriteTrigger() {
        return (BTimeTrigger)this.get(writeTrigger);
    }

    public void setWriteTrigger(BTimeTrigger v) {
        this.set(writeTrigger, (BValue)v, null);
    }

    public boolean getFlatDiscovery() {
        return this.getBoolean(flatDiscovery);
    }

    public void setFlatDiscovery(boolean v) {
        this.setBoolean(flatDiscovery, v, null);
    }

    public int getMaxReadWriteWaitTime() {
        return this.getInt(maxReadWriteWaitTime);
    }

    public void setMaxReadWriteWaitTime(int v) {
        this.setInt(maxReadWriteWaitTime, v, null);
    }

    public boolean getUseThreadPool() {
        return this.getBoolean(useThreadPool);
    }

    public void setUseThreadPool(boolean v) {
        this.setBoolean(useThreadPool, v, null);
    }

    public int getWriteState() {
        return this.getInt(writeState);
    }

    public void setWriteState(int v) {
        this.setInt(writeState, v, null);
    }

    public BOrd getDeviceOrd() {
        return (BOrd)this.invoke(getDeviceOrd, null, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public BOrd submitPointDiscoveryJob(BValue arg) {
        return (BOrd)this.invoke(submitPointDiscoveryJob, arg, null);
    }

    public void write() {
        this.invoke(write, null, null);
    }

    public void clearWritingFlag() {
        this.invoke(clearWritingFlag, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void attach() {
        if (this.getState().isEngaged()) {
            this.opcLog.trace("PointDeviceExt::Attach()--Already attached. Returning");
            return;
        }
        this.setAttaching();
        this.resetFlags();
        this.opcLog.trace("PointDeviceExt::Attach()--Attaching");
        BOpcDaClient server = this.getDaClient();
        if (server == null || !server.getState().isAttached()) {
            this.opcLog.trace("PointDeviceExt::Attach()--Server is not attached. Returning");
            this.setDetached();
            return;
        }
        String addName = this.getGroupName();
        this.peer = server.getPeer().getGroup(addName);
        if (this.peer == null) {
            this.opcLog.trace("Add group");
            try {
                this.peer = server.getPeer().addGroup(addName, true, this.getUpdateRate(), this.getHandle().hashCode(), 0, (float)this.getPercentDeadband(), 0);
                if (this.peer != null) {
                    this.setRevisedUpdateRate(this.peer.revisedUpdateRate);
                    this.setServerHandle(this.peer.serverHandle);
                    this.setAttached();
                    this.opcLog.trace("PointDeviceExt::Attach()--Attached successfully");
                    this.isFirstTime = true;
                    this.attachTime = Clock.time();
                    BTuningPolicyMap objTuningPolicyMap = this.getOpcNetwork().getTuningPolicies();
                    BTuningPolicy objPolicy = objTuningPolicyMap.getDefaultPolicy();
                    if (!objPolicy.getWriteOnUp()) {
                        BControlPoint[] points = this.getPoints();
                        for (int i = 0; i < points.length; ++i) {
                            BAbstractProxyExt ext = points[i].getProxyExt();
                            if (!(ext instanceof BOpcProxyExt)) continue;
                            ((BOpcProxyExt)ext).writeReset();
                        }
                    }
                } else {
                    this.message("Add group failed - peer is equal to NULL");
                    this.opcLog.error("Add group: " + addName);
                    this.setDetached();
                    return;
                }
                this.peer.setGroupListener(new Listener());
                this.registerCallback();
            }
            catch (Exception x) {
                this.message("Add group failed (" + x.getMessage() + ")");
                this.opcLog.error("Add group: " + addName, (Throwable)x);
                this.setDetached();
                return;
            }
        } else {
            this.message("Group name already in use.");
            this.opcLog.error("Duplicate group name [" + addName + "] " + this.toPathString());
            this.setDetached();
            return;
        }
    }

    public void detach() {
        this.cancelTransaction();
        this.setDetaching();
        BOpcDaClient server = this.getDaClient();
        this.opcLog.trace("Removing group");
        if (this.peer != null && !server.isDown() && !server.isFault()) {
            try {
                this.peer.setGroupListener(null);
                server.getPeer().removeGroup(this.peer);
                this.opcLog.trace("PointDeviceExt::detach()--Removed group");
                this.setAsyncIo(false);
            }
            catch (Exception x) {
                this.opcLog.error("Removing group", (Throwable)x);
                this.setAsyncIo(false);
            }
            finally {
                this.setDetached();
                this.setServerHandle(0);
                this.isFirstTime = false;
                this.peer = null;
            }
        }
        this.setDetached();
        this.opcLog.trace("PointDeviceExt::detach()--Detached");
    }

    public void doRead() {
        try {
            ++this.doReadCount;
            if (!this.isRunning()) {
                this.opcLog.trace("PointDeviceExt::doRead()-Not running. Returning");
                return;
            }
            if (!this.getState().isAttached()) {
                this.opcLog.trace("PointDeviceExt::doRead()-Not attached. Returning");
                return;
            }
            if (this.peer == null) {
                this.opcLog.trace("PointDeviceExt::doRead()-Peer is null. Returning");
                return;
            }
            if (Clock.time().isBefore(this.attachTime.add(this.getReadDelay()))) {
                this.opcLog.trace("PointDeviceExt::doRead()-Poll time is less than read delay. Returning");
                return;
            }
            this.checkReadWriteMode();
            this.performUnsubscribe();
            this.performSubscribe();
            if (this.getReadMode() != BOpcReadMode.cov) {
                this.performRead();
            }
        }
        finally {
            this.reading = false;
        }
    }

    public final BOrd doGetDeviceOrd() {
        return this.getOpcDevice().getSlotPathOrd();
    }

    public final BOrd doSubmitPointDiscoveryJob(BValue args, Context cx) {
        return new BOpcPointDiscoveryJob(this, (BValue)BString.make((String)"")).submit(cx);
    }

    public void doClearWritingFlag() {
        if (this.writing) {
            this.opcWriteLog.message("doClearWritingFlag(): writing flag is set and will be reset.");
            this.writing = false;
        } else {
            this.opcWriteLog.message("doClearWritingFlag(): writing flag is not set.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWrite() {
        block73: {
            long writeStart = Clock.ticks();
            this.writingState = 3;
            this.setWriteState(this.writingState);
            ++this.doWriteCount;
            ComObjectClient AsyncIo2 = null;
            ComObjectClient syncIo = null;
            int len = 0;
            int count = 0;
            int hresult = 0;
            try {
                Iterator<BOpcProxyExt> it;
                if (!this.isRunning()) {
                    this.opcWriteLog.trace("OpcWrTrace: PointDeviceExt::doWrite()-Not running. Returning");
                    return;
                }
                if (!this.getState().isAttached()) {
                    this.opcWriteLog.trace("OpcWrTrace: PointDeviceExt::doWrite()-Not attached. Returning");
                    return;
                }
                if (Clock.time().isBefore(this.attachTime.add(this.getWriteDelay()))) {
                    this.opcWriteLog.trace("OpcWrTrace: PointDeviceExt::doWrite()-Write time is less than write delay. Returning");
                    return;
                }
                this.opcWriteLog.trace("OpcWrTrace: PointDeviceExt::doWrite()-before checkReadWriteMode.");
                this.checkReadWriteMode();
                Collection<BOpcProxyExt> tmp = null;
                tmp = this.pendingWrite.values();
                this.opcWriteLog.trace("OpcWrTrace: PointDeviceExt::doWrite()-going to acquire mutexWrite lock.");
                Object object = this.mutexWrite;
                synchronized (object) {
                    block72: {
                        this.opcWriteLog.trace("OpcWrTrace: PointDeviceExt::doWrite()-acquired mutexWrite lock.");
                        if (tmp.size() != 0) break block72;
                        return;
                    }
                    this.pendingWrite = new TreeMap();
                }
                this.opcWriteLog.trace("OpcWrTrace: PointDeviceExt::doWrite()-going to acquire mutexReadWriteInProgress lock.");
                object = this.mutexReadWriteInProgress;
                synchronized (object) {
                    this.opcWriteLog.trace("OpcWrTrace: PointDeviceExt::doWrite()-acquired mutexReadWriteInProgress lock.");
                    ArrayList<BOpcProxyExt> tmp2 = new ArrayList<BOpcProxyExt>();
                    it = tmp.iterator();
                    len = tmp.size();
                    for (int i = 0; i < len; ++i) {
                        BOpcProxyExt ext = it.next();
                        if (ext.getIsAddRemoveInProgress()) {
                            Object object2 = this.mutexWrite;
                            synchronized (object2) {
                                this.pendingWrite.put(ext.getHandle(), ext);
                            }
                        } else {
                            ext.setIsWriteInProgress(true);
                            tmp2.add(ext);
                        }
                        it.remove();
                    }
                    tmp = tmp2;
                }
                len = tmp.size();
                this.opcWriteLog.trace("Write List Size::" + this.pendingWrite.size() + " Items actually getting written =" + len);
                if (len <= 0) {
                    return;
                }
                this.opcWriteLog.trace("Writing " + tmp.size() + " items");
                try {
                    if (this.getAsyncIo()) {
                        AsyncIo2 = this.peer.getAsyncIo();
                        syncIo = this.peer.getSyncIo();
                    } else {
                        syncIo = this.peer.getSyncIo();
                    }
                }
                catch (Exception x) {
                    String msg = x.getMessage();
                    this.message("Write failed: " + msg);
                    this.opcWriteLog.error("Write", (Throwable)x);
                    it = tmp.iterator();
                    this.opcWriteLog.trace("PointDeviceExt::doWrite()-SyncIo/AsyncIo interface is not valid. Setting all points to write failed");
                    while (it.hasNext()) {
                        it.next().writeFail(msg);
                    }
                    this.writingState = 7;
                    this.setWriteState(this.writingState);
                    this.writing = false;
                    if (syncIo != null) {
                        syncIo.release();
                    }
                    if (AsyncIo2 != null) {
                        AsyncIo2.release();
                    }
                    this.opcWriteLog.trace("PointDeviceExt::doWrite()-Write finally block");
                    this.lastWriteTime = Clock.ticks() - writeStart;
                    this.lastTotalWriteTime = Clock.ticks() - this.writingTicks;
                    return;
                }
                this.opcWriteLog.trace("PointDeviceExt::doWrite()-Sync IO object is valid");
                if (this.getWriteAsACollection()) {
                    BOpcProxyExt[] exts = new BOpcProxyExt[len];
                    int[] handles = new int[len];
                    int[] dataTypes = new int[len];
                    String[] valuesAry = new String[len];
                    String value = null;
                    Iterator<BOpcProxyExt> it2 = tmp.iterator();
                    for (int i = 0; i < len && it2 != null && it2.hasNext(); ++i) {
                        exts[i] = it2.next();
                        if (!exts[i].isValidItem()) {
                            exts[i].setIsWriteInProgress(false);
                            continue;
                        }
                        BStatusValue val = exts[i].getWriteValue();
                        if (val instanceof BStatusNumeric) {
                            if (exts[i].isNumericOutofRange(val)) continue;
                            double d = ((BStatusNumeric)val).getNumeric();
                            value = Double.toString(d);
                        } else if (val instanceof BStatusBoolean) {
                            String str;
                            boolean b = ((BStatusBoolean)val).getValue();
                            value = str = new Boolean(b).toString();
                        } else {
                            if (!exts[i].isValidDataType(val)) continue;
                            if (8203 == exts[i].getOpcActualDataType().getOrdinal() || 8200 == exts[i].getOpcActualDataType().getOrdinal()) {
                                value = exts[i].getStringArrayValue(val);
                            }
                            value = ((BStatusString)val).getValue();
                        }
                        valuesAry[count] = value;
                        handles[count] = exts[i].getServerHandle();
                        dataTypes[count] = exts[i].getOpcDataType().getOrdinal();
                        ++count;
                    }
                    Object i = this.mutexUnregisterCallbackInProgress;
                    synchronized (i) {
                        if (this.getWriteMode() == BOpcWriteMode.async) {
                            if (AsyncIo2 != null) {
                                this.opcWriteLog.trace("Doing Asynchronous Write");
                                this.waitingWr = true;
                                hresult = ((OpcAsyncIo2)AsyncIo2).writeAsync(count, this.writeTxsId.increment(), handles, dataTypes, valuesAry);
                                this.waitingWr = false;
                            } else {
                                it2 = tmp.iterator();
                                while (it2.hasNext()) {
                                    it2.next().writeFail("Write Fail: AsyncIo2 Object is null");
                                }
                            }
                        } else if (syncIo != null) {
                            this.opcWriteLog.trace("Doing Synchronous Write");
                            hresult = ((OpcSyncIo)syncIo).writeArray(count, handles, dataTypes, valuesAry);
                        } else {
                            it2 = tmp.iterator();
                            while (it2.hasNext()) {
                                it2.next().writeFail("Write Fail: SyncIo Object is null");
                            }
                        }
                        break block73;
                    }
                }
                Iterator<BOpcProxyExt> it3 = tmp.iterator();
                for (int i = 0; i < len && it3 != null && it3.hasNext(); ++i) {
                    count = 0;
                    BOpcProxyExt[] exts = new BOpcProxyExt[1];
                    int[] handles = new int[1];
                    int[] dataTypes = new int[1];
                    String[] values = new String[1];
                    exts[count] = it3.next();
                    if (!exts[count].isValidItem()) {
                        exts[count].setIsWriteInProgress(false);
                        continue;
                    }
                    BStatusValue val = exts[count].getWriteValue();
                    if (val instanceof BStatusNumeric) {
                        if (exts[count].isNumericOutofRange(val)) continue;
                        double d = ((BStatusNumeric)val).getNumeric();
                        values[count] = Double.toString(d);
                    } else if (val instanceof BStatusBoolean) {
                        String str;
                        boolean b = ((BStatusBoolean)val).getValue();
                        values[count] = str = new Boolean(b).toString();
                    } else {
                        if (!exts[count].isValidDataType(val)) continue;
                        if (8203 == exts[count].getOpcActualDataType().getOrdinal() || 8200 == exts[count].getOpcActualDataType().getOrdinal()) {
                            values[count] = exts[count].getStringArrayValue(val);
                        }
                        values[count] = ((BStatusString)val).getValue();
                    }
                    handles[count] = exts[count].getServerHandle();
                    dataTypes[count] = exts[count].getOpcDataType().getOrdinal();
                    this.writingState = 4;
                    this.setWriteState(this.writingState);
                    Object object3 = this.mutexUnregisterCallbackInProgress;
                    synchronized (object3) {
                        if (this.getWriteMode() == BOpcWriteMode.async) {
                            if (AsyncIo2 != null) {
                                this.opcWriteLog.trace("Doing Asynchronous Write");
                                this.waitingWr = true;
                                this.writingState = 5;
                                this.setWriteState(this.writingState);
                                hresult = ((OpcAsyncIo2)AsyncIo2).writeAsync(1, this.writeTxsId.increment(), handles, dataTypes, values);
                                this.waitingWr = false;
                                this.writingState = 6;
                                this.setWriteState(this.writingState);
                            } else {
                                it3 = tmp.iterator();
                                while (it3.hasNext()) {
                                    it3.next().writeFail("Write Fail: AsyncIo2 Object is null");
                                }
                            }
                        } else if (syncIo != null) {
                            this.opcWriteLog.trace("Doing Synchronous Write");
                            hresult = ((OpcSyncIo)syncIo).writeArray(1, handles, dataTypes, values);
                        } else {
                            it3 = tmp.iterator();
                            while (it3.hasNext()) {
                                it3.next().writeFail("Write Fail: SyncIo Object is null");
                            }
                        }
                        continue;
                    }
                }
            }
            finally {
                this.writingState = 7;
                this.setWriteState(this.writingState);
                this.writing = false;
                if (syncIo != null) {
                    syncIo.release();
                }
                if (AsyncIo2 != null) {
                    AsyncIo2.release();
                }
                this.opcWriteLog.trace("PointDeviceExt::doWrite()-Write finally block");
                this.lastWriteTime = Clock.ticks() - writeStart;
                this.lastTotalWriteTime = Clock.ticks() - this.writingTicks;
            }
        }
    }

    public final BOpcDaClient getDaClient() {
        if (this.daClient == null) {
            this.daClient = (BOpcDaClient)this.getParent();
        }
        return this.daClient;
    }

    public final Type getDeviceType() {
        return BOpcDevice.TYPE;
    }

    public final BOpcDevice getOpcDevice() {
        return (BOpcDevice)this.getParent();
    }

    public final BOpcNetwork getOpcNetwork() {
        return this.getOpcDevice().getOpcNetwork();
    }

    public final Type getPointFolderType() {
        return BOpcPointFolder.TYPE;
    }

    public final Type getProxyExtType() {
        return BOpcProxyExt.TYPE;
    }

    public final IFuture post(Action a, BValue arg, Context cx) {
        BOpcNetwork nw = this.getOpcNetwork();
        if (a == read) {
            if (this.reading) {
                ++this.readingBusyCount;
                long delta = Clock.ticks() - this.readingTicks;
                if (delta < (long)(this.getMaxReadWriteWaitTime() * 1000)) {
                    this.opcLog.trace("PointDeviceExt::post()-- Action: Read and currently reading: true. Returning without reading.");
                    return null;
                }
                this.opcWriteLog.message("PointDeviceExt::post()-- Action: Write: reading true > MaxReadWriteWaitTime sec. Continue with post.");
                ++this.readingClearedCount;
            }
            this.reading = true;
            this.readingTicks = Clock.ticks();
            if (this.getUseThreadPool()) {
                nw.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
            } else {
                nw.getRdQueue().enqueue((Object)new Invocation((BComponent)this, a, arg, cx));
            }
        } else if (a == write) {
            BValue value;
            if (this.writing) {
                ++this.writingBusyCount;
                long delta = Clock.ticks() - this.writingTicks;
                if (delta < (long)(this.getMaxReadWriteWaitTime() * 1000)) {
                    this.opcLog.trace("PointDeviceExt::post()-- Action: Write and currently writing: true. Returning without writing.");
                    return null;
                }
                this.opcWriteLog.message("PointDeviceExt::post()-- Action: Write: writing true > MaxReadWriteWaitTime sec. Continue with post.");
                ++this.writingClearedCount;
                System.out.println("Writing flag appears to be stuck. WritingState = " + this.writingState + ". Clearing writing flag.");
            }
            this.writing = true;
            this.writingTicks = Clock.ticks();
            this.writingState = 1;
            this.setWriteState(this.writingState);
            if (this.get("test") != null && (value = this.get("test")) instanceof BBoolean && ((BBoolean)value).getBoolean()) {
                return null;
            }
            if (this.getUseThreadPool()) {
                nw.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
            } else {
                nw.getWrQueue().enqueue((Object)new Invocation((BComponent)this, a, arg, cx));
            }
            this.writingState = 2;
            this.setWriteState(this.writingState);
        } else {
            System.out.println("unexspected action: " + a.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(BOpcProxyExt ext) {
        Object object = this.mutexRead;
        synchronized (object) {
            this.pendingRead.put(ext.getId(), ext);
        }
    }

    public void started() throws Exception {
        this.reading = false;
        this.writing = false;
        BTimeTrigger t = this.getReadTrigger();
        this.linkTo("readLink", (BComponent)t, (Slot)BTimeTrigger.fireTrigger, (Slot)read);
        t = this.getWriteTrigger();
        this.linkTo("writeLink", (BComponent)t, (Slot)BTimeTrigger.fireTrigger, (Slot)write);
        super.started();
    }

    public void stopped() throws Exception {
        try {
            Property p = this.getProperty("readLink");
            if (p != null) {
                this.remove(p, null);
            }
            if ((p = this.getProperty("writeLink")) != null) {
                this.opcWriteLog.trace("OpcPointDeviceExt::Stopped, Write Link stopped...");
                this.remove(p, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(BOpcProxyExt ext, Context cx) {
        this.opcSubscriptionLog.trace("PointDeviceExt::Subscribe() called for point:: " + ext.getId());
        Object object = this.mutexSubscribe;
        synchronized (object) {
            this.pendingSubscribe.put(ext.getHandle(), ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(BOpcProxyExt ext, Context cx) {
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            this.pendingUnsubscribe.put(ext.getHandle(), ext);
            this.opcSubscriptionLog.trace("PointDeviceExt::unSubscribe() called-for point::" + ext.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(BOpcProxyExt ext, Context cx) {
        this.opcWriteLog.trace("BOpcPointDeviceExt.write Entered with point::" + ext.getId());
        Object object = this.mutexWrite;
        synchronized (object) {
            this.pendingWrite.put(ext.getHandle(), ext);
            this.opcWriteLog.trace("BOpcPointDeviceExt.write put point in pending write::" + ext.getId());
        }
        this.opcWriteLog.trace("BOpcPointDeviceExt.write Exited with point::" + ext.getId());
    }

    public void cancelTransaction() {
        int i = 0;
        Integer temp = null;
        int[] readCancelIds = null;
        int[] writeCancelIds = null;
        OpcAsyncIo2 AsyncIo2 = null;
        try {
            AsyncIo2 = this.peer.getAsyncIo();
        }
        catch (Exception x) {
            String msg = x.getMessage();
            this.message("Cancel failed: " + msg);
            this.opcLog.error("Cancel", (Throwable)x);
            return;
        }
        if (this.extAsyncReadMap != null && this.extAsyncReadMap.size() > 0) {
            readCancelIds = new int[this.extAsyncReadMap.size()];
            for (Map.Entry<Integer, Integer> entry : this.extAsyncReadMap.entrySet()) {
                temp = entry.getValue();
                readCancelIds[i] = temp;
                ++i;
            }
        }
        if (this.extAsyncWriteMap != null && this.extAsyncWriteMap.size() > 0) {
            writeCancelIds = new int[this.extAsyncWriteMap.size()];
            Iterator<Map.Entry<Integer, Integer>> entries = this.extAsyncWriteMap.entrySet().iterator();
            i = 0;
            while (entries.hasNext()) {
                Map.Entry<Integer, Integer> entry;
                entry = entries.next();
                temp = entry.getValue();
                writeCancelIds[i] = temp;
                ++i;
            }
        }
        AsyncIo2.cancel2(readCancelIds, writeCancelIds);
    }

    protected synchronized void add(BOpcProxyExt ext) {
        if (this.extMap == null) {
            this.extMap = new TreeMap(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    int i2;
                    int i1 = o1.hashCode();
                    if (i1 > (i2 = o2.hashCode())) {
                        return -1;
                    }
                    if (i1 < i2) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        this.extMap.put(ext.getHandle(), ext);
    }

    protected OpcGroup getPeer() {
        return this.peer;
    }

    protected synchronized void remove(BOpcProxyExt ext) {
        this.extMap.remove(ext.getHandle());
    }

    protected synchronized void addToServerHandleMap(BOpcProxyExt ext) {
        if (this.extServerHandleMap == null) {
            this.extServerHandleMap = new TreeMap(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    int i2;
                    int i1 = o1.hashCode();
                    if (i1 > (i2 = o2.hashCode())) {
                        return -1;
                    }
                    if (i1 < i2) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        this.extServerHandleMap.put(new Integer(ext.getServerHandle()), ext);
    }

    protected synchronized void removeFromServerHandleMap(int handle) {
        if (this.extServerHandleMap != null) {
            this.extServerHandleMap.remove(new Integer(handle));
        }
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(prop, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkReadWriteMode() {
        if (this.getReadMode() == BOpcReadMode.sync && this.getWriteMode() == BOpcWriteMode.sync) {
            if (this.getAsyncIo()) {
                try {
                    this.opcLog.trace("PointDeviceExt::Unregistering async callback");
                    this.isFirstTime = true;
                    Object object = this.mutexUnregisterCallbackInProgress;
                    synchronized (object) {
                        this.cancelTransaction();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.peer.unregisterAsyncCallback();
                        this.resetFlags();
                        this.setAsyncIo(false);
                    }
                }
                catch (Exception x) {
                    if (this.isFirstTime) {
                        this.opcLog.warning("Unregistering async callback: " + this.toPathString(), (Throwable)x);
                        this.isFirstTime = false;
                    }
                }
            }
        } else if (!this.getAsyncIo()) {
            try {
                this.opcLog.trace("PointDeviceExt::Registering async callback");
                this.peer.registerAsyncCallback();
                this.setAsyncIo(true);
                this.isFirstTime = true;
            }
            catch (Exception x) {
                if (this.isFirstTime) {
                    this.opcLog.warning("Registering async callback: " + this.toPathString(), (Throwable)x);
                    this.isFirstTime = false;
                }
                this.setReadMode(BOpcReadMode.sync);
                this.setWriteMode(BOpcWriteMode.sync);
                this.setAsyncIo(false);
            }
        }
    }

    private void registerCallback() {
        try {
            this.opcLog.trace("PointDeviceExt::Registering async callback from attach");
            this.peer.registerAsyncCallback();
            this.setAsyncIo(true);
        }
        catch (Exception x) {
            this.opcLog.trace("Registering async callback: " + this.toPathString(), (Throwable)x);
            this.setReadMode(BOpcReadMode.sync);
            this.setWriteMode(BOpcWriteMode.sync);
            this.setAsyncIo(false);
        }
    }

    private BOpcProxyExt getProxyExtFromClientHandle(int clientHandle) {
        if (this.extMap == null) {
            return null;
        }
        return this.extMap.get(new Integer(clientHandle));
    }

    private BOpcProxyExt getProxyExtFromServerHandle(int serverHandle) {
        if (this.extServerHandleMap == null) {
            return null;
        }
        if (this.extServerHandleMap.isEmpty()) {
            return null;
        }
        return this.extServerHandleMap.get(new Integer(serverHandle));
    }

    private void message(String msg) {
        this.setMessage(msg);
        this.setMessageTime(Clock.time());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRead() {
        Collection<BOpcProxyExt> tmp = null;
        int len = 0;
        Object object = this.mutexRead;
        synchronized (object) {
            len = this.pendingRead.size();
            if (len > this.getBatchLimit()) {
                Iterator<BOpcProxyExt> it = this.pendingRead.values().iterator();
                tmp = new ArrayList<BOpcProxyExt>(this.getBatchLimit());
                int i = this.getBatchLimit();
                while (--i >= 0) {
                    tmp.add(it.next());
                    it.remove();
                }
            } else if (len > 0) {
                tmp = this.pendingRead.values();
                this.pendingRead = new TreeMap();
            } else {
                return;
            }
        }
        object = this.mutexReadWriteInProgress;
        synchronized (object) {
            ArrayList<BOpcProxyExt> tmp2 = new ArrayList<BOpcProxyExt>();
            Iterator<BOpcProxyExt> it = tmp.iterator();
            len = tmp.size();
            for (int i = 0; i < len; ++i) {
                BOpcProxyExt ext = it.next();
                if (ext.getIsAddRemoveInProgress()) {
                    Object object2 = this.mutexRead;
                    synchronized (object2) {
                        this.pendingRead.put(ext.getHandle(), ext);
                    }
                } else {
                    ext.setIsReadInProgress(true);
                    tmp2.add(ext);
                }
                it.remove();
            }
            tmp = tmp2;
        }
        len = tmp.size();
        this.opcLog.trace("Read List Size::" + this.pendingRead.size() + " Items currently getting read =" + len);
        if (tmp != null) {
            this.opcLog.trace("Reading " + len + " items");
            Iterator<BOpcProxyExt> it = tmp.iterator();
            int count = 0;
            int[] handles = new int[len];
            for (int i = 0; i < len; ++i) {
                BOpcProxyExt ext = it.next();
                if (ext.getServerHandle() == 0) {
                    this.opcLog.trace("PerformRead:: Server Handle is 0, Returning from Read Operation");
                    ext.setIsReadInProgress(false);
                    continue;
                }
                handles[count] = ext.getServerHandle();
                ++count;
            }
            if (count <= 0) {
                return;
            }
            BOpcDaClient server = this.getDaClient();
            ComObjectClient syncIo = null;
            ComObjectClient asyncIo2 = null;
            try {
                Object object3 = this.mutexUnregisterCallbackInProgress;
                synchronized (object3) {
                    if (BOpcReadMode.async == this.getReadMode()) {
                        this.opcLog.trace("PointDeviceExt::Asynchronous read");
                        asyncIo2 = this.peer.getAsyncIo();
                        if (asyncIo2 != null) {
                            ((OpcAsyncIo2)asyncIo2).readAsync(count, this.readTxsId.increment(), handles);
                        } else {
                            this.opcLog.trace("PointDeviceExt:: AsyncIo object is NULL ");
                            for (BOpcProxyExt ext : tmp) {
                                ext.readFail("Read fail: AsyncIo object is NULL");
                            }
                        }
                    } else {
                        this.opcLog.trace("PointDeviceExt::Synchronous read");
                        syncIo = this.peer.getSyncIo();
                        if (syncIo != null) {
                            ((OpcSyncIo)syncIo).read(handles, true);
                        } else {
                            this.opcLog.trace("PointDeviceExt:: SyncIo object is NULL ");
                            for (BOpcProxyExt ext : tmp) {
                                ext.readFail("Read fail: SyncIo object is NULL");
                            }
                        }
                    }
                }
            }
            catch (Exception x) {
                String msg = "Read fail: " + x.getMessage();
                this.message(msg);
                this.opcLog.error("Read fail", (Throwable)x);
                for (BOpcProxyExt ext : tmp) {
                    ext.readFail(msg);
                }
            }
            finally {
                if (syncIo != null) {
                    syncIo.release();
                }
                if (asyncIo2 != null) {
                    asyncIo2.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSubscribe() {
        block26: {
            Collection<BOpcProxyExt> tmp = null;
            int len = 0;
            Object object = this.mutexSubscribe;
            synchronized (object) {
                len = this.pendingSubscribe.size();
                if (len > this.getBatchLimit()) {
                    Iterator<BOpcProxyExt> it = this.pendingSubscribe.values().iterator();
                    tmp = new ArrayList<BOpcProxyExt>(this.getBatchLimit());
                    int i = this.getBatchLimit();
                    while (--i >= 0) {
                        tmp.add(it.next());
                        it.remove();
                    }
                } else if (len > 0) {
                    tmp = this.pendingSubscribe.values();
                    this.pendingSubscribe = new TreeMap();
                } else {
                    return;
                }
            }
            object = this.mutexSubscribe;
            synchronized (object) {
                ArrayList<BOpcProxyExt> tmp2 = new ArrayList<BOpcProxyExt>();
                Iterator<BOpcProxyExt> it = tmp.iterator();
                len = tmp.size();
                for (int i = 0; i < len; ++i) {
                    BOpcProxyExt ext = it.next();
                    if (ext.getIsInUse()) {
                        this.pendingSubscribe.put(ext.getHandle(), ext);
                    } else {
                        ext.setIsAddRemoveInProgress(true);
                        tmp2.add(ext);
                    }
                    it.remove();
                }
                tmp = tmp2;
            }
            len = tmp.size();
            this.opcSubscriptionLog.trace("Subscription List Size::" + this.pendingSubscribe.size() + " Items currently getting added =" + len);
            if (len <= 0) {
                return;
            }
            BOpcProxyExt[] exts = new BOpcProxyExt[len];
            try {
                this.opcLog.trace("Adding " + len + " items");
                String[] ids = new String[len];
                int[] handles = new int[len];
                int[] tempHandles = new int[len];
                boolean[] active = new boolean[len];
                int[] datatypes = new int[len];
                int[] actualdatatypes = new int[len];
                Iterator<BOpcProxyExt> it = tmp.iterator();
                int i = len;
                while (--i >= 0) {
                    exts[i] = it.next();
                    ids[i] = exts[i].getId();
                    handles[i] = exts[i].getHandle().hashCode();
                    active[i] = true;
                    datatypes[i] = exts[i].getOpcDataType().getOrdinal();
                    actualdatatypes[i] = exts[i].getOpcDataType().getOrdinal();
                }
                OpcItemMgt mgt = this.peer.getItemMgt();
                OpcItemMgt.ItemResult[] res = mgt.addItems(ids, handles, active, datatypes);
                mgt.release();
                if (res != null) {
                    for (int i2 = 0; i2 < len; ++i2) {
                        try {
                            res[i2].actualdataType = res[i2].dataType;
                            exts[i2].addResult(this, res[i2]);
                            this.opcLog.trace("PointDeviceExt::Adding item " + exts[i2].getId() + ", Name::" + exts[i2].getName());
                            if (exts[i2].getItemIDChanged()) {
                                OpcItemProperties props = this.getDaClient().getPeer().getItemProperties();
                                OpcItem ret = new OpcItem(exts[i2].getName(), exts[i2].getId());
                                if (props != null) {
                                    props.queryAvailableProperties(ret);
                                    BFacets facets = BOpcPointDiscoveryJob.setItemPropertiesAsFacets(exts[i2].getParentPoint().getFacets(), exts[i2].getOpcDataType(), ret, props);
                                    exts[i2].getParentPoint().setFacets(facets);
                                    exts[i2].setDeviceFacets(facets);
                                    exts[i2].setItemIDChanged(false);
                                }
                            }
                        }
                        catch (Exception x) {
                            this.opcLog.error("Add item", (Throwable)x);
                            exts[i2].addResult(this, null);
                        }
                        exts[i2] = null;
                    }
                    break block26;
                }
                this.opcLog.error("Perform Subscribe:: Add items, results array is null");
                for (int i3 = 0; i3 < len; ++i3) {
                    if (exts[i3] == null) continue;
                    exts[i3].addResult(this, null);
                }
            }
            catch (Exception x) {
                this.opcLog.error("Add items", (Throwable)x);
                for (int i = 0; i < len; ++i) {
                    if (exts[i] == null) continue;
                    exts[i].addResult(this, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUnsubscribe() {
        BOpcProxyExt ext;
        int i;
        Collection<BOpcProxyExt> tmp = null;
        int len = 0;
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            len = this.pendingUnsubscribe.size();
            if (len > this.getBatchLimit()) {
                Iterator<BOpcProxyExt> it = this.pendingUnsubscribe.values().iterator();
                tmp = new ArrayList<BOpcProxyExt>(this.getBatchLimit());
                int i2 = this.getBatchLimit();
                while (--i2 >= 0) {
                    tmp.add(it.next());
                    it.remove();
                }
            } else if (len > 0) {
                tmp = this.pendingUnsubscribe.values();
                this.pendingUnsubscribe = new TreeMap();
            } else {
                return;
            }
        }
        object = this.mutexReadWriteInProgress;
        synchronized (object) {
            ArrayList<BOpcProxyExt> tmp2 = new ArrayList<BOpcProxyExt>();
            Iterator<BOpcProxyExt> it = tmp.iterator();
            len = tmp.size();
            for (i = 0; i < len; ++i) {
                ext = it.next();
                if (ext.getIsInUse()) {
                    this.opcSubscriptionLog.trace("####Point getting read/write in progress####" + ext.getId() + ", read::" + ext.getIsReadInProgress() + ", write::" + ext.getIsWriteInProgress());
                    Object object2 = this.mutexUnsubscribe;
                    synchronized (object2) {
                        this.pendingUnsubscribe.put(ext.getHandle(), ext);
                    }
                } else {
                    ext.setIsAddRemoveInProgress(true);
                    tmp2.add(ext);
                }
                it.remove();
            }
            tmp = tmp2;
        }
        len = tmp.size();
        this.opcSubscriptionLog.trace("Unsubscription list size::" + this.pendingUnsubscribe.size() + " Items currently getting removed ::" + len);
        if (len <= 0) {
            return;
        }
        try {
            this.opcWriteLog.trace("Removing " + len + " items");
            int[] handles = new int[len];
            BOpcProxyExt[] exts = new BOpcProxyExt[len];
            Iterator<BOpcProxyExt> it1 = tmp.iterator();
            for (i = 0; i < len; ++i) {
                ext = it1.next();
                handles[i] = ext.getServerHandle();
                exts[i] = ext;
                this.opcWriteLog.trace("PointDeviceExt::Removing item" + ext.getId() + ", Name::" + ext.getName());
            }
            OpcItemMgt mgt = this.peer.getItemMgt();
            int[] results = mgt.removeItems(handles);
            if (results != null) {
                int lenRes = results.length;
                this.opcWriteLog.trace("RemoveItems - HRESULT array follows below");
                for (int i3 = 0; i3 < lenRes; ++i3) {
                    exts[i3].setIsAddRemoveInProgress(false);
                    if (results[i3] != 0) {
                        this.opcWriteLog.trace("Remove Item failed for Handle:: " + handles[i3] + ". Item index ::" + i3 + " in the passed array");
                        try {
                            this.remove(exts[i3]);
                        }
                        catch (NotRunningException notRunningException) {
                            // empty catch block
                        }
                        this.removeFromServerHandleMap(handles[i3]);
                        exts[i3].setServerHandle(0);
                        exts[i3].setOpcQuality(BOpcQuality.bad);
                        exts[i3].setOpcQualitySubcode(BOpcQualityBad.nonSpecific);
                        continue;
                    }
                    try {
                        this.remove(exts[i3]);
                    }
                    catch (NotRunningException notRunningException) {
                        // empty catch block
                    }
                    this.removeFromServerHandleMap(handles[i3]);
                    exts[i3].setServerHandle(0);
                    exts[i3].setOpcQuality(BOpcQuality.bad);
                    exts[i3].setOpcQualitySubcode(BOpcQualityBad.nonSpecific);
                }
            } else {
                for (int k = 0; k < exts.length; ++k) {
                    exts[k].setIsAddRemoveInProgress(false);
                    try {
                        this.remove(exts[k]);
                    }
                    catch (NotRunningException notRunningException) {
                        // empty catch block
                    }
                    this.removeFromServerHandleMap(handles[k]);
                    exts[k].setServerHandle(0);
                    exts[k].setOpcQuality(BOpcQuality.bad);
                    exts[k].setOpcQualitySubcode(BOpcQualityBad.nonSpecific);
                }
            }
            mgt.release();
        }
        catch (Exception x) {
            this.opcWriteLog.message("Remove items", (Throwable)x);
            this.getDaClient().doDetach();
        }
    }

    private void readResult(int handle, BStatusValue val, long timestamp, int quality, int hresult, boolean isSyncRead) {
        BOpcProxyExt ext = null;
        ext = isSyncRead ? this.getProxyExtFromServerHandle(handle) : this.getProxyExtFromClientHandle(handle);
        BOpcDaClient server = this.getDaClient();
        if (ext == null) {
            this.opcLog.trace("Item not found " + this.toPathString() + " client handle : " + handle + " HRESULT " + hresult);
            return;
        }
        if (OpcEnv.failed(hresult)) {
            ext.readFail(OpcEnv.resultString(hresult));
            ext.setIsReadInProgress(false);
            this.opcLog.trace("PointDeviceExt::readResult()-Point::" + ext.getId() + " read failed. HRESULT::" + hresult);
            return;
        }
        ext.readResult(val, timestamp, quality, hresult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReadCompleted(int transId, int hrMasterQty, int hrMaster, int noOfItems, int[] ClientHandles, int[] dataTypes, String[] values, int[] qualities, long[] timeStamps, int[] hresultArray) {
        block14: {
            Object ext = null;
            this.opcLog.trace("PointDeviceExt::onReadCompleted, gets called for item");
            try {
                if (ClientHandles != null) {
                    for (int i = 0; i < noOfItems; ++i) {
                        Object sv;
                        if (1 == dataTypes[i]) {
                            double db = Double.valueOf(values[i].trim());
                            sv = new BStatusNumeric(db);
                        } else if (2 == dataTypes[i]) {
                            boolean bl = false;
                            if (values[i].trim().equalsIgnoreCase("true")) {
                                bl = true;
                            }
                            sv = new BStatusBoolean(bl);
                        } else {
                            sv = 3 == dataTypes[i] ? new BStatusString(values[i].trim()) : null;
                        }
                        if (0 == hrMaster) {
                            this.readResult(ClientHandles[i], (BStatusValue)sv, timeStamps[i], qualities[i], 0, false);
                            continue;
                        }
                        this.readResult(ClientHandles[i], (BStatusValue)sv, timeStamps[i], qualities[i], hresultArray[i], false);
                    }
                } else {
                    this.opcLog.trace("PointDeviceExr::onReadCompleted, clientHandle array is null");
                }
                if (this.extAsyncReadMap.size() <= 0) break block14;
                Object i = this.mutexAsyncReadMap;
                synchronized (i) {
                    this.extAsyncReadMap.remove(new Integer(transId));
                }
            }
            catch (Exception x) {
                this.opcLog.error("onReadCompleted", (Throwable)x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWriteCompleted(int transId, int grpHandle, int hrMaster, int noOfItems, int[] clientHandle, int[] hresultArray) {
        block17: {
            this.opcWriteLog.trace("PointDeviceExt::OnWriteCompleted get called......::" + noOfItems + ", master result ::" + (0 == hrMaster ? "OK" : "NOT OK"));
            BOpcProxyExt ext = null;
            try {
                if (clientHandle != null) {
                    int i;
                    if (0 == hrMaster) {
                        for (i = 0; i < noOfItems; ++i) {
                            ext = this.getProxyExtFromClientHandle(clientHandle[i]);
                            if (ext != null) {
                                ext.updateWriteResult(hresultArray[i]);
                                continue;
                            }
                            this.opcWriteLog.trace("PointDeviceExt::OnWriteCompleted, ClientHandle object is null");
                        }
                    } else if (hresultArray != null) {
                        for (i = 0; i < noOfItems; ++i) {
                            ext = this.getProxyExtFromClientHandle(clientHandle[i]);
                            if (ext != null) {
                                ext.updateWriteResult(hresultArray[i]);
                                continue;
                            }
                            this.opcWriteLog.trace("PointDeviceExt::OnWriteCompleted, ClientHandle object is null");
                        }
                    } else {
                        this.opcWriteLog.trace("PointDeviceExr::OnWriteCompleted, hresultArray array is null");
                        for (i = 0; i < noOfItems; ++i) {
                            ext = this.getProxyExtFromClientHandle(clientHandle[i]);
                            if (ext != null) {
                                ext.updateWriteResult(-2147467259);
                                continue;
                            }
                            this.opcWriteLog.trace("PointDeviceExt::OnWriteCompleted, ClientHandle object is null");
                        }
                    }
                } else {
                    this.opcWriteLog.trace("PointDeviceExr::OnWriteCompleted, clientHandle array is null");
                }
                if (this.extAsyncWriteMap.size() <= 0) break block17;
                Object i = this.mutexAsyncWriteMap;
                synchronized (i) {
                    this.extAsyncWriteMap.remove(new Integer(transId));
                }
            }
            catch (Exception x) {
                this.opcWriteLog.error("OnWriteCompleted", (Throwable)x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReturnReadAsync(int hresult, int noOfItems, int transId, int cancelId, int[] serverHandle, int[] hresultArray) {
        block19: {
            BOpcProxyExt ext = null;
            boolean IsCallbackHappen = false;
            try {
                if (serverHandle != null) {
                    int i;
                    if (0 == hresult) {
                        this.opcLog.trace("PointDeviceExt::onReturnReadAsync, Read Async operation was succeeded will get an Callback");
                        IsCallbackHappen = true;
                    } else if (1 == hresult) {
                        if (hresultArray != null) {
                            for (i = 0; i < noOfItems; ++i) {
                                ext = this.getProxyExtFromServerHandle(serverHandle[i]);
                                if (ext != null) {
                                    if (hresultArray[i] == 0) {
                                        IsCallbackHappen = true;
                                        continue;
                                    }
                                    ext.updateReadResult(hresultArray[i]);
                                    continue;
                                }
                                this.opcLog.trace("PointDeviceExt::onReturnReadAsync, serverHandle object is null");
                            }
                        } else {
                            this.opcLog.trace("PointDeviceExt::onReturnReadAsync, hresultArray is null");
                            for (i = 0; i < noOfItems; ++i) {
                                ext = this.getProxyExtFromServerHandle(serverHandle[i]);
                                if (ext == null) continue;
                                ext.updateReadResult(-2147467259);
                            }
                        }
                    } else {
                        this.opcLog.trace("PointDeviceExt::onReturnReadAsync," + OpcEnv.getDescription(hresult));
                        for (i = 0; i < noOfItems; ++i) {
                            ext = this.getProxyExtFromServerHandle(serverHandle[i]);
                            if (ext != null) {
                                ext.updateReadResult(hresult);
                                continue;
                            }
                            this.opcLog.trace("PointDeviceExt::onReturnReadAsync, serverHandle object is null");
                        }
                    }
                } else {
                    this.opcLog.trace("PointDeviceExt::onReturnReadAsync, incoming array is null");
                }
                if (!IsCallbackHappen || this.extAsyncReadMap == null) break block19;
                Object i = this.mutexAsyncReadMap;
                synchronized (i) {
                    this.extAsyncReadMap.put(new Integer(transId), new Integer(cancelId));
                }
            }
            catch (Exception x) {
                this.opcLog.error("onReturnReadAsync", (Throwable)x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReturnWriteAsync(int hresult, int noOfItems, int transId, int cancelId, int[] serverHandle, int[] hresultArray) {
        block20: {
            BOpcProxyExt ext = null;
            boolean IsCallbackHappen = false;
            try {
                if (serverHandle != null) {
                    int i;
                    if (0 == hresult) {
                        this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, Write Async operation was succeeded");
                        IsCallbackHappen = true;
                    } else if (1 == hresult) {
                        if (hresultArray != null) {
                            for (i = 0; i < noOfItems; ++i) {
                                ext = this.getProxyExtFromServerHandle(serverHandle[i]);
                                if (ext != null) {
                                    if (hresultArray[i] == 0) {
                                        IsCallbackHappen = true;
                                        continue;
                                    }
                                    ext.updateWriteResult(hresultArray[i]);
                                    continue;
                                }
                                this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, serverHandle object is null");
                            }
                        } else {
                            this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, hresultArray is null");
                            for (i = 0; i < noOfItems; ++i) {
                                ext = this.getProxyExtFromServerHandle(serverHandle[i]);
                                if (ext != null) {
                                    ext.updateWriteResult(-2147467259);
                                    continue;
                                }
                                this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, serverHandle object is null");
                            }
                        }
                    } else {
                        this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray," + OpcEnv.getDescription(hresult));
                        for (i = 0; i < noOfItems; ++i) {
                            ext = this.getProxyExtFromServerHandle(serverHandle[i]);
                            if (ext != null) {
                                ext.updateWriteResult(hresult);
                                continue;
                            }
                            this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, serverHandle object is null");
                        }
                    }
                } else {
                    this.opcWriteLog.trace("PointDeviceExt::OnReturnWriteArray, incoming array is null");
                }
                if (!IsCallbackHappen || this.extAsyncWriteMap == null) break block20;
                Object i = this.mutexAsyncWriteMap;
                synchronized (i) {
                    this.extAsyncWriteMap.put(new Integer(transId), new Integer(cancelId));
                }
            }
            catch (Exception x) {
                this.opcWriteLog.error("OnReturnWriteArray", (Throwable)x);
            }
        }
    }

    private void onReturnWriteSync(int hresult, int noOfItems, int[] serverHandle, int[] hresultArray) {
        BOpcProxyExt ext = null;
        try {
            if (serverHandle != null) {
                if (0 == hresult) {
                    for (int i = 0; i < noOfItems; ++i) {
                        ext = this.getProxyExtFromServerHandle(serverHandle[i]);
                        if (ext != null) {
                            ext.updateWriteResult(0);
                            continue;
                        }
                        this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, serverHandle object is null");
                    }
                } else if (1 == hresult) {
                    if (hresultArray != null) {
                        for (int i = 0; i < noOfItems; ++i) {
                            ext = this.getProxyExtFromServerHandle(serverHandle[i]);
                            if (ext != null) {
                                ext.updateWriteResult(hresultArray[i]);
                                continue;
                            }
                            this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, serverHandle object is null");
                        }
                    } else {
                        this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, hresultArray is null");
                    }
                } else {
                    this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync," + OpcEnv.getDescription(hresult));
                    for (int i = 0; i < noOfItems; ++i) {
                        ext = this.getProxyExtFromServerHandle(serverHandle[i]);
                        if (ext != null) {
                            ext.updateWriteResult(hresult);
                            continue;
                        }
                        this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, serverHandle object is null");
                    }
                }
            } else {
                this.opcWriteLog.trace("PointDeviceExt::onReturnWriteSync, incoming array is null");
            }
        }
        catch (Exception x) {
            this.opcWriteLog.error("onReturnWriteSync", (Throwable)x);
        }
    }

    private void setAttached() {
        this.setState(BOpcState.attached);
    }

    private void setAttaching() {
        this.setState(BOpcState.attaching);
    }

    private void setDetached() {
        this.setState(BOpcState.detached);
    }

    private void setDetaching() {
        this.setState(BOpcState.detaching);
    }

    private void resetFlags() {
        BControlPoint[] pts = this.getPoints();
        for (int i = 0; i < pts.length; ++i) {
            if (!(pts[i].getProxyExt() instanceof BOpcProxyExt)) continue;
            ((BOpcProxyExt)pts[i].getProxyExt()).setIsReadInProgress(false);
            ((BOpcProxyExt)pts[i].getProxyExt()).setIsWriteInProgress(false);
            ((BOpcProxyExt)pts[i].getProxyExt()).setIsAddRemoveInProgress(false);
            ((BOpcProxyExt)pts[i].getProxyExt()).writeReset();
        }
    }

    public long getWritingBusyCount() {
        return this.writingBusyCount;
    }

    public long getReadingBusyCount() {
        return this.readingBusyCount;
    }

    public long getWritingTicks() {
        return this.writingTicks;
    }

    public int getWritingState() {
        return this.writingState;
    }

    public long getReadingTicks() {
        return this.readingTicks;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public long getLastTotalWriteTime() {
        return this.lastTotalWriteTime;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)"OpcPointDeviceExt", 2);
        out.prop((Object)"pendingRead.size()", (Object)new Integer(this.pendingRead.size()));
        out.prop((Object)"reading", (Object)new Boolean(this.reading));
        out.prop((Object)"doReadCount", (Object)new Long(this.doReadCount));
        out.prop((Object)"readingBusyCount", (Object)new Long(this.readingBusyCount));
        out.prop((Object)"readingClearedCount", (Object)new Long(this.readingClearedCount));
        out.prop((Object)"pendingWrite.size()", (Object)new Integer(this.pendingWrite.size()));
        out.prop((Object)"writing", (Object)new Boolean(this.writing));
        out.prop((Object)"writingState", (Object)new Integer(this.writingState));
        out.prop((Object)"doWriteCount", (Object)new Long(this.doWriteCount));
        out.prop((Object)"writingClearedCount", (Object)new Long(this.writingClearedCount));
        out.prop((Object)"writingBusyCount", (Object)new Long(this.writingBusyCount));
        out.prop((Object)"waitingWr", (Object)new Boolean(this.waitingWr));
        out.prop((Object)"lastWriteTime", (Object)new Long(this.lastWriteTime));
        out.prop((Object)"lastTotalWriteTime", (Object)new Long(this.lastTotalWriteTime));
        out.endProps();
        super.spy(out);
    }

    private class Counter {
        private int count = 1;

        private Counter() {
        }

        public int increment() {
            if (this.count == Integer.MAX_VALUE) {
                this.count = 1;
            }
            return this.count++;
        }
    }

    private class Listener
    implements OpcGroup.GroupListener {
        @Override
        public void asyncCallbackDeleted() {
            if (BOpcPointDeviceExt.this.getState().isEngaged()) {
                // empty if block
            }
        }

        @Override
        public void updateBoolean(int handle, boolean val, long utcTimestamp, int quality, int hresult, boolean isSync) {
            BStatusBoolean sv = new BStatusBoolean(val);
            BOpcPointDeviceExt.this.readResult(handle, (BStatusValue)sv, utcTimestamp, quality, hresult, isSync);
        }

        @Override
        public void updateError(int handle, long utcTimestamp, int quality, int hresult, boolean isSync) {
            BOpcPointDeviceExt.this.readResult(handle, null, utcTimestamp, quality, hresult, isSync);
        }

        @Override
        public void updateNumeric(int handle, double val, long utcTimestamp, int quality, int hresult, boolean isSync) {
            BStatusNumeric sv = new BStatusNumeric(val);
            BOpcPointDeviceExt.this.readResult(handle, (BStatusValue)sv, utcTimestamp, quality, hresult, isSync);
        }

        @Override
        public void updateString(int handle, String val, long utcTimestamp, int quality, int hresult, boolean isSync) {
            BStatusString sv = new BStatusString(val);
            BOpcPointDeviceExt.this.readResult(handle, (BStatusValue)sv, utcTimestamp, quality, hresult, isSync);
        }

        @Override
        public void OnWriteCompleted(int transId, int grpHandle, int hrMaster, int noOfItems, int[] clientHandle, int[] hresultArray) {
            BOpcPointDeviceExt.this.onWriteCompleted(transId, grpHandle, hrMaster, noOfItems, clientHandle, hresultArray);
        }

        @Override
        public void OnReturnWrite(boolean isSync, int hresult, int noOfItems, int transId, int cancelId, int[] serverHandle, int[] hresultArray) {
            if (isSync) {
                BOpcPointDeviceExt.this.onReturnWriteSync(hresult, noOfItems, serverHandle, hresultArray);
            } else {
                BOpcPointDeviceExt.this.onReturnWriteAsync(hresult, noOfItems, transId, cancelId, serverHandle, hresultArray);
            }
        }

        @Override
        public void OnReturnRead(int hresult, int noOfItems, int transId, int cancelId, int[] serverHandle, int[] hresultArray) {
            BOpcPointDeviceExt.this.onReturnReadAsync(hresult, noOfItems, transId, cancelId, serverHandle, hresultArray);
        }

        @Override
        public void OnReadCompleted(int transId, int hrMasterQty, int hrMaster, int noOfItems, int[] ClientHandles, int[] dataTypes, String[] values, int[] qualities, long[] timeStamps, int[] hresultArray) {
            BOpcPointDeviceExt.this.onReadCompleted(transId, hrMasterQty, hrMaster, noOfItems, ClientHandles, dataTypes, values, qualities, timeStamps, hresultArray);
        }
    }
}

