/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitLon;

import com.tridium.lonworks.local.BPseudoNV;
import com.tridium.lonworks.local.BPseudoNvContainer;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonOccupancyEnum;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;

public class BLonTodEvent
extends BPseudoNvContainer {
    public static final Property updateTime = BLonTodEvent.newProperty((int)0, (BValue)BRelTime.make((long)60000L), null);
    public static final Property currentState = BLonTodEvent.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    public static final Property nextState = BLonTodEvent.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    public static final Property nextTime = BLonTodEvent.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Property maxTimeToNextState = BLonTodEvent.newProperty((int)0, (int)65535, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)65535), (String)"units", (BIDataValue)UnitDatabase.getUnit((String)"minute")));
    public static final Property todEvent = BLonTodEvent.newProperty((int)0, (BValue)new BPseudoNV(128, BLonNvDirection.output), null);
    public static final Action timerExpired = BLonTodEvent.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BLonTodEvent.class);
    private boolean posted = false;
    private static final BIcon icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/nvClock.png");
    Clock.Ticket ticket;

    public BRelTime getUpdateTime() {
        return (BRelTime)this.get(updateTime);
    }

    public void setUpdateTime(BRelTime v) {
        this.set(updateTime, (BValue)v, null);
    }

    public BStatusValue getCurrentState() {
        return (BStatusValue)this.get(currentState);
    }

    public void setCurrentState(BStatusValue v) {
        this.set(currentState, (BValue)v, null);
    }

    public BStatusValue getNextState() {
        return (BStatusValue)this.get(nextState);
    }

    public void setNextState(BStatusValue v) {
        this.set(nextState, (BValue)v, null);
    }

    public BAbsTime getNextTime() {
        return (BAbsTime)this.get(nextTime);
    }

    public void setNextTime(BAbsTime v) {
        this.set(nextTime, (BValue)v, null);
    }

    public int getMaxTimeToNextState() {
        return this.getInt(maxTimeToNextState);
    }

    public void setMaxTimeToNextState(int v) {
        this.setInt(maxTimeToNextState, v, null);
    }

    public BPseudoNV getTodEvent() {
        return (BPseudoNV)this.get(todEvent);
    }

    public void setTodEvent(BPseudoNV v) {
        this.set(todEvent, (BValue)v, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isOk()) {
            return;
        }
        this.initTimer();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning() || !this.isOk()) {
            return;
        }
        if (p == currentState || p == nextState || p == nextTime || p == maxTimeToNextState) {
            this.update();
        } else if (p == updateTime) {
            this.initTimer();
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.isOk()) {
            return;
        }
        this.update();
    }

    private void initTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.getUpdateTime().getMillis() <= 0L) {
            return;
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateTime(), (Action)timerExpired, null);
    }

    public void doTimerExpired() {
        if (this.okayToUpdate()) {
            this.update();
        }
    }

    public boolean okayToUpdate() {
        long delta = Math.abs(this.getNextTime().getMillis() - Clock.millis());
        return delta > 20000L;
    }

    private synchronized void update() {
        if (this.posted) {
            return;
        }
        this.posted = true;
        this.getLonNetwork().postAsync(new Runnable(){

            @Override
            public void run() {
                BLonTodEvent.this.doUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        NmUtil.wait((int)200);
        BLonData ld = this.getTodEvent().copyData();
        ld.set("currentState", (BValue)BLonEnum.make((BEnum)this.makeLonOccEnum(this.getCurrentState())));
        ld.set("nextState", (BValue)BLonEnum.make((BEnum)this.makeLonOccEnum(this.getNextState())));
        ld.set("timeToNextState", (BValue)BLonFloat.make((float)this.nextTimeMin()));
        this.getTodEvent().updateData(ld, false);
        BLonTodEvent bLonTodEvent = this;
        synchronized (bLonTodEvent) {
            this.posted = false;
        }
    }

    BLonOccupancyEnum makeLonOccEnum(BStatusValue v) {
        BStatusBoolean bool = (BStatusBoolean)v;
        if (bool.getValue()) {
            return BLonOccupancyEnum.occupied;
        }
        return BLonOccupancyEnum.unoccupied;
    }

    private float nextTimeMin() {
        long eventTime = this.getNextTime().getMillis();
        float nxtTime = (eventTime - Clock.millis()) / 1000L / 60L;
        if (nxtTime > (float)this.getMaxTimeToNextState()) {
            nxtTime = this.getMaxTimeToNextState();
        }
        if (nxtTime < 0.0f) {
            nxtTime = 0.0f;
        }
        return nxtTime;
    }

    public BIcon getIcon() {
        return icon;
    }
}

