/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.px;

import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONString;
import com.tridium.mobile.BVelocityMobileAppView;
import com.tridium.mobile.px.BMobilePxApp;
import com.tridium.util.ObjectUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;
import javax.baja.web.BIWebProfile;
import javax.baja.web.WebOp;
import javax.baja.web.mobile.BIMobilePxView;
import org.apache.velocity.VelocityContext;

public class BMobilePxAppView
extends BVelocityMobileAppView
implements BIMobilePxView {
    public static final BMobilePxAppView INSTANCE = new BMobilePxAppView();
    public static final Type TYPE = Sys.loadType(BMobilePxAppView.class);
    private BAbstractPxView pxView;

    public Type getType() {
        return TYPE;
    }

    public BMobilePxAppView() {
    }

    public BMobilePxAppView(BAbstractPxView pxView) {
        this.pxView = pxView;
    }

    public Type getMobileAppType() {
        return BMobilePxApp.TYPE;
    }

    public BOrd getTemplateFileOrd(WebOp op) {
        return BOrd.make((String)"module://mobile/rc/px/px.vm");
    }

    protected void doInitVelocityContext(VelocityContext context, WebOp op, BIWebProfile profile) throws Exception {
        context.put("title", (Object)this.getDisplayName(op));
        context.put("viewPortZoom", (Object)Boolean.TRUE);
    }

    protected void doInitNiagaraViewInfo(JSONObject obj, WebOp op) throws Exception {
        obj.put("px", (Object)this.generatePx(op));
    }

    protected String getName(WebOp op) {
        if (this.pxView != null) {
            return this.pxView.getName();
        }
        BINavNode navNode = (BINavNode)op.get();
        return navNode.getNavName();
    }

    protected String getDisplayName(WebOp op) {
        if (this.pxView != null) {
            return this.pxView.getDisplayName((Context)op);
        }
        BINavNode navNode = (BINavNode)op.get();
        return navNode.getNavDisplayName((Context)op);
    }

    protected BAbstractPxView getPxView(WebOp op) {
        if (this.pxView != null) {
            return this.pxView;
        }
        if (op.get() instanceof BAbstractPxView) {
            return (BAbstractPxView)op.get();
        }
        if (op.get() instanceof BPxFile) {
            BPxView view = new BPxView(op.getOrd());
            return view;
        }
        return null;
    }

    public void doPost(WebOp op) throws Exception {
        String header = op.getRequest().getHeader("niagara-mobile-rpc");
        if (header != null && header.equals("px")) {
            op.getResponse().setHeader("transfer-encoding", "chunked");
            op.setContentType("application/json");
            op.getResponse().getWriter().print(this.generatePx(op).toString());
        } else {
            super.doPost(op);
        }
    }

    protected PxInfo decodeMobilePx(WebOp op) throws Exception {
        PxDecoder decoder;
        BAbstractPxView pxView = this.getPxView(op);
        Object pxInfo = op.getRequest().getAttribute("pxInfo");
        if (pxInfo instanceof PxInfo) {
            return (PxInfo)pxInfo;
        }
        BINavNode target = (BINavNode)op.get();
        if (pxView instanceof BPxView) {
            BPxView view = (BPxView)pxView;
            BOrd pxFileOrd = view.getPxFile();
            OrdTarget pxViewTarget = ObjectUtil.resolveAndCheckRead((BOrd)pxFileOrd, null, (Context)op);
            BIFile file = (BIFile)pxViewTarget.get();
            decoder = new PxDecoder(file, (Context)op);
        } else if (pxView instanceof BDynamicPxView) {
            BDynamicPxView dynView = (BDynamicPxView)pxView;
            String xml = dynView.generateXml((Object)target, (Context)op);
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
            decoder = new PxDecoder(target.getNavOrd(), (InputStream)in, (Context)op);
        } else {
            throw new IllegalStateException("Unknown PxView Type: " + pxView.getType());
        }
        BWidget root = decoder.decodeDocument();
        TypeInfo media = pxView.getName() != null ? pxView.getMedia().getTypeInfo() : decoder.getMedia();
        PxInfo newPxInfo = new PxInfo((BValue)root, media);
        op.getRequest().setAttribute("pxInfo", (Object)newPxInfo);
        return newPxInfo;
    }

    private JSONString createPxBson(BValue root) throws Exception {
        String bson = BsonEncoderPlugin.marshal((BValue)root);
        return () -> bson;
    }

    private JSONObject generatePx(WebOp op) throws Exception {
        PxInfo info = this.decodeMobilePx(op);
        JSONObject px = new JSONObject();
        px.put("name", (Object)this.getName(op));
        px.put("displayName", (Object)this.getDisplayName(op));
        px.put("bson", (Object)this.createPxBson(info.root));
        return px;
    }

    protected static class PxInfo {
        TypeInfo media;
        BValue root;

        PxInfo(BValue root, TypeInfo media) {
            this.root = root;
            this.media = media;
        }
    }
}

