/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.px;

import com.tridium.json.JSONObject;
import com.tridium.mobile.px.BMobilePxApp;
import com.tridium.mobile.px.BMobilePxAppView;
import com.tridium.mobile.px.ui.BMobilePxMedia;
import java.util.Optional;
import javax.baja.agent.BAbstractPxView;
import javax.baja.hx.px.BHxPxView;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BIWebProfile;
import javax.baja.web.WebOp;
import org.apache.velocity.VelocityContext;

public class BMobileMediaPxAppView
extends BMobilePxAppView {
    public static final BMobileMediaPxAppView INSTANCE = new BMobileMediaPxAppView();
    public static final Type TYPE = Sys.loadType(BMobileMediaPxAppView.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BMobileMediaPxAppView() {
    }

    public BMobileMediaPxAppView(BAbstractPxView pxView) {
        super(pxView);
    }

    @Override
    public Type getMobileAppType() {
        return BMobilePxApp.TYPE;
    }

    private boolean getShowHxPx() {
        Optional app = Sys.findService((Type)BMobilePxApp.TYPE);
        return app.isPresent() && ((BMobilePxApp)((Object)app.get())).getShowHxPx();
    }

    private boolean isMobileMedia(WebOp op) throws Exception {
        BAbstractPxView pxView = this.getPxView(op);
        if (pxView != null) {
            BTypeSpec media = pxView.getMedia();
            if (pxView.getName() == null) {
                BMobilePxAppView.PxInfo info = this.decodeMobilePx(op);
                if (info.media != null) {
                    media = info.media.getTypeSpec();
                }
            }
            return media != null && (media.equals((Object)BMobilePxMedia.TYPE.getTypeSpec()) || !this.getShowHxPx());
        }
        return false;
    }

    public void doGet(WebOp op) throws Exception {
        ViewQuery viewQuery = op.getViewQuery();
        if (viewQuery != null && viewQuery.getParameter("preferHx", "false").equals("true")) {
            BHxPxView.INSTANCE.doGet(op);
        } else {
            super.doGet(op);
        }
    }

    @Override
    protected void doInitNiagaraViewInfo(JSONObject obj, WebOp op) throws Exception {
        if (this.isMobileMedia(op)) {
            super.doInitNiagaraViewInfo(obj, op);
        }
    }

    @Override
    protected void doInitVelocityContext(VelocityContext context, WebOp op, BIWebProfile profile) throws Exception {
        context.put("mobileMedia", (Object)this.isMobileMedia(op));
        super.doInitVelocityContext(context, op, profile);
    }

    @Override
    public void doPost(WebOp op) throws Exception {
        ViewQuery viewQuery = op.getViewQuery();
        if (viewQuery != null && viewQuery.getParameter("preferHx", "false").equals("true")) {
            BHxPxView.INSTANCE.doPost(op);
        } else {
            super.doPost(op);
        }
    }
}

