/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.job;

import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetAws.BBacnetAwsNetwork;
import com.tridium.bacnetAws.datatypes.BReinitializeDeviceConfig;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.security.BPassword;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BReinitializeDeviceJob
extends BDeviceManagerJob {
    public static final Type TYPE = Sys.loadType(BReinitializeDeviceJob.class);
    private BReinitializeDeviceConfig params;
    static Lexicon lex = Lexicon.make((String)"bacnetAws");

    public Type getType() {
        return TYPE;
    }

    public BReinitializeDeviceJob() {
    }

    public BReinitializeDeviceJob(BBacnetAwsNetwork bacnet, BReinitializeDeviceConfig params) {
        super((BBacnetNetwork)bacnet);
        this.params = params;
    }

    public void run(Context cx) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Reinitializing device at " + this.params.getDeviceAddress() + " with command" + (Object)((Object)this.params.getReinitializeCommand()) + "...");
        }
        try {
            String password = null;
            String pw = AccessController.doPrivileged(() -> ((BPassword)this.params.getPassword()).getValue());
            if (pw.length() > 0) {
                password = pw;
            }
            this.client().reinitializeDevice(this.params.getDeviceAddress(), this.params.getReinitializedStateOfDevice(), password, this.params.getCharacterSet());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception sending ReinitializeDevice: " + e, e);
            String msg = MessageFormat.format(lex.getText("reinitDevice.fail"), e);
            this.add("failureCause", (BValue)BString.make((String)e.toString()));
            this.log().failed(msg);
            throw e;
        }
    }
}

