/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetAws.BBacnetAwsNetwork;
import com.tridium.bacnetAws.datatypes.BBackupConfig;
import java.io.OutputStream;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.config.BBacnetFile;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReinitializedDeviceState;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.security.BPassword;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.servlet.http.HttpServletResponse;

public class BBackupJob
extends BDeviceManagerJob {
    public static final Type TYPE = Sys.loadType(BBackupJob.class);
    private BBacnetAwsNetwork bacnetAws;
    private BBackupConfig params;
    private HttpServletResponse response;
    private boolean waitForResponse;
    static Lexicon lex = Lexicon.make((String)"bacnetAws");

    public Type getType() {
        return TYPE;
    }

    public BBackupJob() {
    }

    public BBackupJob(BBacnetAwsNetwork bacnet, BBackupConfig params) {
        super((BBacnetNetwork)bacnet);
        this.bacnetAws = bacnet;
        this.params = params;
    }

    public BBackupJob(BBacnetAwsNetwork bacnet, BBackupConfig params, boolean waitForResponse) {
        this(bacnet, params);
        this.waitForResponse = waitForResponse;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void run(Context cx) throws Exception {
        boolean success = false;
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        this.progress(0);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Backing up device at " + this.params.getDeviceAddress() + "...");
        }
        ZipOutputStream zipOutDownload = null;
        String password = null;
        String pw = AccessController.doPrivileged(() -> ((BPassword)this.params.getPassword()).getValue());
        if (pw.length() > 0) {
            password = pw;
        }
        int backupFailureTimeoutOrig = -1;
        boolean resetTimeout = false;
        try {
            boolean hasBRState;
            long protRev = 0L;
            long vendorId = 0L;
            try {
                protRev = AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 139));
            }
            catch (Exception e) {
                this.log().message("Protocol Revision cannot be determined: " + e);
            }
            this.progress(2);
            try {
                vendorId = AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 120));
            }
            catch (Exception e) {
                this.log().message("Vendor ID cannot be determined: " + e);
            }
            this.progress(4);
            int brState = 5;
            boolean useTridiumIds = false;
            if (protRev < 10L && vendorId == 36L) {
                useTridiumIds = true;
            }
            boolean bl = hasBRState = (brState = this.readBRProp(338, useTridiumIds, -1, 9)) >= 0;
            if (brState > 0 && brState < 5) {
                throw new IllegalStateException("Cannot backup device; BackupAndRestoreState " + BBacnetBackupState.tag((int)brState) + " is not IDLE!");
            }
            this.progress(6);
            try {
                backupFailureTimeoutOrig = (int)AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(153, false)));
                resetTimeout = true;
            }
            catch (BacnetException e) {
                this.log().message("Could not read Backup_Failure_Timeout property:" + (Object)((Object)e));
            }
            try {
                int backupFailureTimeoutNew = 90;
                this.client().writeProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 153, AsnUtil.toAsnUnsigned((long)backupFailureTimeoutNew));
                this.log().message("Successful write to Backup_Failure_Timeout property: " + backupFailureTimeoutNew + 's');
            }
            catch (BacnetException e) {
                resetTimeout = false;
                this.log().message("Could not write Backup_Failure_Timeout property: " + (Object)((Object)e));
            }
            this.progress(10);
            this.log().message("Sending START_BACKUP command...");
            this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.startBackup, password, this.params.getCharacterSet());
            this.progress(12);
            if (hasBRState) {
                this.log().message("Monitoring Backup_And_Restore_State...");
                brState = this.readBRProp(338, useTridiumIds, -1, 9);
                long waitStart = Clock.ticks();
                long waitTime = 0L;
                while (brState != 3) {
                    this.log().message("Waiting for device backup preparation to complete (" + waitTime / 1000L + " sec)...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.checkCancel(lex.getText("backup.canceled"));
                    waitTime = Clock.ticks() - waitStart;
                    brState = this.readBRProp(338, useTridiumIds, -1, 9);
                    if (brState != -1 && brState != 5) continue;
                    throw new RuntimeException("BACKUP_FAILURE received from device: unable to enter backup mode!");
                }
            }
            this.progress(15);
            this.log().message("Reading Configuration_Files...");
            int idsLen = AsnUtil.fromAsnUnsignedInt((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 154, 0));
            this.checkCancel(lex.getText("backup.canceled"));
            BBacnetObjectIdentifier[] configurationFileIds = new BBacnetObjectIdentifier[idsLen];
            byte[] val = this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 154);
            BValue[] ids = AsnUtil.fromAsn((byte[])val);
            if (ids.length != configurationFileIds.length) {
                throw new BajaRuntimeException("ids.length=" + ids.length + ", configFileIds.length=" + configurationFileIds.length);
            }
            this.progress(20);
            if (this.waitForResponse) {
                int counter = 0;
                while (this.response == null) {
                    Thread.sleep(1000L);
                    if (++counter <= 10) continue;
                    throw new Exception("Waiting for Download Stream took too long");
                }
                zipOutDownload = new ZipOutputStream((OutputStream)this.response.getOutputStream());
                zipOutDownload.setMethod(8);
                zipOutDownload.setLevel(9);
            }
            this.progress(25);
            BFileSystem fs = BFileSystem.INSTANCE;
            for (int i = 0; i < configurationFileIds.length; ++i) {
                this.checkCancel(lex.getText("backup.canceled"));
                configurationFileIds[i] = (BBacnetObjectIdentifier)ids[i];
                String fileName = AsnUtil.fromAsnCharacterString((byte[])this.client().readProperty(this.params.getDeviceAddress(), configurationFileIds[i], 77));
                BBacnetDevice dev = this.bacnetAws.lookupDeviceById(this.params.getDeviceId());
                byte[] b = BBacnetFile.readFile((BBacnetDevice)dev, (BBacnetObjectIdentifier)configurationFileIds[i]);
                String fullFileName = fileName + "_" + configurationFileIds[i].getInstanceNumber() + "_" + i;
                if (zipOutDownload != null) {
                    logger.fine("writing file from BackupJob to stream");
                    zipOutDownload.putNextEntry(new ZipEntry(fullFileName));
                    zipOutDownload.write(b);
                    zipOutDownload.closeEntry();
                    logger.fine("BackupJob stream complete");
                    continue;
                }
                FilePath dir = BBackupJob.toFilePath(this.params.getBaseDirectory().normalize());
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("fileId:" + configurationFileIds[i] + " fileName=" + fileName + " dir=" + dir);
                }
                dir = dir.merge(this.params.getDeviceDirectoryName());
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("  dir->" + dir);
                }
                FilePath fp = dir.merge(fullFileName);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("fp=" + fp);
                }
                AccessController.doPrivileged(() -> {
                    BIFile file = fs.makeFile(fp, cx);
                    try (OutputStream out = file.getOutputStream();){
                        out.write(b);
                        Void void_ = null;
                        return void_;
                    }
                });
                this.progress(i, configurationFileIds.length, 25, 100);
            }
            this.log().success("Finished Backup Procedure!");
            success = true;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception backing up device: " + e, e);
            String msg = MessageFormat.format(lex.getText("backup.fail"), e);
            this.add("failureCause", (BValue)BString.make((String)e.toString()));
            this.log().failed(msg);
            throw e;
        }
        finally {
            try {
                this.log().message("Sending END_BACKUP command...");
                this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.endBackup, password, this.params.getCharacterSet());
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception occurred in sending END_BACKUP command: " + e, e);
                this.log().failed("Exception occurred in sending END_BACKUP command!");
            }
            if (resetTimeout) {
                this.resetBackupFailureTimeout(backupFailureTimeoutOrig);
            }
            if (this.response != null) {
                if (success) {
                    zipOutDownload.finish();
                    zipOutDownload.close();
                } else {
                    this.response.sendError(404);
                }
                this.response = null;
            }
        }
    }

    private void resetBackupFailureTimeout(int backupFailureTimeoutOrig) {
        try {
            this.client().writeProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 153, AsnUtil.toAsnUnsigned((long)backupFailureTimeoutOrig));
            this.log().message("Successful reset of Backup_Failure_Timeout property to " + backupFailureTimeoutOrig + 's');
        }
        catch (Exception e) {
            this.log().message("Failed to reset Backup_Failure_Timeout property to " + backupFailureTimeoutOrig + "s: " + e);
        }
    }

    public static FilePath toFilePath(BOrd ord) {
        OrdQuery[] q = ord.parse();
        for (int i = 0; i < q.length; ++i) {
            if (!(q[i] instanceof FilePath)) continue;
            return (FilePath)q[i];
        }
        throw new IllegalStateException();
    }

    private int readBRProp(int propId, boolean useTridium, int defValue, int asnType) {
        String propName = BBacnetPropertyIdentifier.tag((int)propId);
        if (useTridium) {
            propName = propName + " (Niagara)";
        }
        int ret = defValue;
        try {
            switch (asnType) {
                case 2: {
                    ret = (int)AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(propId, useTridium)));
                    break;
                }
                case 9: {
                    ret = AsnUtil.fromAsnEnumerated((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(propId, useTridium)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid asnType supplied to readBRProp:" + asnType);
                }
            }
        }
        catch (Exception e) {
            this.log().message("Error reading " + propName + ":" + e);
        }
        return ret;
    }

    private int propId(int basePropId, boolean useTridium) {
        return useTridium ? basePropId + 1000 : basePropId;
    }
}

