/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws;

import com.tridium.bacnetAws.BBacnetAwsDevice;
import com.tridium.bacnetAws.BBacnetAwsDeviceFolder;
import com.tridium.bacnetAws.BLocalBacnetAwsDevice;
import com.tridium.bacnetAws.datatypes.BBackupConfig;
import com.tridium.bacnetAws.datatypes.BCommControlConfig;
import com.tridium.bacnetAws.datatypes.BReinitializeDeviceConfig;
import com.tridium.bacnetAws.datatypes.BRestoreConfig;
import com.tridium.bacnetAws.history.BBacnetAwsHistoryDeviceExt;
import com.tridium.bacnetAws.job.BBackupJob;
import com.tridium.bacnetAws.job.BDeviceCommControlJob;
import com.tridium.bacnetAws.job.BReinitializeDeviceJob;
import com.tridium.bacnetAws.job.BRestoreJob;
import com.tridium.bacnetOws.BBacnetOwsNetwork;
import com.tridium.box.json.BsonDecoderPlugin;
import java.util.logging.Level;
import javax.baja.agent.AgentList;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnetAws.config.BBacnetAwsConfigDeviceExt;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;

public class BBacnetAwsNetwork
extends BBacnetOwsNetwork {
    public static final Property localDevice = BBacnetAwsNetwork.newProperty((int)0, (BValue)new BLocalBacnetAwsDevice(), null);
    public static final Type TYPE = Sys.loadType(BBacnetAwsNetwork.class);
    public static final Context jobContext = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            return "BacnetAws:jobContext";
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    };
    private boolean licenseChecked = false;

    public BLocalBacnetAwsDevice getLocalDevice() {
        return (BLocalBacnetAwsDevice)this.get(localDevice);
    }

    public void setLocalDevice(BLocalBacnetAwsDevice v) {
        this.set(localDevice, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkLicense();
    }

    protected void setDeviceExt(BBacnetDevice device) {
        if (!(device.getTrendLogs() instanceof BBacnetAwsHistoryDeviceExt)) {
            device.setTrendLogs((BHistoryDeviceExt)new BBacnetAwsHistoryDeviceExt());
        }
        if (!(device.getConfig() instanceof BBacnetAwsConfigDeviceExt)) {
            device.setConfig((BBacnetConfigDeviceExt)new BBacnetAwsConfigDeviceExt());
        }
    }

    public BOrd doSubmitDeviceManagerJob(BValue arg, Context cx) {
        this.checkLicense();
        if (this.isFatalFault()) {
            return null;
        }
        Type t = arg.getType();
        if (t.is(BCommControlConfig.TYPE)) {
            return new BDeviceCommControlJob(this, (BCommControlConfig)arg).submit(cx);
        }
        if (t.is(BReinitializeDeviceConfig.TYPE)) {
            return new BReinitializeDeviceJob(this, (BReinitializeDeviceConfig)arg).submit(cx);
        }
        if (t.is(BBackupConfig.TYPE)) {
            return new BBackupJob(this, (BBackupConfig)arg).submit(cx);
        }
        if (t.is(BRestoreConfig.TYPE)) {
            return new BRestoreJob(this, (BRestoreConfig)arg).submit(cx);
        }
        return super.doSubmitDeviceManagerJob(arg, cx);
    }

    @NiagaraRpc(isSecure=false, permissions="i", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public BOrd doSubmitDeviceManagerJob(String valueEncoding, String password, Context cx) throws Exception {
        BWebService webService;
        if (!cx.getFacets().getb("isSecure", false) && (webService = (BWebService)Sys.getService((Type)BWebService.TYPE)).getRequireHttpsForPasswords()) {
            throw new Exception("HTTPS connection required for setting passwords.");
        }
        BComplex c = BsonDecoderPlugin.unmarshal((String)valueEncoding).asComplex();
        c.set("password", (BValue)BPassword.make((String)password));
        return (BOrd)this.invoke(submitDeviceManagerJob, (BValue)c, cx);
    }

    public Type getDeviceType() {
        return BBacnetAwsDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BBacnetAwsDeviceFolder.TYPE;
    }

    protected Feature getAwsLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "bacnetAws");
    }

    private void checkLicense() {
        if (this.licenseChecked) {
            return;
        }
        try {
            Feature feature = this.getAwsLicenseFeature();
            if (feature == null) {
                return;
            }
            feature.check();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Unlicensed: " + this.toPathString(), e);
            this.configFatal("Unlicensed: " + e);
        }
        finally {
            this.licenseChecked = true;
        }
    }

    public boolean isAws() {
        return true;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("bacnetOws:BacnetOwsDeviceManager");
        agents.remove("bacnetOws:BacnetOwsDeviceUxManager");
        return agents;
    }
}

