/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSyncNiagara;

import com.tridium.fcModelSync.driver.BHistorySourceDiscoverer;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraHistoryImport;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSlotScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraHistoryImport"})})
public class BNiagaraHistorySourceDiscoverer
extends BHistorySourceDiscoverer {
    public static final Type TYPE = Sys.loadType(BNiagaraHistorySourceDiscoverer.class);
    List<BNiagaraProxyExt> niagaraProxyExts;
    Logger log = Logger.getLogger("fcModelSync.niagara");

    public Type getType() {
        return TYPE;
    }

    public String getHistorySource(BHistoryImport historyImport) {
        this.log.fine(() -> String.format("BNiagaraHistorySourceDiscoverer.getHistorySource() on %s", historyImport));
        BNiagaraHistoryImport nhImp = (BNiagaraHistoryImport)historyImport;
        BNiagaraStation ns = (BNiagaraStation)historyImport.getDevice();
        BNiagaraPointDeviceExt pts = ns.getPoints();
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase database = service.getDatabase();
        if (database == null) {
            return null;
        }
        BHistoryId hId = nhImp.getHistoryId().fromShorthand(historyImport.getDevice().getName());
        try (HistoryDatabaseConnection conn = database.getDbConnection(null);){
            BIHistory history = conn.getHistory(hId);
            if (history != null) {
                BHistoryConfig cfg = history.getConfig();
                this.log.finest(() -> String.format("history id %s, config source: %s", hId, cfg.getSource()));
                BOrd src = cfg.getSource().get(0);
                OrdQuery[] oqs = src.parse();
                OrdQuery oq = oqs[oqs.length - 1];
                if (oq.getScheme().equals(BSlotScheme.INSTANCE.getId())) {
                    SlotPath sp = ((SlotPath)oq).getParent();
                    this.log.finest(() -> String.format("parent slotpath: %s", sp));
                    BControlPoint pt = this.getPointBySlotPath(pts, sp);
                    if (pt != null) {
                        this.log.fine(() -> String.format("Returning pointSlotPath: %s", pt.getSlotPath()));
                        String string = pt.getSlotPath().toString();
                        return string;
                    }
                    this.log.fine(() -> String.format("Returning fallback pointSlotPath: %s", sp));
                    String string = sp.toString();
                    return string;
                }
            }
        }
        return null;
    }

    private BControlPoint getPointBySlotPath(BNiagaraPointDeviceExt pts, SlotPath sp) {
        if (this.niagaraProxyExts == null) {
            this.niagaraProxyExts = pts.getDescendantNiagaraProxyExts();
        }
        return this.niagaraProxyExts.stream().filter(x -> x.getPointId().equals(sp.toString())).findFirst().map(BPointExtension::getParentPoint).orElse(null);
    }
}

