/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.wizards;

import com.tridium.devkit.codegen.NameUtilFromLonGen;
import com.tridium.devkit.wizards.NewDriverWizard2;
import com.tridium.workbench.tools.NewModuleWizard;
import java.util.PrimitiveIterator;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XWriter;

public abstract class DriverWizardModel
extends WizardModel {
    String newVendor = "acmeCo";
    String newModuleName = "ultimateDriver";
    static UiLexicon lex = UiLexicon.makeUiLexicon(DriverWizardModel.class);
    static BImage banner = BImage.make((String)"module://icons/x32/newModule.png");
    static final String lexAuthor = lex.getText("driver.author");
    static final String lexBasePackage = lex.getText("driver.basePackage");
    NewDriverWizard2 driverWizard;
    BWbShell shell;
    int currentStep = 0;
    StringBuffer driverName;
    BWidget step0;
    BTextField moduleDir = new BTextField("", 60);
    BTextField moduleName = new BTextField("Ultimate Driver", 20);
    String formattedName = null;
    BTextField prefSymbol = new BTextField("ud", 20);
    BTextField moduleDescription = new BTextField("", 50);
    BTextField vendor = new BTextField("Acme Co", 50);
    BTextField version = new BTextField("1.0", 10);
    BTextField author = new BTextField("Anonymous", 50);
    BTextField basePackage = new BTextField("com.acmeCo.ultimateDriver", 50);

    public DriverWizardModel(BWbShell shell, NewDriverWizard2 drvrWizard) {
        this.shell = shell;
        this.driverWizard = drvrWizard;
    }

    void buildModuleDetailsStep(String title, String description) {
        String versionStr;
        BButton button = new BButton((Command)new NewModuleWizard.Browse((BWidget)this.shell, this.moduleDir, this.vendor, this.version));
        button.setButtonStyle(BButtonStyle.toolBar);
        BGridPane dir = new BGridPane(2);
        dir.add(null, (BValue)this.moduleDir);
        dir.add(null, (BValue)button);
        BGridPane a = new BGridPane(1);
        a.add(null, (BValue)new BLabel(NewModuleWizard.lexModuleDir));
        a.add(null, (BValue)dir);
        this.moduleName.setModel((TextModel)new NameModel());
        this.vendor.setModel((TextModel)new VendorModel());
        this.moduleDir.setText(this.getInitialBaseDir());
        FilePath moduleDirPath = new FilePath(this.moduleDir.getText());
        String vendorStr = NewModuleWizard.getVendorFromVendorGradle((FilePath)moduleDirPath);
        if (vendorStr != null) {
            this.vendor.setText(vendorStr);
        }
        if ((versionStr = NewModuleWizard.getVersionFromVendorGradle((FilePath)moduleDirPath)) != null) {
            this.version.setText(versionStr);
        }
        this.author.setText(this.getInitialAuthor());
        BGridPane b = new BGridPane(2);
        b.add(null, (BValue)new BLabel(NewModuleWizard.lexModuleName));
        b.add(null, (BValue)this.moduleName);
        b.add(null, (BValue)new BLabel(NewModuleWizard.lexPrefSymbol));
        b.add(null, (BValue)this.prefSymbol);
        b.add(null, (BValue)new BLabel(NewModuleWizard.lexDescription));
        b.add(null, (BValue)this.moduleDescription);
        b.add(null, (BValue)new BLabel(NewModuleWizard.lexVendor));
        b.add(null, (BValue)this.vendor);
        b.add(null, (BValue)new BLabel(NewModuleWizard.lexVersion));
        b.add(null, (BValue)this.version);
        b.add(null, (BValue)new BLabel(lexAuthor));
        b.add(null, (BValue)this.author);
        b.add(null, (BValue)new BLabel(lexBasePackage));
        b.add(null, (BValue)this.basePackage);
        BGridPane d = new BGridPane(1);
        d.setHalign(BHalign.left);
        d.setValign(BValign.top);
        d.setRowGap(10.0);
        d.add(null, (BValue)a);
        d.add(null, (BValue)b);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, title, description));
        edge.setCenter((BWidget)new BBorderPane((BWidget)d, 10.0, 10.0, 10.0, 10.0));
        this.step0 = edge;
    }

    private void updateBasePackage() {
        this.basePackage.setText("com." + this.newVendor + "." + this.newModuleName);
    }

    public static String formatString(String in, String def) {
        if (in.length() == 0) {
            return def;
        }
        return NameUtilFromLonGen.toJavaName(in, false);
    }

    void stepToSelectStep() {
        this.driverWizard.init();
        this.currentStep = 0;
    }

    void validateModuleDetail() {
        String[] packageParts;
        if (this.moduleDir.getText().length() == 0) {
            throw new BajaRuntimeException("Module directory is not valid.");
        }
        new FilePath(this.moduleDir.getText());
        if (this.moduleName.getText().length() == 0) {
            throw new BajaRuntimeException("Module name is not valid.");
        }
        if (this.prefSymbol.getText().length() == 0) {
            throw new BajaRuntimeException("Preferred symbol is not valid.");
        }
        if (this.prefSymbol.getText().length() > 8) {
            throw new BajaRuntimeException("Preferred symbol is too long.");
        }
        if (this.vendor.getText().length() == 0) {
            throw new BajaRuntimeException("Vendor is not valid.");
        }
        if (this.basePackage.getText().length() == 0) {
            throw new BajaRuntimeException("Base package is not valid.");
        }
        for (String packageName : packageParts = this.basePackage.getText().split("\\.")) {
            if (!Character.isJavaIdentifierStart(packageName.charAt(0))) {
                throw new BajaRuntimeException("Package name cannot start with " + packageName.charAt(0) + ".");
            }
            PrimitiveIterator.OfInt it = packageName.codePoints().iterator();
            while (it.hasNext()) {
                int cp = (Integer)it.next();
                if (Character.isJavaIdentifierPart(cp)) continue;
                throw new BajaRuntimeException("Package name cannot contain " + new String(Character.toChars(cp)) + ".");
            }
        }
    }

    protected void doGradle(XWriter out, boolean rt, boolean hasWb) throws Exception {
        out.w((Object)"/*\n");
        out.w((Object)" * ").w((Object)NewModuleWizard.getCopyrightStatement((String)this.vendor.getText())).w((Object)"\n");
        out.w((Object)" */\n");
        out.w((Object)"description = \"").w((Object)this.moduleDescription.getText()).w((Object)"\"\n");
        out.w((Object)"\n");
        out.w((Object)"ext {\n");
        out.w((Object)"  name            = \"").w((Object)this.moduleName.getText().trim().replace(" ", "")).w((Object)"\"\n");
        out.w((Object)"  project.group   = \"").w((Object)this.vendor.getText().trim().replace(" ", "")).w((Object)"\"\n");
        out.w((Object)"  project.version = \"").w((Object)this.version.getText().trim()).w((Object)"\"\n");
        out.w((Object)"}\n");
        out.w((Object)"\n");
        out.w((Object)"niagaraModule {\n");
        String symb = DriverWizardModel.formatString(this.prefSymbol.getText(), "x");
        out.w((Object)"  preferredSymbol = \"").w((Object)symb).w((Object)"\"\n");
        out.w((Object)"  moduleName = \"").w((Object)this.moduleName()).w((Object)"\"\n");
        if (rt) {
            out.w((Object)"  runtimeProfile = \"rt\"\n");
            if (hasWb) {
                out.w((Object)"\n  modulePart {\n");
                out.w((Object)"         name = \"").w((Object)this.moduleName()).w((Object)"-wb\"\n");
                out.w((Object)"         runtimeProfile = \"wb\"\n");
                out.w((Object)"   }\n");
            }
        } else {
            out.w((Object)"  runtimeProfile = \"wb\"\n");
        }
        out.w((Object)"}\n");
        out.w((Object)"\n");
        this.doGradleDependances(out, rt);
        out.w((Object)"moduleTestJar {\n  from('srcTest') {\n  }\n}\n");
        out.close();
    }

    protected void doGradleDependances(XWriter out, boolean rt) throws Exception {
    }

    String getInitialBaseDir() {
        String ven = this.driverWizard.opts.getBaseDir();
        if (ven.length() == 0) {
            ven = BFileSystem.INSTANCE.localFileToPath(Sys.getNiagaraUserHome()).getBody();
        }
        return ven;
    }

    String getInitialAuthor() {
        String auth = this.driverWizard.opts.getAuthor();
        if (auth.length() == 0) {
            auth = System.getProperty("user.name", "author");
        }
        return auth;
    }

    void saveOpt() {
        this.driverWizard.opts.setBaseDir(this.moduleDir.getText());
        this.driverWizard.opts.setAuthor(this.author.getText());
        this.driverWizard.opts.save();
    }

    String moduleName() {
        return DriverWizardModel.formatString(this.moduleName.getText(), "foo");
    }

    class NameModel
    extends TextModel {
        NameModel() {
        }

        protected void textModified() {
            String x = this.getText();
            DriverWizardModel.this.newModuleName = DriverWizardModel.formatString(x, "yourDriverX");
            DriverWizardModel.this.updateBasePackage();
        }
    }

    class VendorModel
    extends TextModel {
        VendorModel() {
        }

        protected void textModified() {
            String x = this.getText();
            DriverWizardModel.this.newVendor = DriverWizardModel.formatString(x, "yourCompany");
            DriverWizardModel.this.updateBasePackage();
        }
    }
}

