/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.mysql;

import com.tridium.rdb.mysql.BMySQLDatabase;
import com.tridium.rdb.mysql.MySQLQuery;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsScheme;
import javax.baja.rdb.BRdbmsSession;
import javax.baja.rdb.RdbmsQuery;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BMySQLScheme
extends BRdbmsScheme {
    public static final BMySQLScheme INSTANCE = new BMySQLScheme();
    public static final Type TYPE = Sys.loadType(BMySQLScheme.class);

    private BMySQLScheme() {
        super("mysql");
    }

    public void pickle(BISession session, XElem pickle) {
        BMySQLDatabase db = (BMySQLDatabase)((BRdbmsSession)session).getDatabase();
        pickle.addAttr("host", db.getHostname());
        pickle.addAttr("port", Integer.toString(db.getPort()));
    }

    public BISession unpickle(XElem pickle) {
        return BRdbmsSession.make((BHost)BHost.getHost((String)pickle.get("host")), (RdbmsQuery)new MySQLQuery(pickle.geti("port", 0)), (BRdbmsScheme)this);
    }

    public BRdbms newDatabase(BHost host, RdbmsQuery query) {
        MySQLQuery oq = (MySQLQuery)query;
        return new BMySQLDatabase(BOrd.make((String)("ip:" + host.toString())), oq.port);
    }

    public String getAuthName() {
        return "MySQL";
    }

    public OrdQuery parse(String queryBody) {
        return new MySQLQuery(queryBody);
    }

    public Type getType() {
        return TYPE;
    }
}

