/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.mysql;

import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.mysql.BMySQLConnectionPool;
import com.tridium.rdb.mysql.history.BMySQLHistoryDeviceExt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMySQLDatabase
extends BRdbms {
    public static final Property timestampStorage = BMySQLDatabase.newProperty((int)5, (BValue)BRdbmsTimestampStorage.dialectDefault, null);
    public static final Property databaseName = BMySQLDatabase.newProperty((int)0, (String)"", null);
    public static final Property port = BMySQLDatabase.newProperty((int)0, (int)3306, null);
    public static final Property histories = BMySQLDatabase.newProperty((int)0, (BValue)new BMySQLHistoryDeviceExt(), null);
    public static final Property connectionPool = BMySQLDatabase.newProperty((int)4, (BValue)new BMySQLConnectionPool(), null);
    public static final Property extraConnectionProperties = BMySQLDatabase.newProperty((int)0, (String)"", null);
    public static final Property mySqlServerCert = BMySQLDatabase.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:UserTrustCertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"storeId", (BIDataValue)BString.make((String)"USER_TRUST_STORE"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)""))));
    public static final Type TYPE = Sys.loadType(BMySQLDatabase.class);
    private final RdbmsDialect DIALECT = new RdbmsDialect(){

        public String getValidationQuery() {
            return "select 1;";
        }

        public void issueCheckpoint(Connection conn) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return true;
        }

        public boolean supportsBatchUpdate() {
            return true;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 1;
        }

        public String getIdentityCreation() {
            return "AUTO_INCREMENT";
        }

        public String getIdentityLookup() {
            throw new UnsupportedOperationException();
        }

        public String getSequenceName(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getSequenceLookup(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getAlterColumn() {
            return "MODIFY";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return true;
        }

        public String getStringLengthFunctionName() {
            return "CHAR_LENGTH";
        }

        public int getMaxTableName() {
            return 64;
        }

        public int getMaxIndexName() {
            return 64;
        }

        public int getMaxConstraintName() {
            return 64;
        }

        public int getMaxColumnName() {
            return 64;
        }

        public boolean allowsUnicodeNames() {
            return true;
        }

        public String getColumnIdentifier(String schemaName, String tableName, String columnName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName + ".`" + columnName + "`";
            }
            return tableName + ".`" + columnName + "`";
        }

        public String getTableIdentifier(String schemaName, String tableName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName;
            }
            return tableName;
        }

        public String getDropIndex(String tableName, String indexName) {
            return "ALTER TABLE " + tableName + " DROP INDEX " + indexName;
        }

        public String getDropConstraint(String tableName, Constraint constraint) {
            String keyword = "CONSTRAINT";
            if (constraint.getConstraintType() == 1) {
                keyword = "PRIMARY KEY";
            } else if (constraint.getConstraintType() == 2) {
                keyword = "FOREIGN KEY";
            }
            return "ALTER TABLE " + tableName + " DROP  " + keyword + " " + constraint.getName();
        }

        public String getIntType() {
            return "INTEGER";
        }

        public String getLongType() {
            return "BIGINT";
        }

        public String getFloatType() {
            return "FLOAT";
        }

        public String getDoubleType() {
            return "DOUBLE";
        }

        public String getCharType() {
            return BMySQLDatabase.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BMySQLDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
        }

        public String getUuidType() {
            return "BINARY(16)";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            return "TINYINT";
        }

        public String getTimestampType() {
            throw new UnsupportedOperationException();
        }

        public boolean supportsBooleanType() {
            return true;
        }

        public boolean supportsDateType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return false;
        }

        public boolean useUtcTimestamps() {
            return false;
        }

        public String getBlobType() {
            return "MEDIUMBLOB";
        }

        public boolean usesDefaultBlobTranslator() {
            return true;
        }

        public void setBlobValue(RdbmsPreparedStatement prep, int index, byte[] bytes) {
            throw new UnsupportedOperationException();
        }

        public String getClobType() {
            if (!BMySQLDatabase.this.getUseUnicodeEncodingScheme()) {
                return "TEXT";
            }
            return "TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci";
        }

        public boolean usesDefaultClobTranslator() {
            return true;
        }

        public void setClobValue(RdbmsPreparedStatement prep, int index, String str) {
            throw new UnsupportedOperationException();
        }

        public AesSysKeyEncoder getSysEncoder() {
            return BMySQLDatabase.this.getEncoder();
        }

        public String getOnDelete(int onDelete) {
            switch (onDelete) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "NO ACTION";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return false;
        }

        public int getJdbcTypeBlob() {
            return -4;
        }

        public int getJdbcTypeBoolean() {
            return -6;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return -1;
        }

        public int getJdbcTypeDouble() {
            return 8;
        }

        public int getJdbcTypeFloat() {
            return 7;
        }

        public int getJdbcTypeInt() {
            return 4;
        }

        public int getJdbcTypeLong() {
            return -5;
        }

        public int getJdbcTypeTimestamp() {
            return -5;
        }

        public int getJdbcTypeUuid() {
            return -2;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return 91;
        }
    };
    private static String TRUST_STORE_NAME = "rdbMySql";
    private static File RDB_MY_SQL_DIR = new File(Sys.getProtectedStationHome(), "rdbMySql");
    private static SecretChars TRUST_STORE_PASSWORD = BPassword.DEFAULT.getSecretChars();

    public BRdbmsTimestampStorage getTimestampStorage() {
        return (BRdbmsTimestampStorage)this.get(timestampStorage);
    }

    public void setTimestampStorage(BRdbmsTimestampStorage v) {
        this.set(timestampStorage, (BValue)v, null);
    }

    public String getDatabaseName() {
        return this.getString(databaseName);
    }

    public void setDatabaseName(String v) {
        this.setString(databaseName, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public BMySQLHistoryDeviceExt getHistories() {
        return (BMySQLHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BMySQLHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    public BMySQLConnectionPool getConnectionPool() {
        return (BMySQLConnectionPool)this.get(connectionPool);
    }

    public void setConnectionPool(BMySQLConnectionPool v) {
        this.set(connectionPool, (BValue)v, null);
    }

    public String getExtraConnectionProperties() {
        return this.getString(extraConnectionProperties);
    }

    public void setExtraConnectionProperties(String v) {
        this.setString(extraConnectionProperties, v, null);
    }

    public String getMySqlServerCert() {
        return this.getString(mySqlServerCert);
    }

    public void setMySqlServerCert(String v) {
        this.setString(mySqlServerCert, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMySQLDatabase() {
    }

    public BMySQLDatabase(BOrd address, int port) {
        this.setHostAddress(address);
        this.setPort(port);
    }

    public void changed(Property prop, Context cx) {
        if (prop.equals(mySqlServerCert) && this.isRunning()) {
            this.updateMySqlTrustStore(cx);
        }
    }

    public void rdbmsStarted() {
        if (!"".equals(this.getMySqlServerCert())) {
            this.updateMySqlTrustStore(null);
        }
    }

    URI getTrustCertificateKeyStoreURI() {
        return AccessController.doPrivileged(() -> new File(RDB_MY_SQL_DIR, this.getTrustStoreName()).toURI());
    }

    SecretChars getTrustCertificateKeyStorePassword() {
        return TRUST_STORE_PASSWORD;
    }

    String getTrustCertificateKeyStoreType() {
        return SecurityInitializer.getInstance().getCryptoProvider().getDefaultKeyStoreType();
    }

    private synchronized void updateMySqlTrustStore(Context cx) {
        try {
            AccessController.doPrivileged(() -> {
                if (!RDB_MY_SQL_DIR.exists()) {
                    RDB_MY_SQL_DIR.mkdirs();
                }
                return null;
            });
            KeyStore ks = KeyStore.getInstance(this.getTrustCertificateKeyStoreType());
            File trustStoreFile = new File(RDB_MY_SQL_DIR, this.getTrustStoreName());
            AccessController.doPrivileged(() -> {
                try (FileInputStream is = trustStoreFile.exists() ? new FileInputStream(trustStoreFile) : null;){
                    ks.load(is, TRUST_STORE_PASSWORD.get());
                }
                trustStoreFile.deleteOnExit();
                return null;
            });
            X509Certificate cert = null;
            if (!"".equals(this.getMySqlServerCert()) && (cert = CertManagerFactory.getInstance().getUserTrustStore().getCertificate(this.getMySqlServerCert())) == null) {
                throw new CertificateException(this.getLexicon().getText("rdbMysql.error.invalidCertificate", new Object[]{this.getMySqlServerCert(), this.getDisplayName(cx)}));
            }
            if (cert != null) {
                ks.setCertificateEntry(this.getHandleOrd().toString(), cert);
            } else if (ks.containsAlias(this.getHandleOrd().toString())) {
                ks.deleteEntry(this.getHandleOrd().toString());
            }
            AccessController.doPrivileged(() -> {
                try (FileOutputStream fos = new FileOutputStream(trustStoreFile);){
                    ks.store(fos, TRUST_STORE_PASSWORD.get());
                }
                return null;
            });
            if (!this.isFatalFault()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
                this.setFaultCause("");
                this.updateStatus();
            }
        }
        catch (Exception e) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            String faultText = this.getLexicon().getText("rdbMySql.error.selfSignedConfigError", new Object[]{e.getLocalizedMessage()});
            this.setFaultCause(faultText);
            this.getLogger().log(Level.SEVERE, faultText, e);
        }
    }

    private String getTrustStoreName() {
        return TRUST_STORE_NAME + "." + this.getTrustCertificateKeyStoreType();
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbMySQL");
    }

    public Connection getConnection(String userName, BPassword password) throws SQLException {
        if (!this.isRunning()) {
            throw new BajaRuntimeException("Database not running");
        }
        BStatus status = this.getStatus();
        if (status.isFault()) {
            return null;
        }
        return this.getConnectionPool().getConnection(userName, AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }
}

