/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.history;

import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.mobile.BVelocityMobileAppView;
import com.tridium.mobile.history.BMobileHistoryApp;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.WebOp;

public final class BMobileHistoryAppTableView
extends BVelocityMobileAppView {
    public static final BMobileHistoryAppTableView INSTANCE = new BMobileHistoryAppTableView();
    public static final Type TYPE = Sys.loadType(BMobileHistoryAppTableView.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getMobileAppType() {
        return BMobileHistoryApp.TYPE;
    }

    @Override
    protected void doInitNiagaraViewInfo(JSONObject obj, WebOp op) throws Exception {
        BMobileHistoryAppTableView.encodeHistoryToJson(obj, op);
    }

    public BOrd getTemplateFileOrd(WebOp op) {
        return BOrd.make((String)"module://mobile/rc/history/table/historyTable.vm");
    }

    static void encodeHistoryToJson(JSONObject obj, WebOp op) throws JSONException {
        BIHistory history = null;
        HistoryQuery query = null;
        OrdQuery[] queries = op.getOrdQueries();
        for (int i = 0; i < queries.length; ++i) {
            if (!(queries[i] instanceof HistoryQuery)) continue;
            query = (HistoryQuery)queries[i];
            break;
        }
        if (query == null) {
            BObject histObj = op.get();
            if (!(histObj instanceof BHistoryExt)) {
                throw new RuntimeException("Could not retrieve a BIHistory from: " + histObj.getType());
            }
            BHistoryExt histExt = (BHistoryExt)histObj;
            history = histExt.getHistory();
            StringBuffer queryBuff = new StringBuffer();
            queryBuff.append(history.getId().encodeToString());
            query = new HistoryQuery(queryBuff.toString());
        } else {
            BHistoryService histService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            try (HistorySpaceConnection conn = histService.getDatabase().getConnection(null);){
                history = conn.getHistory(query.getHistoryId());
            }
        }
        if (history == null) {
            throw new BajaRuntimeException("Unsupported history source: " + op.getOrd());
        }
        if (!history.canRead((OrdTarget)op)) {
            throw new PermissionException("Invalid security permissons to read history: " + history.getId());
        }
        JSONObject histJson = new JSONObject();
        histJson.put("id", (Object)history.getId().encodeToString());
        histJson.put("displayName", (Object)history.getNavDisplayName((Context)op));
        histJson.put("query", (Object)query.toString());
        obj.put("history", (Object)histJson);
    }
}

